/*  PS_INT.PL  */


/*
SPECIFICATION
-------------
*/


/*
IMPLEMENTATION
--------------

I assume this file will only be used when modules ps and eden
are both loaded.
*/


:- lib(random).


:- quietspy(on).


eps( Bug, World ) :-
    retractall( stm_predicates(_) ),
    retractall( perceptual_predicates(_) ),
    load_program( Bug, _ ),
    eden( psbug, World ).


load_program( Prog, StatusOut ) :-
    find_file( Prog, [ '', '[popx.eden]' ], '.pl', Fullname, Status ),
    (
        Status = ok
    ->
        open_and_reconsult( Fullname, Status )
    ;
        true
    ),
    StatusOut = Status.


psbug :-
    compile_ps( Rules, STM0, ResolutionStrategy ),
    ps( Rules, STM0, fail, ResolutionStrategy, STM ),
    write('Exiting psbug'),nl,
    exit_eden.                    


diagnose( Tag, Message ) :-
    bug_view output( Tag...Message ).


/*
Interface predicates
--------------------
*/


can_see( Obj ) :-
    retina( _, _, Obj ), !.


over( Obj ) :-
    retina( 3, 2, Obj ), !.


next_to( Obj ) :-
    (
        retina( 3, 3, Obj ) ;
        retina( 3, 1, Obj ) ;
        retina( 2, 2, Obj ) ;
        retina( 4, 2, Obj )
    ), !.


holding( Obj ) :-
    inventory( Obj ).


empty :-
    inventory( ' ' ).


move_towards( Obj ) :-
    retina( X, Y, Obj ),
    DX is X - 3,
    DY is Y - 2,
    AbsDX is abs(DX),
    AbsDY is abs(DY),
    (
        AbsDY >= AbsDX
    ->
        ( DY > 0 -> exec([forward]) ; exec([right]),exec([right]),exec([forward]) )
    ;
        ( DX > 0 -> exec([right]) ; exec([left]) )
    ).


turn_towards( Obj ) :-
    retina( X, Y, Obj ),
    DX is X - 3,
    DY is Y - 2,
    AbsDX is abs(DX),
    AbsDY is abs(DY),
    (
        AbsDY >= AbsDX
    ->
        ( DY > 0 -> true ; exec([right]),exec([right]) )
    ;
        ( DX > 0 -> exec([right]) ; exec([left]) )
    ).


facing( Obj ) :-
    retina( 3, 3, Obj ), !.


wander :-
    random_element( [ [[left],[forward]],
                      [[right],[forward]],
                      [[forward],[forward],[forward],[forward],[forward],[forward]]
                    ], E ),
    exec_list( E ).


exec_list( [] ) :- !.

exec_list( [A1|An] ) :-
    exec( A1 ),
    exec_list( An ).


heard( S ) :-
    heard_from(user,Chars),
    Chars \= [],
    chars_to_items( Chars, S ).


reply( S ) :-
    say(user,S).
