/*  PATH_TO_MOVES.PL  */


:- module path_to_moves.


/*
SPECIFICATION
-------------

This module defines a predicate for converting a path, expressed as a
list of points, into a list of bug moves. You supply it with the path
and the bug's initial heading, and it returns a list of actions, and a
new heading.


PUBLIC path_to_moves( Heading+, Path+, NewHeading-, Moves- ):

Heading must be a unit vector giving the bug's current direction.
Path is a list of points. Each point must be horizontally or
vertically adjacent to the next.

The routine returns two results, the new heading, also as a unit vector,
and a list of moves. Each element of this is an atom, one of 'left',
'right', 'forward', or 'back'.

Example:

    path_to_moves( [0, 1],
                   [ [1, 2] [1, 3] [2, 3] [3, 3] [3, 2] ],
                   D,
                   Moves
                 ).
gives
    D = [0 -1]
    Moves = [forward, right, forward, forward, right, forward]
*/


/*
IMPLEMENTATION
--------------

Just calls the Pop-11 routine in PATH_TO_MOVES.P.
*/


:- prolog_language(pop11).
needs path_to_moves;
:- prolog_language(prolog).
:- library(are).


path_to_moves( Heading, Path, NewHeading, Moves ) :-
    [ NewHeading, Moves ] are path_to_moves( Heading, Path ).


:- endmodule.
