/*  FAULT.P  */


section $-fault => FAULT;


/*
SPECIFICATION
-------------

This module exports 'FAULT'. I call this to report "shouldn't happen"
errors, such as 'else' statements that should never be reached. I have
named the routine 'FAULT' to distinguish it from things to do with the
Eden Bug.


PUBLIC FAULT( Message ):

Displays Message (which can be any text), and returns to the Pop
top-level. If FAULT has a second argument, this is printed after the
message. In the current version, FAULT in fact calls 'mishap' (see HELP
MISHAP).
*/


/*
IMPLEMENTATION
--------------

Some slightly messy code to decide which stack elements to put where,
depending on the stack length. Is there a cleaner way to do this?

There is a HELP file for this, HELP FAULT. Keep it in step with the
code.
*/


define global FAULT();
    lvars message, culprits;

    () -> culprits;
    /*  Assume there's more than one argument, so the top one
        is culprits.
    */

    if stacklength() = 0 then
        /*  But if there wasn't, the top one was the message.  */
        culprits -> message;
        [] -> culprits;
    else
        () -> message;
        /*  Otherwise the message is still on the stack.  */
    endif;

    mishap( message><'', culprits )
enddefine;


endsection;
