section $-objects;


/*
Useful routines
---------------
*/


lib objectutils.p;


/*
Output
------
*/


define my_line1() -> items -> format;
    lvars items, format;
    'Action: ~10A    Facing: ~8A Position: ~8A' -> format;
    [% $-eden$-last_action, direction(), '('><bug_xW()><','><bug_yW()><')', %] -> items;
enddefine;


define my_line2() -> items -> format;
    lvars items, format;
    'Inventory: ~10A Here: ~8A   Time: ~8A' -> format;
    [% object_name(inventory()), object_name(object_at_bug()), $-eden$-time %] -> items;
enddefine;


/*
Spaces
------
*/


define nothing(message,id,x,y);
    lvars message, id, x, y;
    switchon message
    case =[forward] then
        obey(bw_forward);
    case =[back] then
        obey(bw_back);
    case =[right] then
        obey(bw_right);
    case =[left] then
        obey(bw_left);
    case =[wait] then
        ;
    else
        ;
    endswitchon;
enddefine;
define_object( "nothing", nothing, ` ` );


/*
Rocks
-----
*/


define boulder(message,id,x,y);
    lvars message, id, x, y;
    switchon message
    case =[forward] orcase =[back] then
        ;
    else
        ;
    endswitchon;
enddefine;
define_object( "boulder", boulder, `*` );


/*
Food
----
*/


define food(message,id,x,y);
    lvars message, id, x, y;
    switchon message
    case =[use] then
;;;        __hunger-1 -> __hunger;
        destroy( id );
    else
        portable(message,id,x,y)
    endswitchon;
enddefine;
define_object( "food", food, `+` );


/*
Doors and keys
--------------
*/


define key(message,id,x,y);
    lvars message, id, x, y;
    lvars next_x, next_y;
    switchon message
    case =[use] then
        one_forward(x,y) -> next_y -> next_x;
        if object_at(next_x,next_y) = `#` then
            destroy( [% next_x, next_y %] );
            destroy( id );
        endif;
    else
        portable(message,id,x,y)
    endswitchon;
enddefine;
define_object( "key", key, `k` );


define door(message,id,x,y);
    lvars message, id, x, y;
    boulder( message, id, x, y );
enddefine;
define_object( "door", door, `#` );


/*
Rocks and hammers
-----------------
*/


define hammer(message,id,x,y);
    lvars message, id, x, y;
    lvars next_x, next_y;
    switchon message
    case =[use] then
        one_forward(x,y) -> next_y -> next_x;
        if object_at(next_x,next_y) = `@` then
            destroy( [% next_x, next_y %] );
        endif;
    else
        portable(message,id,x,y)
    endswitchon;
enddefine;
define_object( "hammer", hammer, `T` );


define rock(message,id,x,y);
    lvars message, id, x, y;
    boulder( message, id, x, y );
enddefine;
define_object( "rock", rock, `@` );


/*
Quicksands
----------
*/


define quicksand(message,id,x,y);
    lvars message, id, x, y;
    switchon message
    case =[forward] orcase =[back] then
        nothing(message,id,x,y)
    else
        kill_bug()
    endswitchon;
enddefine;
define_object( "quicksand", quicksand, `Q` );


/*
Portable things
---------------
*/


define portable(message,id,x,y);
    lvars message, id, x, y;
    switchon message
    case =[forward] then
        obey(bw_forward);
    case =[back] then
        obey(bw_back);
    case =[left] then
        obey(bw_left);
    case =[right] then
        obey(bw_right);
    case =[grab] then
        obey(bw_grab);
    case =[drop] then
        obey(bw_drop);
    endswitchon;
enddefine;


/*
Obey
----
*/


define obey( proc );
    lvars proc;
    proc( $-eden$-world );
enddefine;


endsection;
