/*  BUDGET.PL  */


resolve [r].

stm [budget_needs_more_money].

stm_predicates all.

budget_needs_more_money     =>  tax_increases.
budget_needs_more_money     =>  real_wages_decrease.
tax_increases               =>  workers_incentives_decrease.
real_wages_decrease         =>  workers_incentives_decrease.
workers_incentives_decrease =>  production_decreases.
production_decreases        =>  exports_decrease.
exports_decrease            =>  budget_needs_more_money.


/*
This describes a small portion of what economists call macro-economics:
the relations between inflation, unemployment, etc. The relations are
not at all esoteric, in fact they are taken from "There's a Hole in My
Budget" by Flanders and Swann, in which there is a ``dialogue between
the Prime Minister and Chancellor, who wander round the room in a slow
inflationary spiral''. The song is a take-off of "There's a hole in my
bucket".
*/
