section $-objects => thirst,hunger;


/*
Standard objects
----------------
*/


lib pb_objects.p;


/*
Physiology
----------
*/


vars __hunger, __thirst, __sick;


define my_start1();
    0 -> __hunger;
    50 -> __thirst;
    0 -> __sick;
    0 ->> water_count -> food_count;
    80 -> vedlinemax;
enddefine;


define add_thirst(t);
    lvars t;
    t + __thirst -> __thirst;
    if __thirst > 400 then
        kill( 'You have died of thirst!' );
    endif;
    max( __thirst, 0 ) -> __thirst;
enddefine;


define add_hunger(h);
    lvars h;
    h + __hunger -> __hunger;
    if __hunger > 400 then
        kill( 'You have died of hunger!' );
    endif;
    max( __hunger, 0 ) -> __hunger;
enddefine;


define add_sickness(s);
    lvars s;
    s + __sick -> __sick;
    if __sick > 15 then
        kill( 'You have died of sickness!' );
    endif;
    max( __sick, 0 ) -> __sick;
enddefine;


;;; Called after bug has moved and world has been updated with its action.
;;;
define my_update();
    lvars i, j, id;

    appproperty( $-worlds$-id_to_location,
                 procedure(id,loc);
                     lvars id,loc;
                     lvars i, j;
                     if loc = "inventory" then
                         bug_xW() -> i; bug_yW() -> j;
                     else
                         loc(1) -> i; loc(2) -> j;
                     endif;
                     $-worlds$-message( [update], id, i, j );
                 endprocedure
               );

    if member( $-eden$-last_action, [forward,back,left,right] ) then
        add_hunger(10);
    endif;
    add_hunger(1);

    if member( $-eden$-last_action, [forward,back,left,right] ) then
        add_thirst(10);
    endif;
    add_thirst(2);

    add_sickness(-1);
enddefine;


define my_line1() -> items -> format;
    lvars format, items;
    'Action: ~10A  Facing: ~8APosition: ~7AThirst: ~3A Sick: ~3A' -> format;
    [% trunc($-eden$-last_action,10),
       direction(),
       '('><bug_xW()><','><bug_yW()><')',
       __thirst,
       trunc(__sick,2)
    %] -> items;
enddefine;


define my_line2() -> items -> format;
    lvars format, items;
    lvars s;
    'Inventory: ~8A Here: ~8A  Time: ~7A    Hunger: ~3A' -> format;
    [% object_name(inventory()),
       object_name(object_at_bug()),
       $-eden$-time,
       __hunger
    %] -> items;
enddefine;


/*
Food
----
*/


vars food_ages = newproperty( [], 5, undef, true );
vars food_count;


vars old_food;
food -> old_food;
define food(message,id,x,y,bad);
    lvars message, id, x, y, bad;
    switchon message
    case =[new] then
        $-eden$-time -> food_ages(id);
        1 + food_count -> food_count;
    case =[update] then
        if food_ages(id) < $-eden$-time-50 then
            destroy(id);
            food_count - 1 -> food_count;
        elseif food_ages(id) < $-eden$-time-40 then
            destroy(id);
            new(`-`) -> id;
            place( id, [%x,y%] );
        endif;
    case =[use] then
        old_food(message,id,x,y);
        add_hunger(-300);
        if bad then
            add_sickness(15);
        endif;
    else
        old_food(message,id,x,y);
    endswitchon;
enddefine;
define_object( "food", food(%false%), `+` );
define_object( "bad_food", food(%true%), `-` );


/*
Cleaning
--------
*/


vars water_ages = newproperty( [], 5, undef, true );
vars water_count;


define water(message,id,x,y,bad);
    lvars message, id, x, y, bad;
    switchon message
    case =[new] then
        $-eden$-time -> water_ages(id);
        1 + water_count -> water_count;
    case =[update] then
        if water_ages(id) < $-eden$-time-50 then
            destroy(id);
            water_count - 1 -> water_count;
        endif;
    case =[use] then
        add_thirst(-200);
        if bad then
            add_sickness(15);
        endif;
    case =[defecate] then
        new(`W`) -> newid;
        destroy(id);
        place(newid,[%x,y%]);
        defecate(x,y);
    else
        nothing(message,id,x,y);
    endswitchon;
enddefine;
define_object( "water", water(%false%), `w` );
define_object( "bad_water", water(%true%), `W` );


/*
Excretion
---------
*/


vars faeces_ages = newproperty( [], 5, undef, true );


define faeces(message,id,x,y);
    lvars message, id, x, y;
    switchon message
    case =[new] then
        $-eden$-time -> faeces_ages(id);
    case =[update] then
        if faeces_ages(id) < $-eden$-time-10 then
            destroy(id)
        endif
    else
        portable(message,id,x,y);
    endswitchon;
enddefine;
define_object( "faeces", faeces, `f` );


vars old_nothing;
nothing -> old_nothing;
define nothing(message,id,x,y);
    lvars message, id, x, y;
    lvars r, newid;
    switchon message
    case =[update] then
        if object_at(x,y) = ` ` then
            random(100) -> r;
            if r <= 1 and water_count<5 then
                new(`w`) -> newid;
                place( newid, [%x,y%] );
            elseif r <= 2 and food_count<5 then
                new(`+`) -> newid;
                place( newid, [%x,y%] );
            endif;
        endif;
    case =[defecate] then
        if object_at(x,y) = ` ` then
            old_nothing(message,id,x,y);
            new(`f`) -> newid;
            destroy(id);
            place(newid,[%x,y%]);
            defecate(x,y);
        endif;
    else
        old_nothing(message,id,x,y);
    endswitchon;
enddefine;
define_object( "nothing", nothing, ` ` );


define defecate(x,y);
    lvars x, y;
    add_thirst(20);
enddefine;


/*
New actions
-----------
*/


define_action( "defecate" );


/*
Procs
-----
*/


define global thirst(); __thirst enddefine;

define global hunger(); __hunger enddefine;


endsection;


define change_to_pop__(dummy);
    lvars dummy;
    pop_section -> current_section;
enddefine;


:- prolog_language(prolog).

:- prolog_eval(change_to_pop__(0)),
   retractall(( thirst(_) )),
   retractall(( hunger(_) )),
   assert(( thirst(T) :- prolog_eval(apply(valof(thirst)),T) )),
   assert(( hunger(H) :- prolog_eval(apply(valof(hunger)),H) )).

:- prolog_language(pop11).
