/*  EDEN.PL  */


/*
SPECIFICATION
-------------

This is the master file which load the code for Eden.
*/


/*
IMPLEMENTATION
--------------

I name this file EDEN so that it has an obvious name. However, I want it
to be separate from the main body of Eden: that's why the latter is
called EDEN_CORE.
*/


/*  I don't use the Poplog 'module' facility because I've had some
    problems with it, and I'm not sure exactly how it switches
    contexts when calling from a predicate exported from one module
    to one defined in another. (See also the note in EDEN_CORE.P
    about 'eden'.) However, I put 'module' and 'public' directives
    at the head of all my modules to help those who will use
    a module system, whether Poplog's or someone else's. The
    declaration below makes them all dummy operators.

    For more information on programming style, see the text file
    STYLE.
*/
:- op( 253, fx, [module, public, dynamic, needs]).


/*  (1) Load the Pop-11 code for Eden.
    (2) Extend the Prolog library list with the current directory.
        This is done only so that I can use the Poplog built-in
        predicate 'library' to load my own files. You can omit it.
*/
:- prolog_language(pop11).
lib needs;
lib eden_core;
:- prolog_language(prolog).


/*  Load the Prolog interface to Eden, EDEN_CORE.PL. Also the
    'lib' module which I use.
*/
:- reconsult('eden$src:lib.pl').
:- reconsult('eden$src:eden_core').
