/*  CHARS_TO_ITEMS.P  */


section $-chars_to_items => chars_to_items;


/*
SPECIFICATION
-------------

This module exports a routine for converting a list of characters into
a list of items. It is useful for itemising sentences read by a bug.

PUBLIC chars_to_items( chars ):

chars is a list or vector of characters, or a string. The result is the
corresponding list of Pop-11 items.
*/


/*
IMPLEMENTATION
--------------

Convert the argument to a string, then use stringin and incharitem on
that. Probably not the most efficient method.
*/


define global chars_to_items( chars );
    lvars chars;
    lvars proc, item;

    incharitem(stringin(cons_with consstring{%explode(chars)%})) -> proc;
    [% until ( proc()->item; item=termin ) do item enduntil %]
enddefine;


endsection;
