/*  DEFAULTOBJECTS.P  */


section $-eden;


define nothing(context);
    lvars context;
    switchon context
    case ="forward_held" then "continue"
    case ="forward_ext" then "continue"
    case ="back_held" then "continue"
    case ="back_ext" then "continue"
    case ="grab_held" then "continue"
    case ="grab_ext" then "fail"
    case ="drop_held" then "fail"
    case ="drop_ext" then "continue"
    case ="left_held" then "continue"
    case ="left_ext" then "continue"
    case ="right_held" then "continue"
    case ="right_ext" then "continue"
    case ="use_held" then "continue"
    case ="use_ext" then "continue"
    case ="wait_held" then "continue"
    case ="wait_ext" then "continue"
    endswitchon;
enddefine;



define boulder(context);
    lvars context;                    
    switchon context
    case ="forward_held" then "fail"
    case ="forward_ext" then "fail"
    case ="back_held" then "fail"
    case ="back_ext" then "fail"
    case ="grab_held" then "fail"
    case ="grab_ext" then "fail"
    case ="drop_held" then "fail"
    case ="drop_ext" then "fail"
    case ="left_held" then "fail"
    case ="left_ext" then "fail"
    case ="right_held" then "fail"
    case ="right_ext" then "fail"
    case ="use_held" then "continue"
    case ="use_ext" then "continue"
    case ="wait_held" then "continue"
    case ="wait_ext" then "continue"
    endswitchon;
enddefine;


define rock(context);
    lvars context;
    switchon context
    case ="forward_held" then "fail"
    case ="forward_ext" then "fail"
    case ="back_held" then "fail"
    case ="back_ext" then "fail"
    case ="grab_held" then "fail"
    case ="grab_ext" then "fail"
    case ="drop_held" then "fail"
    case ="drop_ext" then "fail"
    case ="left_held" then "fail"
    case ="left_ext" then "fail"
    case ="right_held" then "fail"
    case ="right_ext" then "fail"
    case ="use_held" then "continue"
    case ="use_ext" then "continue"
    case ="wait_held" then "continue"
    case ="wait_ext" then "continue"
    endswitchon;
enddefine;


define hammer(context);
    lvars context, next_xW, next_yW;
    switchon context
    case ="forward_held" then "continue"
    case ="forward_ext" then "continue"
    case ="back_held" then "continue"
    case ="back_ext" then "continue"
    case ="grab_held" then "fail"
    case ="grab_ext" then "continue"
    case ="drop_held" then "continue"
    case ="drop_ext" then "fail"
    case ="left_held" then "continue"
    case ="left_ext" then "continue"
    case ="right_held" then "continue"
    case ="right_ext" then "continue"
    case ="use_held" then
        one_forward(bug_xW(),bug_yW()) -> next_yW -> next_xW;   ;;; If the bug is standing
        if world(next_xW,next_yW)=`@` then                      ;;; in front of a rock
            place_object_at(next_xW,next_yW,` `)                ;;; then smash it with
        endif;                                                  ;;; hammer!
        "continue"
    case ="use_ext" then "continue"
    case ="wait_held" then "continue"
    case ="wait_ext" then "continue"
    endswitchon;
enddefine;


define door(context);
    lvars context;
    switchon context
    case ="forward_held" then "fail"
    case ="forward_ext" then "fail"
    case ="back_held" then "fail"
    case ="back_ext" then "fail"
    case ="grab_held" then "fail"
    case ="grab_ext" then "fail"
    case ="drop_held" then "fail"
    case ="drop_ext" then "fail"
    case ="left_held" then "fail"
    case ="left_ext" then "fail"
    case ="right_held" then "fail"
    case ="right_ext" then "fail"
    case ="use_held" then "continue"
    case ="use_ext" then "continue"
    case ="wait_held" then "continue"
    case ="wait_ext" then "continue"
    endswitchon;
enddefine;


define key(context);
    lvars context,next_xW,next_yW;
    switchon context
    case ="forward_held" then "continue"
    case ="forward_ext" then "continue"
    case ="back_held" then "continue"
    case ="back_ext" then "continue"
    case ="grab_held" then "fail"
    case ="grab_ext" then "continue"
    case ="drop_held" then "continue"
    case ="drop_ext" then "fail"
    case ="left_held" then "continue"
    case ="left_ext" then "continue"
    case ="right_held" then "continue"
    case ="right_ext" then "continue"
    case ="use_held" then
        one_forward(bug_xW(),bug_yW()) -> next_yW -> next_xW;   ;;; If the bug is standing
        if world(next_xW,next_yW)=`#` then
            drop();                                         ;;; in front of a door
            place_object_at(next_xW,next_yW,` `);           ;;; then open it with
                                                            ;;; key. Key disappears                
        endif;
        "continue"
    case ="use_ext" then "continue"
    case ="wait_held" then "continue"
    case ="wait_ext" then "continue"
    endswitchon;
enddefine;


define food(context);
    lvars context;
    switchon context
    case ="forward_held" then "continue"
    case ="forward_ext" then "continue"
    case ="back_held" then "continue"
    case ="back_ext" then "continue"
    case ="grab_held" then "fail"
    case ="grab_ext" then "continue"
    case ="drop_held" then "continue"
    case ="drop_ext" then "fail"
    case ="left_held" then "continue"
    case ="left_ext" then "continue"
    case ="right_held" then "continue"
    case ="right_ext" then "continue"
    case ="use_held" then
        fed();
        "continue"
    case ="use_ext" then "continue"
    case ="wait_held" then "continue"
    case ="wait_ext" then "continue"
    endswitchon;
enddefine;


define quicksand(context);
    lvars context;
    switchon context
    case ="forward_held" then "continue"       ;;; With quicksand, doing
    case ="forward_ext" then "continue"      ;;; anything other than moving
    case ="back_held" then "continue"      ;;; straight on causes the bug
    case ="back_ext" then "continue"     ;;; to sink and drown!
    case ="grab_held" then "fail"
    case ="grab_ext" then
        kill();
        "fail"
    case ="drop_held" then "continue"
    case ="drop_ext" then
        kill();
        "fail"
    case ="left_held" then "continue"
    case ="left_ext" then
        kill();
        "fail"
    case ="right_held" then "continue"
    case ="right_ext" then
        kill();
        "fail"
    case ="use_held" then "continue"
    case ="use_ext" then
        kill();
        "continue"
    case ="wait_held" then "continue"
    case ="wait_ext" then
        kill();
        "continue"
    endswitchon;
enddefine;


define narrows(context);
    lvars context;
    switchon context
    case ="forward_held" then "fail"
    case ="forward_ext" then
        if inventory()/=` ` then "fail"
        else "continue"
        endif
    case ="back_held" then "fail"
    case ="back_ext" then
        if inventory()/=` ` then "fail"
        else "continue"
        endif
    case ="grab_held" then "fail"
    case ="grab_ext" then "fail"
    case ="drop_held" then "fail"
    case ="drop_ext" then "fail"
    case ="left_held" then "fail"
    case ="left_ext" then "continue"
    case ="right_held" then "fail"
    case ="right_ext" then "continue"
    case ="use_held" then "continue"
    case ="use_ext" then "continue"
    case ="wait_held" then "continue"
    case ="wait_ext" then "continue"
    endswitchon;
enddefine;

define unknown(context);             ;;; If somehow the bug comes across
    lvars context;                   ;;; an undefined object, this
    switchon context                 ;;; description will be used as a
    case ="forward_held" then "fail"    ;;; default. (same as a boulder in fact)
    case ="forward_ext" then "fail"
    case ="back_held" then "fail"
    case ="back_ext" then "fail"
    case ="grab_held" then "fail"
    case ="grab_ext" then "fail"
    case ="drop_held" then "fail"
    case ="drop_ext" then "fail"
    case ="left_held" then "fail"
    case ="left_ext" then "fail"
    case ="right_held" then "fail"
    case ="right_ext" then "fail"
    case ="use_held" then "continue"
    case ="use_ext" then "continue"
    case ="wait_held" then "continue"
    case ="wait_ext" then "continue"
    endswitchon;
enddefine;


newproperty([[` ` {%"nothing",nothing%}]
             [`*` {%"boulder",boulder%}]
             [`@` {%"rock",rock%}]
             [`T` {%"hammer",hammer%}]
             [`#` {%"door",door%}]
             [`k` {%"key",key%}]
             [`:` {%"narrows",narrows%}]
             [`+` {%"food",food%}]
             [`Q` {%"quicksand",quicksand%}]],
              100,{%"unknown",unknown%},true)->
    objects;


endsection;
