/*  TALK_BUG.PL  */


/*
This is a bug which heads towards the food until in the same square,
same square, then grabs it, and then uses it. In doing this, it's like
the bug in VERY_SIMPLE_BUG.PL. However, it also can reply to sentences,
and so demonstrates the use of sentence(), say(), and chars_to_items().

It starts by converting the sentence to items, using
chars_to_items(sentence()). The result is assigned to 'sent'. It then
compares this against two lists:
    [ where, is, the, food, ? ]
    [ what, are, you, holding, ? ]
and, if it is the same as either, gives an appropriate reply, using say().
*/


start_thinking.


think( Action ) :-
    sentence( SChars ),
    chars_to_items( SChars, SItems ),
    smell( Smell ),
    inventory( I ),

    (
        SItems = [ where, is, the, food, ? ]
    ->
        say( [ the, food, is, Smell ] )
    ;
        SItems = [ what, are, you, holding, ? ]
    ->
        (
            I = ' '
        ->
            say( [ i, am, holding, nothing ] )
        ;
            say( [ i, am, holding, I ] )
        )
    ;
        true
    ),

    (
        I = (+)
    ->
        Action = use
    ;
        Smell = here
    ->
        Action = grab
    ;
        Action = Smell
    ).


bugdead( _, rerun ).
