/*  LOAD_FILE.P  */


section $-load_file => load_file;


/*
SPECIFICATION
-------------

This module exports a procedure to load a library file. In Eden,
I use it for loading worlds and the code of bugs.


PUBLIC load_file( file, ext, proc, list ):

-file- is the name of a file; it must be a string or word.
-ext- is an extension.
-proc- is a procedure of two arguments.

-load_file- looks for the file in -list-, which must be something like
-popuseslist- or -popliblist-. It examines each directory in turn. If it
finds the file, it calls
    proc( file, fn )
where -fn- is the file's full name, as returned by -readable-, and then
returns. -proc- may leave results on the stack, in which case they'll be
returned by -load_file-. If the file can't be found, -load_file- returns
-false-.

If the file has no extension, the extension is defaulted to -ext-. This
should contain the dot.
*/


/*
IMPLEMENTATION
--------------

I'm sure there's a system routine to do it, but I can't find it. The
code works under VMS, but I don't know about Unix.

Note that the spec in REF SYSIO is wrong. This says that sys_file_match
returns -false- instead of a repeater if the filename is invalid. In
fact, it returns -false- even if the filename is valid, but the file
doesn't exist.
*/


define global load_file( File, Ext, Proc, List );
    lvars File, Ext, Proc, List;               
    lvars Dir, FullName, Repeater;

    for Dir in List do
        sys_file_match( File><'', Dir><'*'><Ext, false, false ) ->
          Repeater;

        if Repeater = false then
            nextloop
        else
            Repeater() -> FullName;
            if FullName /= termin then
                return( Proc( File, FullName ) );
            endif;
        endif;
    endfor;

    return( false );
enddefine;


endsection;
