/*  COMPETITION_INTERFACE.P  */


section $-eden => bug_next_world, bug_start_world;


/*
SPECIFICATION
-------------

This module defines the Eden competition interface to 'bugdead'. It
defines the routine
    bug_next_world()
which your 'bugdead' should call if it wants to move to the next world.

We will supply our own definitions of this routine when testing bugs
on the competition worlds. The definitions here apply to the training
worlds, and are supplied so that you can use the same interface.

You should also arrange that your 'start_thinking' routine calls
    bug_start_world()
to initialise the world counter used by bug_next_world.


PUBLIC bug_start_world():

Initialises the world counter: call it from 'start_thinking'.                   


PUBLIC bug_next_world():

Returns a result telling 'bugdead' to move to the next world.    
*/


/*
IMPLEMENTATION
--------------

We keep an internal counter which is started at 1, indicating the number
of the next competition world to be tried. bug_next_world() advances
this, and returns a list of the form
    [% "rerun", 'twN' %]
where N is the counter's new value. See HELP BUGDEAD for a specification
of bugdead's results.
*/


vars current_world;    


define bug_start_world();
    1 -> current_world;
enddefine;


define bug_next_world();
    if current_world = 20 then
        FAULT( 'bug_next_world: no next world, so quitting' );
        exitfrom( eden );
    else
        1 + current_world -> current_world;
        [% "rerun", 'tw'><current_world %]
    endif;
enddefine;


endsection;
