/*  PSE_BUG.P  */


/*
This module defines a bug which uses the production system in LIB
PRODSYS, described in HELP PRODSYS. It works in a similar way to
PS_BUG.P, but allows the production system to act more realistically,
running continuously on a memory which is repeatedly updated by new
perceptions. To do this, it also uses LIB EXEC.
*/


/*
Rules
-----
*/


needs prodsys;
needs exec;


nil->rulebase;

true->repeating; 
false->chatty;


rule 1 [smell here];
    exec( "grab" );
endrule;


rule 2 [inventory `+`];
    exec( "use" );
endrule;


rule 3 [smell ?direction];
    exec( direction );
endrule;


/*
Interfacing Bug's perceptions with the database
-----------------------------------------------
*/


define perceptions_to_database();
    perceptions_to_list() -> database;
enddefine;


define perceptions_to_list();
    [ ^^(retina_to_list()) ^(sentence_to_list())
      ^(smell_to_list()) ^(inventory_to_list())
      ^(energy_to_list()) 
    ]
enddefine;


define retina_to_list();
    lvars i, j, c;
    [%  for i to 5 do
            for j to 7 do
                if ( retina()(i,j) ->> c ) /= ` ` then
                    [ see ^i ^j ^c ]
                endif;
            endfor;
        endfor;
    %]
enddefine;


define sentence_to_list();
    [ sentence ^(sentence()) ]
enddefine;


define smell_to_list();
    [ smell ^(smell()) ]
enddefine;


define inventory_to_list();
    [ inventory ^(inventory()) ]
enddefine;


define energy_to_list();
    [ energy ^(energy()) ]
enddefine;


define clear_perceptions_from_database();
    flush( [ see = = = ] ); 
    flush( [ sentence = ] );
    flush( [ smell = ] );
    flush( [ inventory = ] );
    flush( [ energy = ] );
enddefine;


/*
Brain
-----

I was worried that PRODSYS might not like having the database changed
under it as 'think' does. However, it seems to be OK, provided that
'repeating' is set to true. Otherwise, 'run' exits on the first
resumption, presumably because it doesn't realise that the database has
changed.
*/


vars brain;


define start_thinking();
    proc_to_process( run ) -> brain;
enddefine;


define bugdead( success );
    lvars success;
    start_thinking();
    "rerun"
enddefine;


define think();
    clear_perceptions_from_database();
    perceptions_to_database();
    restart_process( brain );
enddefine;
