/*  EXEC_BUG.P  */


/*
This is a bug which heads towards the food until in the same square,
same square, then grabs it, and then uses it. In doing this, it's like
the bug in VERY_SIMPLE_BUG.P. However, it uses processes, and so
demonstrates the use of EXEC.P.

The ``brain'' procedure is -brain-. This, as far as it is concerned,
runs continuously in a repeat loop, and calls -exec- everytime it
decides to obey an action.

-start_thinking- makes -brain- into a process or coroutine, and assigns
it to the global variable -co-. Each time -think- is called, it
restarts -co-, causing it to run until it calls -exec- to return an
action.

-bug_dead- calls -start_thinking- before returning its result. This
ensures that on reincarnation, -co- contains a new brain process which,
once again, would run from the beginning. This is necessary because
-brain- is ``used up'' after each life.
*/


needs exec;


vars co;


define start_thinking();
    proc_to_process( brain ) -> co;
enddefine;


define think();
    restart_process( co );
enddefine;


define brain();
    repeat
        if inventory() = `+` then
            exec( "use" )
        elseif smell() = "here" then
            exec( "grab")
        else
            exec( smell() )
        endif;
    endrepeat;
enddefine;


define bugdead();
    start_thinking();
    "rerun";
enddefine;
