/*  ADD_FILE_DEFAULTS.P  */


section $-add_file_defaults => add_file_defaults;


/*
SPECIFICATION
-------------

This module exports a routine for adding directory and extension
defaults to a filename.


PUBLIC add_file_defaults( directory, filename, extension ):

directory, filename, and extension are strings. If name doesn't
include a directory/extension of its own, add them as appropriate
and return the result.

Example:

    add_file_defaults( '[popx]', 'ds22:[fred]bug', '.p' ) =>
    ** ds22:[fred]bug.p
*/


/*
IMPLEMENTATION
--------------

Uses sysfileparse - see REF SYSIO. This is probably not portable to
non-VMS systems without a slight change.
*/


define global add_file_defaults( Directory, Name, Extension );
    lvars Directory, Name, Extension;
    lvars Parts;
    sysfileparse( Name ) -> Parts;
    Parts(1) ><
    Parts(2) ><
    if Parts(3) = '' then Directory else Parts(3) endif ><
    Parts(4) ><
    if Parts(5) = '' then Extension else '.'><Parts(5) endif ><
    Parts(6)
enddefine;


endsection;
