;;; -*- Mode:Common-Lisp; Package:NISP; Base:10 -*-
;;; NILS file-hacking stuff, including: pathname stuff, Nisp logical
;;; names, DSKLAP, DEPENDS-ON, and SLURP.
;;; Copyright (C) 1988, Drew McDermott, Yale University (see "copyright" file).
(IN-PACKAGE :NISP)

(DEFUN CONS-PATHNAME (&OPTIONAL HOST DEV DIR NAME TYPE VER)
   (MAKE-PATHNAME :HOST      HOST
		  :DEVICE    DEV
		  :DIRECTORY DIR
		  :NAME      NAME
		  :TYPE      TYPE
		  :VERSION   VER
		  ))

(DEFUN IS-PATHNAME (X) (PATHNAMEP X))

; PATHNAME-NAME coerced to symbol.
(DEFUN PATHNAME-KERNEL (PN)
   (LET ((N (PATHNAME-NAME PN)))
      (COND ((OR (NULL N) (EQUAL N "")) NIL)
            ((IS-SYMBOL N) N)
            ((STRINGP N)
	     (STRING->SYMBOL
	      ;; if default case lower make uppercase symbol name
	      ;; unless string includes some uppercase (e.g."Mixed")
	      (COND ((AND (EQ HOST-FILENAME-CASE* 'LOWER)
			  (NOTANY #'IS-UPPER-CASE N))
		     (STRING-UPCASE N))
		    (T N)   )))
	    (T (EARROR PATHNAME-KERNEL NIL
		       "Can't coerce " N " to pathname kernel")))))

(SUBR-SYNONYM 'PATHNAME->STRING 'NAMESTRING)

(DEFUN ->PATHNAME (X)
   (COND ((IS-PATHNAME X) X)
         (T
          (LET ((IS-SYM (IS-SYMBOL X)) (S X))
             (COND (IS-SYM (SETF S (SYMBOL->STRING X)))   )
             (COND ((IS-STRING S)
                    (DO ((I 0 (+ I 1)))
                        ((OR (= I (STRING-LENGTH S))
                             (MEMBER= #'CHAR= (STRING-ELT S I)   ;moved 7.25.88
                                                    '(#\: #\/)))
                         (COND ((AND (> I 0)
                                     (< I (STRING-LENGTH S)))
                                (CHECK-FOR-NISP-LOGICAL-PATHNAME S I IS-SYM X))
                              (T (CHECK-CASE-PATHNAME S IS-SYM X))   ))
                     ))
                   (T (EARROR ->PATHNAME NIL
                         "Can't coerce " X " to pathname"))   )))   ))


; Given a string S with a colon at position I, see if you can extract a Nisp
; logical name.
(DEFUN CHECK-FOR-NISP-LOGICAL-PATHNAME (S I WAS-SYM X)
   (LET ((PREF (STRING->SYMBOL (STRING-SUBSEQ S 0 I))))
      (SETF I (+ I 1))
      (SETF PREF (PROP 'LOGICAL-NAME PREF))
      (COND (PREF
             (COND ((< I (STRING-LENGTH S))
                    (MERGE-PATHNAMES
                       (->PATHNAME
                            (STRING-SUBSEQ S I (STRING-LENGTH S)))
                       PREF))
                   (T PREF)   ))
            (T (CHECK-CASE-PATHNAME S WAS-SYM X))   )))

;;;--don't convert to lower case when name already contains a lower case
;;;--letter. presumably, when that happens, case is meaningful and should
;;;--not be altered. --Denys 7/21/89
(DEFUN CHECK-CASE-PATHNAME (S WAS-SYM WHICH-SYM)
  (LET ((PN (PATHNAME S)))
     (LET ((STR (PATHNAME-NAME PN)))
	(COND ((AND WAS-SYM
		    (IS-STRING STR)
		    (EQ HOST-FILENAME-CASE* 'LOWER)
		    (EQUAL STR (SYMBOL->STRING WHICH-SYM))
		    (LOOP FOR ((I = 0 TO (- (STRING-LENGTH STR) 1)))
		      RESULT '#T
		      UNTIL (IS-LOWER-CASE (CHAR STR I))
		      RESULT '#F))
	       (CONS-PATHNAME (PATHNAME-HOST PN)
			      (PATHNAME-DEVICE PN)
			      (PATHNAME-DIRECTORY PN)
			      (STRING-DOWNCASE STR)
			      (PATHNAME-TYPE PN)
			      (PATHNAME-VERSION PN))) 
	      (T PN)   ))))

;    (COND ((AND WAS-SYM
;		(EQ HOST-FILENAME-CASE* 'LOWER)
;		(LOOP FOR ((I = 0 TO (- (STRING-LENGTH (PATHNAME-NAME S)) 1))
;			   (STR (PATHNAME-NAME S)))
;		  RESULT '#T
;		  UNTIL (IS-LOWER-CASE (CHAR STR I))
;		  RESULT '#F))
;	   (LET ((N (PATHNAME-NAME PN)))
;	     (COND ((IS-STRING N) (SETF N (STRING->SYMBOL N)))   )
;	     (COND ((AND (IS-SYMBOL N)
;			 (EQ N WHICH-SYM))
;		    (CONS-PATHNAME (PATHNAME-HOST PN)
;				   (PATHNAME-DEVICE PN)
;				   (PATHNAME-DIRECTORY PN)
;				   (STRING-DOWNCASE (SYMBOL->STRING N))
;				   (PATHNAME-TYPE PN)
;				   (PATHNAME-VERSION PN)))
;		   (T PN)   )))
;	  (T PN)   )))

;; Exclude from Explorer version if Zetalisp overlap causes problems
;!S(- TI)
(SUBR-SYNONYM 'PROBEF 'PROBE-FILE)

(DEFUN EVALFILE (FNAME)
   (LET ((*LOAD-VERBOSE* NIL)
         (*PACKAGE* (FIND-PACKAGE :NISP))
         (*READTABLE* NISP-READ-TABLE*))
      (WITH-OPEN-FILE (FS FNAME :DIRECTION :INPUT :ELEMENT-TYPE :STRING-CHAR)
         (LOAD FS)   )))

!S(- TI)
(SUBR-SYNONYM 'LOADOREVAL 'LOAD)
!S(TI)
(DEFUN LOADOREVAL (FNAME)
   (LOAD FNAME :VERBOSE NIL))                    ; Gets rid of annoying Explorer message ** Firby


(DEFMACRO WITH-INPUT-FROM-FILE (S FNAME . BODY)
   `(WITH-OPEN-FILE (,S (->PATHNAME ,FNAME) ':DIRECTION ':INPUT)
       . ,BODY)   )

(DEFMACRO WITH-OUTPUT-TO-FILE (S FNAME . BODY)
   `(WITH-OPEN-FILE (,S (->PATHNAME ,FNAME) ':DIRECTION ':OUTPUT ':IF-EXISTS ':NEW-VERSION)
       . ,BODY)   )
