;;; -*- Mode:Common-Lisp; Package:NISP; Base:10 -*-
;;; Copyright (C) 1988, Drew McDermott, Yale University (see "copyright" file).
(IN-PACKAGE :NISP)

; All objects in the CL version must :INCLUDE this
(NEEDED-BY-MACROS
(DEFSTRUCT (OBJECT-KERNEL
	    (:PREDICATE IS-OBJECT)
	    (:CONSTRUCTOR MAKE-OBJECT-KERNEL (HANDLER))
	    (:PRINT-FUNCTION (LAMBDA (OB STR LEV)
				(DECLARE (LISP:IGNORE LEV))
				(LET ((PMETH (GET-METHOD OB 'PRINT)))
				   (COND (PMETH (FUNCALL PMETH OB STR))
					 (T
					  (SRMMSG STR "#{OBJECT}"))   )))))
   HANDLER   )
)

(DEFSTRUCT (ANON-OBJECT 
	    (:INCLUDE OBJECT-KERNEL)
	    (:CONSTRUCTOR MAKE-ANON-OBJECT (HANDLER SLOTS))
	    (:PRINT-FUNCTION (LAMBDA (OB STR LEV)
				(DECLARE (LISP:IGNORE LEV))
				(LET ((PMETH (GET-METHOD OB 'PRINT)))
				   (COND (PMETH (FUNCALL PMETH OB STR))
					 (T
					  (SRMMSG STR "#{OBJECT}"))   )))))
   SLOTS   )

; (MAKE-OBJECT clauses -vals-) makes an anonymous object with elements vals.
(DEFMACRO MAKE-OBJECT (CLAUSES . VALS)
   `(MAKE-ANON-OBJECT ,(HANDLER-MAKER CLAUSES) (VECTOR . ,VALS))   )

(DEFMACRO OBREF (ANON I) `(VREF (ANON-OBJECT-SLOTS ,ANON) ,I)   )

(DEFMACRO NISPDEFCLASS (&REST STUFF) `(DEFCLASS ,@STUFF))
(DEFMACRO DEFNISPCLASS (&REST STUFF) `(DEFCLASS ,@STUFF))

; (DEFCLASS name clauses -slots-) defines a structure type with an optional
; handler for T-style operations.

(DEFMACRO DEFCLASS (NAME CLAUSES &REST SLOTS)
   (COND ((IS-SYMBOL NAME)
	  (LET ((PRINTER (ASSQ 'PRINT CLAUSES))
		(SLOTNAMES (FOR (S IN SLOTS)
				(SAVE (COND ((ATOM S) S)
				            (T (CAR S))   )))))
	     (COND (PRINTER (SETF CLAUSES (REM1Q PRINTER CLAUSES)))   )
	     ;(COND ((AND PRINTER CLAUSES)
	;	    (SRMMSG (ERROUT) "Warning-- Structure class " NAME " has"
	;		    " printer and handler -- ignoring printer" T))   )
	     (COND (PRINTER
		    (SETF PRINTER `((:PRINT-FUNCTION 
					(LAMBDA (,@(CADR PRINTER) 
						 IGNORE-LEVEL)
					   (DECLARE (LISP:IGNORE IGNORE-LEVEL))
					   . ,(CDDR PRINTER)  )))))   )
	     (COND (CLAUSES
		    `(DEFSTRUCT (,NAME
				 (:INCLUDE OBJECT-KERNEL)
				 (:CONSTRUCTOR 
				    ,(SYMBOL MAKE- (< NAME)) 
				    (,@SLOTNAMES 
				     &AUX (HANDLER ,(HANDLER-MAKER CLAUSES))))
				 (:PREDICATE ,(SYMBOL IS- (< NAME))) ,@PRINTER)
			. ,SLOTS))
		   (T
		    `(DEFSTRUCT (,NAME 
				 (:CONSTRUCTOR ,(SYMBOL MAKE- (< NAME)) 
					       ,SLOTNAMES)
				 (:PREDICATE ,(SYMBOL IS- (< NAME)))
				 ,@PRINTER)
			 . ,SLOTS))   )))
	 (T (EARROR DEFCLASS NIL "Nonatomic class name: " NAME))   ))

; 87.9.30 Changed ignore to lisp:ignore
(DEFMACRO DECLARE-CLASS (NAME CLAUSES &REST SLOTS)
   `(DEFCLASS ,NAME ,(MAPELTLIST (\\ (C) 
				   `(,(CAR C) ,(CADR C) 
				     (IGNORE . ,(CADR C))
				     NIL)   )
		                 CLAUSES)
	      . ,SLOTS)   )

(DEFUN HANDLER-MAKER (CLAUSES)
   `#'(LAMBDA (OP) 
	  (SELQ OP 
	     ,@(MAPELEMLIST #'(LAMBDA (C) `(,(CAR C)
					    #'(LAMBDA . ,(CDR C)  ))   )
			    CLAUSES)
	     (T NIL)   )))

(DEFMACRO DEFOP (NAME ARGL &REST BODY)
   (MULTIPLE-VALUE-LET (D BODY) (DECLARATIONS-SEPARATE BODY)
      `(DEFUN ,NAME ,ARGL 
	  ,@D
	  (LET ((OPMETH (GET-METHOD ,(CAR ARGL) ',NAME)))
	     (COND (OPMETH ,(MAKE-FUNCALL 'OPMETH ARGL))
		   (T . ,BODY)   )))   ))

(DEFUN MAKE-FUNCALL (FNAME ARGNAMES)
   (LET ((L (MEMQ '&REST ARGNAMES)))
      (COND (L `(APPLY ,FNAME ,@(LDIFF ARGNAMES L) ,(CADR L)))
	    (T `(FUNCALL ,FNAME . ,ARGNAMES))   )))

(DEFUN GET-METHOD (OB OP)
   (AND (IS-OBJECT OB) (FUNCALL (OBJECT-KERNEL-HANDLER OB) OP))   )
