;;; -*- Mode:Common-Lisp; Package:NISP; Base:10 -*-
;;; Copyright (C) 1988, Drew McDermott, Yale University (see "copyright" file).
(IN-PACKAGE :NISP)

;(PROCLAIM '(OPTIMIZE (SPEED 3) (SAFETY 0)))

(DEFUN READMAC (CHAR FN)
   (COND ((IS-SYMBOL CHAR) (SETF CHAR (STRING-ELT (SYMBOL->STRING CHAR) 0)))   )
   (SET-MACRO-CHARACTER CHAR
                        (\\ (S C)
                           (IGNORE C)
                           (FUNCALL FN S)   )
                        T
                        NISP-READ-TABLE*)   )

;;; ==================================== IO

(DEFUN OPENI (FNAME) (OPEN FNAME :DIRECTION :INPUT))

(DEFUN OPENO (FNAME)
   (OPEN FNAME :DIRECTION :OUTPUT :IF-EXISTS :NEW-VERSION))

(SUBR-SYNONYM 'CLOSEI 'CLOSE)
(SUBR-SYNONYM 'CLOSEO 'CLOSE)

(DEFVAR EOF* (LIST NIL))
(DEFUN EOF\? (X) (EQ X EOF*))
(DEFUN IS-EOF (X) (EQ X EOF*))

(DEFUN STDIN () *TERMINAL-IO*)
(DEFUN STDOUT () *STANDARD-OUTPUT*)
(DEFUN ERROUT () *ERROR-OUTPUT*)

(DEFVAR TTYIN* (MAKE-SYNONYM-STREAM '*QUERY-IO*))
(DEFVAR TTYOUT* (MAKE-SYNONYM-STREAM '*QUERY-IO*))

(DEFUN STDIN-SET (STREAM) (SETQ *STANDARD-INPUT* STREAM))
(DEFUN STDOUT-SET (STREAM) (SETQ *STANDARD-OUTPUT* STREAM))
(DEFUN ERROUT-SET (STREAM) (SETQ *ERROR-OUTPUT* STREAM))

(DEFMACRO REBIND-STDIN (STREAM &BODY BODY)
  `(LET ((*STANDARD-INPUT* ,STREAM)) . ,BODY))

(DEFMACRO REBIND-STDOUT (STREAM &BODY BODY)
  `(LET ((*STANDARD-OUTPUT* ,STREAM)) . ,BODY))

(DEFMACRO REBIND-ERROUT (STREAM &BODY BODY)
  `(LET ((*ERROR-OUTPUT* ,STREAM)) . ,BODY))

(DEFUN SRMREAD (STREAM) (READ STREAM NIL EOF*))
(DEFUN STDREAD () (READ *STANDARD-INPUT* NIL EOF*))

(DEFUN SRMREAD-LINE (STREAM)
  (VALUES (READ-LINE STREAM NIL EOF*)   ))

(DEFUN STDREAD-LINE ()
  (VALUES (READ-LINE *STANDARD-INPUT* NIL EOF*)   ))

;; Nov.4.87 modified
(DEFUN SRMLINEREAD (S)
   (COND #+:TI
	 ((AND (EQ HOST-SYS* 'TI)
	      (NOT W:RUBOUT-HANDLER)
	      (MEMBER :RUBOUT-HANDLER (SEND S :WHICH-OPERATIONS)
		       :TEST #'EQ))
	  (SEND S :RUBOUT-HANDLER '() #'SRMLINEREAD S))
	 (T
	  (PROG ((RES NIL) C)
	   NEXT
	     (PROG ()
	      GOBBLE-SPACE
		(SETQ C (SRMPEEKC S))
		(COND ((AND (IS-CHAR C)
			    (CHAR= C #\SPACE))
		       (SRMREADC S)
		       (GO GOBBLE-SPACE))   )
		(RETURN)   )
	     (COND ((OR (IS-EOF C) (CHAR= C #\NEWLINE))
		    (SRMREADC S)
		    (RETURN (DREVERSE RES)))
		   (T
		    (SETQ RES (CONS (READ-PRESERVING-WHITESPACE S) RES))
		    (GO NEXT))   )))   ))

(DEFUN STDLINEREAD () (SRMLINEREAD *STANDARD-INPUT*))

;; Nov.4.87 modified
!S(- TI)
(DEFUN SRMREADC (STREAM) (READ-CHAR STREAM NIL EOF*))
!S(TI)
(DEFUN SRMREADC (STREAM)
   (COND ((AND (NOT W:RUBOUT-HANDLER)
	       (MEMBER :RUBOUT-HANDLER (SEND STREAM :WHICH-OPERATIONS)
		       :TEST #'EQ))
	  (SEND STREAM :RUBOUT-HANDLER '() #'SRMREADC STREAM))
	 (T (READ-CHAR STREAM NIL EOF*))   ))

(DEFUN STDREADC () (SRMREADC *STANDARD-INPUT*))

(DEFUN SRMPEEKC (STREAM) (PEEK-CHAR NIL STREAM NIL EOF*))

(DEFUN STDPEEKC () (SRMPEEKC *STANDARD-INPUT*))

(SUBR-SYNONYM 'SRMPRINT 'PRIN1)
(SUBR-SYNONYM 'STDPRINT 'PRIN1)

(SUBR-SYNONYM 'SRMDISPLAY 'PRINC)
(SUBR-SYNONYM 'STDDISPLAY 'PRINC)

(SUBR-SYNONYM 'SRMPRINTC 'WRITE-CHAR)
(SUBR-SYNONYM 'STDPRINTC 'WRITE-CHAR)

(SUBR-SYNONYM 'SRMPPRINT 'PPRINT)
(SUBR-SYNONYM 'STDPPRINT 'PPRINT)

(DEFUN SRMPRINLEV (EXP DEPTH STREAM)
  (LET ((*PRINT-LEVEL* DEPTH)) (PRINT EXP STREAM)))

(DEFUN STDPRINLEV (E DEPTH) (SRMPRINLEV E DEPTH *STANDARD-OUTPUT*)   )

(SUBR-SYNONYM 'SRMNEWLINE 'TERPRI)
(SUBR-SYNONYM 'STDNEWLINE 'TERPRI)

(DEFUN SRMSPACES (NUMBER STREAM)
  (DOTIMES (N NUMBER) (WRITE-CHAR #\SPACE STREAM))   )

(DEFUN STDSPACES (NUMBER) (SRMSPACES NUMBER *STANDARD-OUTPUT*)   )

;;;--subtract 1. --Denys 7/21/89
(DEFUN SRMTAB (COLUMN STREAM)
  (IF (> (FX- (SRMCURRCOL STREAM) 1) COLUMN)
      (TERPRI STREAM))
  (FORMAT STREAM "~VT" COLUMN))

(DEFUN STDTAB (COL) (SRMTAB COL *STANDARD-OUTPUT*)   )

;; Common Lisp defines no way to figure out where you are.  May want
;; to provide custom versions as HP below. ** Wright
;; New Denys version to handle dribble rebinding...
;; 9.20.88 adjusted for HP-CL2 (Lucid) by simple exclusion; may want
;;   to add detection later if possible.
#+(and HP (not :LUCID))
(DEFUN SRMCURRCOL (SRM)
  (+ 1 (COLUMN-POSITION SRM)))

#+(and HP (not :LUCID))
(DEFUN COLUMN-POSITION (SRM)
  (CASE (SVREF SRM 0)
    (LISP::FILE-STREAM
     (LISP::FILE-COLUMN-POSITION SRM))
    (LISP::TWO-WAY-STREAM
     (COLUMN-POSITION (LISP::TWO-WAY-STREAM-OUTPUT-STREAM SRM)))
    (LISP::BROADCAST-STREAM
     (COLUMN-POSITION (CAR (LISP::BROADCAST-STREAM-STREAMS SRM))))
    (LISP::STRING-OUTPUT-STREAM
     (LISP::STRING-OUTPUT-STREAM-COLUMN-POSITION SRM))
    (LISP::ECHO-STREAM
     (COLUMN-POSITION (LISP::ECHO-STREAM-OUTPUT-STREAM SRM)))
    (LISP::SYNONYM-STREAM
     (COLUMN-POSITION (SYMBOL-VALUE (LISP::SYNONYM-STREAM-SYMBOL SRM))))
    (LISP::CONCATENATED-STREAM
     (COLUMN-POSITION (CAR (LISP::CONCATENATED-STREAM-CURRENT SRM))))
    (T 0))) ;;EARROR doesn't exist yet! (EARROR COLUMN-POSITION 0 "Stream of unknown type: " SRM))))

;; It may be necessary to catch all types of streams as
;; was done above. however this seems to work so far. ** Denys
#+(and HP (not :LUCID))
(SUBR-SYNONYM 'OLD-CLEAR-INPUT 'CLEAR-INPUT)

#+(and HP (not :LUCID))
(DEFUN CLEAR-INPUT (&OPTIONAL (SRM *STANDARD-INPUT*))
  (IF (EQ (SVREF SRM 0) 'LISP::TWO-WAY-STREAM)
      (CLEAR-INPUT (LISP::TWO-WAY-STREAM-INPUT-STREAM SRM))
      (OLD-CLEAR-INPUT SRM)))

#+:TI
(DEFUN SRMCURRCOL (STREAM)
  (IF (SEND STREAM :OPERATION-HANDLED-P :READ-CURSORPOS)
      (+ 1 (SEND STREAM :READ-CURSORPOS :CHARACTER))
      1))

;;;--special case. --Denys 7/21/89
#+:LUCID
(DEFUN SRMCURRCOL (SRM)
  (FX+ 1 (LUCID::CALCULATE-OUTPUT-COLUMN SRM)))

#-(or HP :LUCID :TI)
(DEFUN SRMCURRCOL (STREAM) (IGNORE STREAM) 1)

(DEFUN STDCURRCOL () (SRMCURRCOL (STDOUT)))

;; can't find any documentation on this variable, other versions
;; don't seem to do anything with it, but maybe someone cares... ** Wright
(DEFVAR *PPRINT-RIGHT-MARGIN*
        #+:TI 95
        #-:TI NIL
        )

(DEFUN SRMLINELENGTH (STREAM)
   (IGNORE STREAM)
   (OR *PPRINT-RIGHT-MARGIN* 80)   )

(DEFUN STDLINELENGTH ()
  (OR *PPRINT-RIGHT-MARGIN* 80)   )

(DEFUN SRMLINES (NUMBER STREAM)
  (IF (< NUMBER 1)
      (FRESH-LINE STREAM)
      (DOTIMES (N NUMBER) (TERPRI STREAM))))

(DEFUN STDLINES (N) (SRMLINES N *STANDARD-OUTPUT*)   )

; There must be a better way!
(DEFUN DISPLAYWIDTH (X) (LENGTH (PRINC-TO-STRING X))   )
(DEFUN PRINTWIDTH (X) (LENGTH (PRIN1-TO-STRING X))   )

(DEFMACRO SRMMSG (A-STREAM . EXPS)
  (LET ((STREAM (GENSYM)))
    `(LET ((,STREAM ,A-STREAM))
       . ,(MAPCAR #'(LAMBDA (EXP)
                       (COND ((STRINGP EXP) `(SRMDISPLAY ,EXP ,STREAM))
                             ((NUMBERP EXP)
                              (IF (> EXP 0)
                                  `(SRMSPACES ,EXP ,STREAM)
                                  `(SRMLINES ,(- EXP) ,STREAM)))
                             ((EQ EXP 'T) `(SRMNEWLINE ,STREAM))
                             ((AND (LISTP EXP)
                                   (SYMBOLP (CAR EXP))
                                   (GET (CAR EXP) 'MSG-MACRO))
                              (FUNCALL (GET (CAR EXP) 'MSG-MACRO)
                                       EXP STREAM))
                             (T `(SRMPRINT ,EXP ,STREAM))   ))
                   EXPS)   )))

(DEFMACRO DEFINE-MSG-MACRO (FORM &REST BODY)
   `(SETF (GET ',(CAR FORM) 'MSG-MACRO)
          (\\  ,(CDR FORM) . ,BODY   )))

(DEFINE-MSG-MACRO (E CMD STREAM)
  (IGNORE STREAM)
  (IF (CDDR CMD)
      `(PROGN . ,(CDR CMD))
      (CADR CMD)))

(DEFINE-MSG-MACRO (T CMD STREAM)
   `(SRMTAB ,(CADR CMD) ,STREAM))

(DEFINE-MSG-MACRO (Q CMD STREAM)
   `(COND . ,(MAPCAR (FUNCTION (LAMBDA (CLAUSE)
                                  `(,(CAR CLAUSE)
                                    (SRMMSG ,STREAM . ,(CDR CLAUSE)))   ))
                    (CDR CMD)))   )

(DEFINE-MSG-MACRO (PP CMD STREAM)
   `(SRMPPRINT ,(CADR CMD) ,STREAM)   )

(DEFINE-MSG-MACRO (TO CMD STREAM)
   `(SETF ,STREAM ,(CADR CMD))   )

; (D -exps-) evaluate exps and displays the results.
(DEFINE-MSG-MACRO (D CMD STREAM)
   `(PROGN . ,(MAPCAR (\\ (E) `(SRMDISPLAY ,E ,STREAM)   ) (CDR CMD)))   )

; (S -exps-) evaluate exps, but treat them as if they had occurred
; unevaluated in MSG.  Works for numbers and strings.  Anything else
; just gets displayed.
(DEFINE-MSG-MACRO (S CMD STREAM)
   `(PROGN . ,(MAPCAR (\\ (E) `(SPACE-OR-DISPLAY ,E ,STREAM)   ) (CDR CMD)))   )

(DEFUN SPACE-OR-DISPLAY (X STREAM)
   (COND ((IS-NUMBER X)
          (COND ((> X 0) (SRMSPACES X STREAM))
                (T (SRMLINES (- X) STREAM))   ))
         (T (SRMDISPLAY X STREAM))   ))

(DEFMACRO OUT (&REST EXPS)
  `(SRMMSG (STDOUT) . ,EXPS))

(DEFMACRO MSG (&REST EXPS)
  `(SRMMSG (STDOUT) . ,EXPS))

(DEFMACRO STDMSG (&REST EXPS)
  `(SRMMSG (STDOUT) . ,EXPS))

(DEFMACRO TTYMSG (&REST EXPS)
  `(PROGN (SRMMSG TTYOUT* . ,EXPS)
          (FORCE-OUTPUT TTYOUT*))   )

(DEFMACRO IN (&REST EXPS)
   (LET ((STREAM (GENSYM))
         (VALS (MAPCAR (\\ (E) (COND ((IS-SYMBOL E) (GENSYM))
                                     (T NIL)   ))
                       EXPS)))
      (LET ((VARS (MAPCAN (\\ (V) (COND (V (LIST V)) (T NIL)   ))
                          VALS)))
         `(LET ((,STREAM (STDIN)) . ,VARS)
           ,@(MAPCAR
                (\\ (EXP V)
                   (COND ((IS-SYMBOL EXP)
                          `(SETF ,V
                                 ,(CASE EXP
                                     ((OBJ READ OBJECT T NIL) `(SRMREAD ,STREAM))
                                     (CHAR `(SRMREADC ,STREAM))
                                     (PEEK `(SRMPEEKC ,STREAM))
                                     (LINESTRING `(SRMREAD-LINE ,STREAM))
                                     (LINELIST `(SRMLINEREAD ,STREAM))
                                     (T
                                      (OUT (TO (ERROUT))
                                          "Meaningless IN construct " EXP
                                          " -- assuming OBJECT" T)
                                      `(SRMREAD ,STREAM))   )))
                         ((AND (IS-PAIR EXP)
                               (IS-SYMBOL (CAR EXP))
                               (PROP 'IN-MACRO (CAR EXP)))
                          (FUNCALL (PROP 'IN-MACRO (CAR EXP)) EXP STREAM))
                         (T
                          (ERROR "Meaningless IN construct ~S" EXP))   ))
                EXPS VALS)
             (VALUES . ,VARS)   )   )))

(DEFMACRO DEFINE-IN-MACRO (FORM &REST BODY)
   `(SETF (PROP 'IN-MACRO ',(CAR FORM))
          (\\ ,(CDR FORM) . ,BODY   ))   )

(DEFINE-IN-MACRO (FROM CMD STREAM)
   `(SETF ,STREAM ,(CADR CMD))   )

(DEFINE-IN-MACRO (E CMD STREAM)
   (IGNORE STREAM)
   (COND ((CDDR CMD) `(PROGN . ,(CDR CMD)))
         (T (CADR CMD))   ))

(DEFMACRO WITH-OUTPUT-TO-STRING (VAR . BODY)
   ; Unshadow to Common host version
   (COND ((AND (IS-SYMBOL VAR))
          (SETF VAR (LIST VAR)))   )
   `(LISP:WITH-OUTPUT-TO-STRING ,VAR . ,BODY)   )

(DEFUN READ-OBJECTS-FROM-STRING (S)
   (WITH-INPUT-FROM-STRING (STR S)
      (DO ((R (SRMREAD STR) (SRMREAD STR))
           (L NIL (CONS R L)))
          ((IS-EOF R)
           (DREVERSE L))   )))


