;;; -*- Mode:Common-Lisp; Package:NISP; Base:10 -*-
(IN-PACKAGE :NISP)

; Changes from old T version: FLAVOR will change to OBJECT
; MAKE-INST will become more like MAKE-INSTANCE
; Keywords allowed where stylistically more fashionable
; Combination rules are now whatever CLOS says they are.
; Handler clauses now signalled explicitly with (:HANDLER -clauses-)

(DEPENDS-ON CLOS)

(DEPENDS-ON AT-RUN-TIME nils/ CODEMAP)

(IMPORT '(CLOS:CALL-NEXT-METHOD))

(EXPORT '(SLOTMETHODS MAKE-INST EXPECT-SLOTS DEFMETH CONTINUE-COMBINED-METHOD
	  SLOT SLOT-IS-FILLED INITIALIZE))

(DEFVAR KEYWORD-PACKAGE* (FIND-PACKAGE 'KEYWORD))

; All objects in the CL version must :INCLUDE this
(NEEDED-BY-MACROS
(DEFSTRUCT (OBJECT-KERNEL
	    (:PREDICATE IS-OBJECT)
	    (:CONSTRUCTOR MAKE-OBJECT-KERNEL (HANDLER))
	    (:PRINT-FUNCTION (LAMBDA (OB STR LEV)
				(DECLARE (IGNORE LEV))
				(LET ((PMETH (GET-METHOD OB 'PRINT)))
				   (COND (PMETH (FUNCALL PMETH OB STR))
					 (T
					  (SRMMSG STR "#{OBJECT}"))   )))))
   HANDLER   )

(DEFSTRUCT (ANON-OBJECT 
	    (:INCLUDE OBJECT-KERNEL)
	    (:CONSTRUCTOR MAKE-ANON-OBJECT (HANDLER SLOTS))
	    (:PRINT-FUNCTION (LAMBDA (OB STR LEV)
				(DECLARE (IGNORE LEV))
				(LET ((PMETH (GET-METHOD OB 'PRINT)))
				   (COND (PMETH (FUNCALL PMETH OB STR))
					 (T
					  (SRMMSG STR "#{OBJECT}"))   )))))
   SLOTS   )
)

; (MAKE-OBJECT clauses -vals-) makes an anonymous object with elements vals.
(DEFMACRO MAKE-OBJECT (CLAUSES . VALS)
   `(MAKE-ANON-OBJECT ,(HANDLER-MAKER CLAUSES) (VECTOR . ,VALS))   )

(DEFMACRO OBREF (ANON I) `(VREF (ANON-OBJECT-SLOTS ,ANON) ,I)   )

; (DEFCLASS name -slots-) defines a structure type with an optional
; handler for T-style operations.
; Handler is flagged by (:HANDLER -clauses-), but first slot can be a clause
; list, too.

(DEFMACRO DEFCLASS (NAME &REST SLOTS)
   (LET ((CLAUSES '()))
      (COND ((NOT (NULL SLOTS))
	     (!= CLAUSES (CAR SLOTS))
	     (!= SLOTS (CDR SLOTS))
	     (COND ((MATCHQ (:HANDLER . ?())
			    CLAUSES)
		    (!= CLAUSES (CDR *-*)))
		   ((NOT (OR (NULL CLAUSES)
			     (MATCHQ ((?() . ?()) . ?())
				     CLAUSES)))
		    (!= SLOTS (CONS CLAUSES SLOTS))
		    (LET ((H (<V (\\ (X) (OR (CAR-EQ X ':HANDLER)
					     (CAR-EQ X 'HANDLER)))
				 SLOTS)))
		       (COND (H
			      (!= CLAUSES (CDAR H))
			      (!= SLOTS (REMOVE1Q H *-*)))
			     (T
			      (!= CLAUSES '()))   )))   ))   )
      (COND ((ATOM NAME)
	     (STRUCT-DEFCLASS NAME '() CLAUSES SLOTS))
	    (T
	     (COMPLEX-DEFCLASS (CAR NAME) (CDR NAME) CLAUSES SLOTS))   )))

(DEFUN COMPLEX-DEFCLASS (NAME OPTIONS CLAUSES SLOTS)
   (LOOP FOR ((OPT IN OPTIONS))
      (COND ((OR (ATOM OPT) (NOT (MEMQ (CAR OPT) '(KIND SLOTMETHODS INCLUDE
						   :KIND :SLOTMETHODS :INCLUDE))))
	     (EARROR DEFCLASS NIL "Meaningless option: " OPT
		                  T "Type OK to ignore"))   ))
   (LET ((KIND (<V (\\ (A) (MEMQ (CAR A) '(KIND :KIND)))
		   OPTIONS)))
      (COND (KIND
	     (COND ((MEMQ (CADAR KIND) '(STRUCTURE :STRUCTURE))
;		    (COND ((> (LENGTH OPTIONS) 1)
;			   (OUT (TO (ERROUT))
;				"Warning: Ignoring options " OPTIONS
;				T 3 "Assuming STRUCTURE" T))   )
		    (STRUCT-DEFCLASS NAME OPTIONS CLAUSES SLOTS))
		   (T
		    (FLAVOR-DEFCLASS NAME OPTIONS CLAUSES SLOTS))   ))
	    (T
	     (COND ((AND (NULL CLAUSES) (NULL OPTIONS))
		    (STRUCT-DEFCLASS NAME '() '() SLOTS))
		   (T
		    (FLAVOR-DEFCLASS NAME NIL CLAUSES SLOTS))   ))   )))

(DEFMACRO DECLARE-CLASS (NAME CLAUSES &REST SLOTS)
   `(DEFCLASS ,NAME ,(MAPELTLIST (\\ (C) 
				   `(,(CAR C) ,(CADR C) 
				     (DECLARE (IGNORE . ,(CADR C)))
				     NIL)   )
		                 CLAUSES)
	      . ,SLOTS)   )

(DEFUN STRUCT-DEFCLASS (NAME OPTIONS CLAUSES SLOTS)
   (LET ((COMPONENTS (<V (\\ (A) (OR (CAR-EQ A 'INCLUDE)
				     (CAR-EQ A ':INCLUDE))   )
			 OPTIONS))
	 (SLOTMETHODS (<V (\\ (A) (OR (CAR-EQ A 'SLOTMETHODS)
				      (CAR-EQ A ':SLOTMETHODS))   )
			  OPTIONS)))
      (!= COMPONENTS (COND (*-* (CDAR *-*))
			   (T '())   ))
      (!= SLOTMETHODS (COND (*-* (CDAR *-*))
			    (T '())   ))
      (COND ((NOT (NULL SLOTMETHODS))
	     (EARROR STRUCT-DEFCLASS -NOCONTINUE
		":SLOTMETHODS not allowed in :STRUCTURE " NAME))   )
      (COND ((> (LEN COMPONENTS) 1)
	     (EARROR STRUCT-DEFCLASS -NOCONTINUE
		"Multiple components not allowed in :STRUCTURE: " COMPONENTS))   )
      (LET ((COMPONENT (COND (COMPONENTS (CAR COMPONENTS))
			     (T 'OBJECT-KERNEL)   ))
	    (PRINTER (ASSQ 'PRINT CLAUSES))
	    (SLOTNAMES (FOR (S IN SLOTS)
			    (SAVE (COND ((ATOM S) S)
					(T (CAR S))   )))))
	 (COND (PRINTER (SETF CLAUSES (REM1Q PRINTER CLAUSES)))   )
	 (COND (PRINTER
		(SETF PRINTER `((:PRINT-FUNCTION 
				    (LAMBDA (,@(CADR PRINTER) 
					     IGNORE-LEVEL)
				       (DECLARE (LISP:IGNORE IGNORE-LEVEL))
				       ;(IGNORE IGNORE-LEVEL)
				       . ,(CDDR PRINTER)  )))))   )
	 (COND (CLAUSES
		`(DEFSTRUCT (,NAME
			     (:INCLUDE ,COMPONENT)
			     (:CONSTRUCTOR 
				,(SYMBOL MAKE- (< NAME)) 
				(,@SLOTNAMES 
				 &AUX (HANDLER ,(HANDLER-MAKER CLAUSES))))
			     (:PREDICATE ,(SYMBOL IS- (< NAME))) ,@PRINTER)
		    . ,SLOTS))
	       (T
		`(DEFSTRUCT (,NAME
			     ,@(INCLUDE-IF (NOT (NULL COMPONENTS))
				  `(:INCLUDE ,COMPONENT))
			     (:CONSTRUCTOR ,(SYMBOL MAKE- (< NAME)) 
					   ,SLOTNAMES)
			     (:PREDICATE ,(SYMBOL IS- (< NAME)))
			     ,@PRINTER)
		     . ,SLOTS))   ))))

(DEFUN HANDLER-MAKER (CLAUSES)
   `#'(LAMBDA (OP) 
	  (SELQ OP 
	     ,@(MAPELEMLIST #'(LAMBDA (C) `(,(CAR C)
					    #'(LAMBDA . ,(CDR C)  ))   )
			    CLAUSES)
	     (T NIL)   )))

(DEFVAR EMPTY-FRAME-SLOT* (LIST 'EMPTY-SLOT))

; Extra data not maintained by CLOS: On each Nisp-defined class's name,
; under the indicator OBJECT-CLASS, we store a list
; (immediate-components local-slots).

(DEFUN FLAVOR-DEFCLASS (NAME OPTIONS CLAUSES SLOTS)
   (LET ((COMPONENTS (<V (\\ (A) (MEMQ (CAR A) '(INCLUDE :INCLUDE))   ) OPTIONS))
	 (SLOTMETHODS (<V (\\ (A) (MEMQ (CAR A) '(SLOTMETHODS :SLOTMETHODS))   )
			  OPTIONS))
	 (SLOTSPECS
	    (FOR (S IN SLOTS)
		(SAVE `(,S :INITARG ,(INTERN (SYMBOL->STRING S)
					     KEYWORD-PACKAGE*))))))
      (!= COMPONENTS
	  `(,@(COND (*-* (CDAR *-*))
		    (T NIL)   )
	    NISP-OBJECT))
     ;; The COMPONENTS list is slightly wedged if it's a :BUILT-IN class.
     ;; In that case, we don't get to alter the components, so the
     ;; appearance of NISP-OBJECT above is epiphenomenal.  That means
     ;; that the INITIALIZE operation will not get applied to built-in
     ;; class members.  Fix: just have MAKE-INST call INITIALIZE, and
     ;; dispense with the Mickey-Mouse NISP-OBJECT class.  
      (!= SLOTMETHODS (COND (*-* (CDAR *-*))
			    (T NIL)   ))
      `(PROGN
	 (DECLARE-OBJECT-CLASS ',NAME ',COMPONENTS ',SLOTS)
	 ,@(INCLUDE-IF (LOOP FOR ((OPT IN OPTIONS))
			RESULT '#T
			UNTIL (MEMQ (CAR OPT) '(:KIND KIND))
			RESULT (NOT (EQ (CADR OPT) ':BUILT-IN)))
             `(CLOS:DEFCLASS ,NAME ,COMPONENTS ,SLOTSPECS))
	 ,@(FOR (S IN SLOTS) (SPLICE (SLOT-ACCESSOR-DEFINITIONS NAME S)))
	 ,@(INHERITED-SLOT-DEFINITIONS SLOTMETHODS NAME COMPONENTS SLOTS)
	 ,@(SLOT-METHOD-DEFINITIONS SLOTMETHODS NAME SLOTS)
	 ,@(CLAUSE-METHOD-DEFINITIONS NAME CLAUSES)
	 (DEFUN ,(SYMBOL MAKE- (< NAME)) ,SLOTS
	      (CLOS:MAKE-INSTANCE ',NAME
		             ,@(FOR (SP IN SLOTSPECS)
				    (SPLICE (LIST (CADDR SP) (CAR SP))))))
	 (DEFUN ,(SYMBOL IS- (< NAME)) (X) (TYPEP X ',NAME))
	 ',NAME
	 )   ))

(DEFUN DECLARE-OBJECT-CLASS (NAME COMPONENT-NAMES SLOTS)
   (!= (GET NAME 'OBJECT-CLASS)
       (LIST COMPONENT-NAMES SLOTS))   )

(DATAFUN TO-SLURP DECLARE-OBJECT-CLASS #'GVAL)

(DEFUN SLOT-METHOD-DEFINITIONS (WHICH FLAVNAME SLOTS)
   (FOR (M IN WHICH)
	(SPLICE
	 (COND ((ATOM M)
		(COND ((MEMQ M '(:SETTABLE SETTABLE))
		       `(,@(GET-METHOD-DEFINITIONS SLOTS FLAVNAME)
			 ,@(SET-METHOD-DEFINITIONS SLOTS FLAVNAME)))
		      ((MEMQ M '(:GETTABLE GETTABLE))
		       (GET-METHOD-DEFINITIONS SLOTS FLAVNAME))
		      ((NOT (MEMQ M '(:NOINHERIT NOINHERIT)))
		       (EARROR SLOT-METHOD-DEFINITIONS -NOVALUE
			       "Meaningless slot-method option: " M
			       " in definition of " FLAVNAME T)
		       '())   ))
	       ((MEMQ (CAR M) '(:SETTABLE SETTABLE))
		`(,@(GET-METHOD-DEFINITIONS (CDR M) FLAVNAME)
		  ,@(SET-METHOD-DEFINITIONS (CDR M) FLAVNAME)))
	       ((MEMQ (CAR M) '(:GETTABLE GETTABLE))
		(GET-METHOD-DEFINITIONS (CDR M) FLAVNAME))
	       ((NOT (MEMQ (CAR M) '(:NOINHERIT NOINHERIT)))
		(EARROR SLOT-METHOD-DEFINITIONS -NOVALUE
			       "Meaningless slot-method option: " M
			       " in definition of " FLAVNAME T)
		'())))))

(DEFUN INHERITED-SLOT-DEFINITIONS (SLOTMETHODS FLAVOR COMPONENTS LOCALSLOTS)
   (COND ((NOT (OR (MEMQ 'NOINHERIT SLOTMETHODS)
		   (MEMQ ':NOINHERIT SLOTMETHODS)))
	  (LET ((SLOTS NIL))
	     (LOOP FOR ((C IN COMPONENTS))
		(!= SLOTS (UNIONQ *-* (CLASS-ALL-SLOTS C)))   )
	     (!= SLOTS (COMPLEMENTQ *-* LOCALSLOTS))
	     (<! (\\ (S) (SLOT-ACCESSOR-DEFINITIONS FLAVOR S)   )
		 SLOTS)))   ))
		    
(DEFUN SLOT-ACCESSOR-DEFINITIONS (FLAVOR S)
   (LET ((ACCESSOR (SYMBOL (< FLAVOR) - (< S)))
	 (SETTER (SYMBOL SET- (< FLAVOR) - (< S))))
      (LIST `(DEFUN ,ACCESSOR (X)
	        (CLOS:SLOT-VALUE X ',S)   )
	    `(DEFUN ,SETTER (X N)
	        (SETF (CLOS:SLOT-VALUE X ',S) N)   )
	    `(PROCLAIM '(INLINE ,ACCESSOR ,SETTER))
	    `(DEFSETF ,ACCESSOR ,SETTER))   ))

(DEFUN CLAUSE-METHOD-DEFINITIONS (FLAVNAME CLAUSES)
   (<# (\\ (C)
	  (LET (NAME ARGL BODY)
	     (MATCHQ (?NAME ?ARGL . ?BODY) C)
	     `(DEFMETH (,FLAVNAME ,@(COND ((ATOM NAME) `(,NAME))
					     (T NAME)   ))
		       ,ARGL
		 ,@BODY)))
       CLAUSES)   )

(DEFUN CLASS-COMPONENTS (C)
   (LET ((CS (GET C 'OBJECT-CLASS)))
      (COND ((NOT CS)
	     (EARROR CLASS-COMPONENTS -NOCONTINUE
		"Not a class name: " C))
	    (T (CAR CS))   )))

(DEFUN CLASS-SLOTS (C)
   (LET ((CS (GET C 'OBJECT-CLASS)))
      (COND ((NOT CS)
	     (EARROR CLASS-SLOTS -NOCONTINUE
		"Not a class name: " C))
	    (T (CADR CS))   )))

(DEFUN CLASS-ALL-COMPONENTS (FLAV)
   (LET ((COMPS NIL))
      (FLABELS ((COLLECT (FLAV)  ; Actually a flavor name
		   (COND ((NOT (MEMQ FLAV COMPS))
			  (!= COMPS (CONS FLAV *-*))
			  (LET ((FL (GET FLAV 'OBJECT-CLASS)))
			     (COND (FL
				    (LOOP FOR ((C IN (CAR FL)))
				       (COLLECT C)   ))   )))   )))
	 (COLLECT FLAV)
	 (DREVERSE COMPS)   )))

; Get all slots that can be detected at flavor-build time.  Since flavor may be
; mixed in later, new slots may appear.
(DEFUN CLASS-ALL-SLOTS (FLAV)
   (LOOP FOR ((F IN (CLASS-ALL-COMPONENTS FLAV))
	      (SL '()))
      (!= SL (UNIONQ (CADR (GET F 'OBJECT-CLASS)) *-*))
    RESULT SL)   )

(DEFUN IS-CLASS-NAME (X)
   (AND (IS-SYMBOL X)
	(LET ((C (CLOS:FIND-CLASS X NIL)))
	   (AND C (TYPEP C 'CLOS:STANDARD-CLASS)))))

(DEFUN IS-STRUCT-NAME (X)
   (AND (IS-SYMBOL X)
	(LET ((C (CLOS:FIND-CLASS X NIL)))
	   (AND C (TYPEP C 'CLOS:STRUCTURE-CLASS)))))

; (SLOTMETHODS class (GETTABLE -slots-) (SETTABLE -slots-)).  Old form
; puts GETTABLE/SETTABLE first.
(DEFMACRO SLOTMETHODS (CLASS &REST SPECS)
   (COND ((MEMQ CLASS '(GETTABLE SETTABLE))
	  (OUT (TO (ERROUT)) "Use of old form of SLOTMETHODS: "
	       `(SLOTMETHODS ,CLASS . ,SPECS))
	  (!= CLASS (CAR SPECS))
	  (!= SPECS `((,CLASS . ,(CDR SPECS)))))   )
   `(PROGN
     . ,(FOR (S IN SPECS)
	   (SPLICE
	      (COND ((NOT (MEMQ (CAR S) '(GETTABLE SETTABLE :GETTABLE :SETTABLE)))
		     (EARROR SLOTMETHODS '()
			     "Meaningless SLOTMETHODS option " (CAR S)))
		    (T
		     (LET ((SLOTS (CDR S)))
		       (NCONC (GET-METHOD-DEFINITIONS SLOTS CLASS)
			      (COND ((MEMQ (CAR S) '(SETTABLE :SETTABLE))
				     (SET-METHOD-DEFINITIONS SLOTS CLASS))
				    (T '())   ))))   )))))

(DEFUN GET-METHOD-DEFINITIONS (SLOTS CLASS)
   (<# (\\ (S)
	  (LET ((GETTER (SYMBOL GET- (< S))))
	     `(DEFMETH (,CLASS ,GETTER) (| inst |)
		 (SLOT ,S)    )   ))
       SLOTS)   )

(DEFUN SET-METHOD-DEFINITIONS (SLOTS CLASS)
   (<! (\\ (S)
	  (LET ((SETTER (SYMBOL SET- (< S))))
	     (LIST `(DEFSETF ,(SYMBOL GET- (< S)) ,SETTER)
		   `(DEFMETH (,CLASS ,SETTER) (| inst | | val |) 
		       (SETF (SLOT ,S) | val |)   )))   )
       SLOTS)   )


(DEFMACRO MAKE-INST (CLASS &REST ARGS)
   (!= ARGS (REMOVE-EVERYQ '= *-*))
   `(CLOS:MAKE-INSTANCE (->CLASS-NAME ',CLASS)
	,@(LOOP FOR ((AL ARGS (CDDR AL))
		      (NEWARGS NIL))
	    UNTIL (NULL AL)
	    RESULT (REVERSE NEWARGS)
	      (!= NEWARGS `(,(CADR AL) ,(INTERN (SYMBOL->STRING (CAR AL))
						KEYWORD-PACKAGE*)
			    ,@*-*))   )))

(DEFUN ->CLASS-NAME (N) N)

(DEFMACRO DEFOP (NAME ARGL &REST BODY)
   (MULTIPLE-VALUE-LET (D BODY) (DECLARATIONS-SEPARATE BODY)
      `(CLOS:DEFGENERIC ,NAME ,ARGL
	  (:METHOD ((,(CAR ARGL) T) ,@(CDR ARGL))
	     ,@D
	     (LET ((OPMETH (GET-METHOD ,(CAR ARGL) ',NAME)))
	       (COND (OPMETH ,(MAKE-FUNCALL 'OPMETH ARGL))
		     (T
		      ,@(COND ((NULL BODY)
			       `((EARROR ,NAME
					 ,(MAKE-FUNCALL `#',NAME ARGL) 
					 "Operation not handled "
					 ',NAME)))
			      (T BODY)   ))   ))))))

(NEEDED-BY-MACROS
(DEFUN MAKE-FUNCALL (FNAME ARGNAMES)
   (LET ((L (MEMQ '&REST ARGNAMES)) FN)
      (COND (L `(APPLY ,FNAME ,@(LDIFF ARGNAMES L) ,(CADR L)))
	    ((MATCHQ (?(\| FUNCTION FUNKTION) ?FN) FNAME)
	     `(,FN . ,ARGNAMES))
	    (T `(FUNCALL ,FNAME . ,ARGNAMES))   )))
)

(DEFUN GET-METHOD (OB OP)
   (AND (IS-OBJECT OB) (FUNCALL (OBJECT-KERNEL-HANDLER OB) OP))   )

(DEFMACRO DEFMETH (A &REST STUFF)
   (LET ((QUALIFIERS '()) OP ARGL BODY FLAVOR (QUALIFIER '#F))
      (COND ((ATOM A)
	     (!= OP A)
	     ; CLOS-style
	     (LOOP
	      UNTIL (NULL STUFF)
	      WHILE (ATOM (CAR STUFF))
		(COND ((NOT (IS-SYMBOL (CAR STUFF)))
		       (EARROR DEFMETH -NOCONTINUE
			  "Meaningless method qualifier: " (CAR STUFF)))   )
		(!= QUALIFIERS (CONS (CAR STUFF) *-*))
		(!= STUFF (CDR STUFF))   )
	     (!= QUALIFIERS (DREVERSE *-*)))   )
      (!= ARGL (CAR STUFF))
      (!= BODY (CDR STUFF))
      (COND  ((OR (MATCHQ (?FLAVOR ?OP) A)
		  (MATCHQ (?FLAVOR ?QUALIFIER ?OP) A))
	      ; Old style
	      (!= ARGL `((,(CAR *-*) ,FLAVOR) ,@(CDR *-*)))
	      (COND (QUALIFIER (!= QUALIFIERS (LIST QUALIFIER)))   ))   )
      (!= QUALIFIERS
	  (FOR (Q IN *-*)
	       (SAVE (SELQ Q
			((COMBINED :COMBINED AROUND) ':AROUND)
			(BEFORE ':BEFORE)
			(AFTER ':AFTER)
			(T Q)   ))))
      (COND ((EQ OP 'PRINT) (!= OP 'CLOS:PRINT-OBJECT))   )
      (COND ((OR (ATOM (CAR ARGL))
		 (NOT (IS-SYMBOL (CADAR ARGL))))
	     `(CLOS:DEFMETHOD ,OP ,@QUALIFIERS ,ARGL ,@BODY))
	    (T
	     (MULTIPLE-VALUE-LET (DECLS BODY) (DECLARATIONS-SEPARATE BODY)
		(LET ((SELFARG (CAAR ARGL))
		      (FLAVOR (CADAR ARGL)))
		   `(CLOS:DEFMETHOD ,OP ,@QUALIFIERS ,ARGL
		       ,@DECLS
		       ,(METHOD-BODY-MASSAGE BODY FLAVOR SELFARG OP)   )   )))   )))

(DEFVAR EXPECTED-SLOTS* NIL)   ; Lexical slots allowed in methods
(DEFVAR SELF-VAR*       NIL)   ; Variable bound to object being manipulated

; Transform every occurrence of (flav-sl self) into (slot sl) [and, ultimately,
; into just s, inside the appropriate WITH-SLOTS], thus speeding things up.
; This would be trivial but for the necessity of a code walk, catching things
; like rebinding the self-var.
(DEFUN METHOD-BODY-MASSAGE (BODY SELF-FLAVOR SELF-VAR OPNAME)
  (LET ((IVARS (CLASS-ALL-SLOTS SELF-FLAVOR))
	(COMPS (CLASS-ALL-COMPONENTS SELF-FLAVOR)))
    (BIND ((SELF-VAR* SELF-VAR)
	   (EXPECTED-SLOTS* IVARS))
       (INTERCEPT LOSER-SET-SELF-VAR
	  (FLABELS (; Chop symbol into flav-slot if possible
		    (TRY-SEE-FLAV-ACC (FS)
		       (LET ((S (SYMBOL->STRING FS)))
			  (LOOP FOR ((I = 0 TO (- (STRING-LENGTH S) 1))
				     (BINGO NIL))
			   RESULT NIL
			     (COND ((CHAR= (STRING-ELT S I) '#\-)
				    (LET ((PRE (STRING->SYMBOL
						 (STRING-SUBSEQ S 0 I)))
					  (POST (STRING->SYMBOL
						 (STRING-SUBSEQ
						     S (+ I 1)
						       (STRING-LENGTH S)))))
				      (COND ((AND (MEMQ PRE COMPS)
						  (MEMQ POST IVARS))
					     (!= BINGO POST))   )))   )
			   UNTIL BINGO
			   RESULT BINGO   )))

		    (OPTIMIZE-SLOT-REFS (E)
		       (LET (FS)
			  (COND ((MATCHQ (?FS !@SELF-VAR) E)
				 (COND ((IS-SYMBOL FS)
					(OR (TRY-SEE-FLAV-ACC FS) E))
				       (T E)   ))
				(T E)   )))
		    (FUNCLAUSE-TRAP (DOFN C)
		       (COND ((MEMQ SELF-VAR (CADR C)) C)
			     (T `(,(CAR C) ,(CADR C)
				  . ,(BODY-MAP #'TRAP-SELF-VAR-BINDERS
					       DOFN (CDDR C))))   ))
		    (TRAP-SELF-VAR-BINDERS (DOFN E)
		       (MATCH-COND E
			  ?((EXPECT-SLOTS ?SLOTS . ?BODY)
			    (VALUES T
				    (BIND ((EXPECTED-SLOTS*
					     (APPEND SLOTS EXPECTED-SLOTS*)))
				       `(CLOS:WITH-SLOTS ,SLOTS ,SELF-VAR
					  . ,(BODY-MAP #'TRAP-SELF-VAR-BINDERS
						       DOFN BODY))
				    )))
			  ?((FLABELS ?FCLAUSES . ?BODY)
			    (VALUES T
				    `(FLABELS ,(<# (\\ (C) (FUNCLAUSE-TRAP DOFN C)   )
						   FCLAUSES)
					. ,(BODY-MAP #'TRAP-SELF-VAR-BINDERS
						     DOFN BODY))))
			  ?((MAKE-OBJECT ?FCLAUSES . ?VALS)
			    (VALUES T
				    `(MAKE-OBJECT ,(<# (\\ (C) (FUNCLAUSE-TRAP DOFN C)  )
						       FCLAUSES)
					. ,(<# (\\ (V) (CODE-MAP #'TRAP-SELF-VAR-BINDERS
								 DOFN V)   )
					       VALS))))
			  ?((?(\| SETQ SETF) !@SELF-VAR ?())
			    (OUT (TO (ERROUT))
				 "In definition of " OPNAME
				 " method for " SELF-FLAVOR ","
				 T "   the \"self-variable\" " SELF-VAR " is SET.  This"
				 " makes certain optimizing transformations impossible."
				 T)
			    (PASS LOSER-SET-SELF-VAR BODY))
			  ?(((LAMBDA (?V1) (?ACC !@V1)   ) !@SELF-VAR)
			    (VALUES T
				    (LET ((SREF (TRY-SEE-FLAV-ACC ACC)))
				       (OR SREF
					   (CODE-MAP #'TRAP-SELF-VAR-BINDERS
						     DOFN
						     `(,ACC ,SELF-VAR)))   )))
			  ?(((LAMBDA (?V1 ?V2) (SETF (?ACC !@V1) !@V2)   )
			     !@SELF-VAR ?VAL)
			    (VALUES T
				    (LET ((SREF (TRY-SEE-FLAV-ACC ACC)))
				       (COND (SREF
					      `(SETF ,SREF
						     ,(CODE-MAP #'TRAP-SELF-VAR-BINDERS
								DOFN VAL)))
					     (T
					      (CODE-MAP #'TRAP-SELF-VAR-BINDERS
							DOFN
							`(SETF (,ACC ,SELF-VAR)
							       ,VAL)))   ))))
;			  ?((SLOT-IS-FILLED ?S)
;			    (VALUES '#T
;				    `(SLOT-BOUNDP ,SELF-VAR ',S)))
			  ((DOES-BIND E SELF-VAR) (VALUES T E))
			  (T (VALUES NIL NIL))   ))

		    )

	      `(CLOS:WITH-SLOTS ,EXPECTED-SLOTS* ,SELF-VAR*
		 ,@(BODY-MAP #'TRAP-SELF-VAR-BINDERS
			     #'OPTIMIZE-SLOT-REFS
			     BODY))   )))))

(DEFUN DOES-BIND (E VAR)
   (FLABELS ((FOUND-IN-BVAR-LIST (L)
	        (<V (\\ (V) (OR (EQ V VAR) (CAR-EQ V VAR))   )
		    L)))
      (COND ((ATOM E) NIL)
	    ((MEMQ (CAR E) '(LET BIND PROG DO MULTIPLE-VALUE-LET 
			      WITH-INPUT-FROM-FILE WITH-OUTPUT-TO-FILE
			      WITH-INPUT-FROM-STRING WITH-OUTPUT-TO-STRING))
	     (COND ((AND (CADR E) (ATOM (CADR E)))
		    (EQ (CADR E) VAR))
		   (T (FOUND-IN-BVAR-LIST (CADR E)))   ))
	    ((EQ (CAR E) 'LOOP)
	     (AND (EQ (CADR E) 'FOR)
		  (FOUND-IN-BVAR-LIST (CADDR E))))
	    ((MEMQ (CAR E) '(FOR FORALL EXISTS))
	     (LOOP FOR ((C IN E) V)
	      WHILE (MATCHQ (?V IN ?()) C)
	      RESULT NIL
	      UNTIL (EQ V VAR)
	      RESULT T))
	    ((EQ (CAR E) 'FUNCTION)
	     (MATCH-COND (CADR E)
		?((LAMBDA ?BVARS . ?())
		  (FOUND-IN-BVAR-LIST BVARS))
		(T NIL)    ))
	    ((CAR-EQ (CAR E) 'LAMBDA)
	     (FOUND-IN-BVAR-LIST (CADAR E)))
	    (T NIL)   )))
	    
(DEFMACRO EXPECT-SLOTS (SLOTS &REST BODY)
   (EARROR EXPECT-SLOTS NIL
	       "(EXPECT-SLOTS " SLOTS
	       " ...) should not occur outside a method body")
   `(PROGN . ,BODY)   )

(DEFMACRO CONTINUE-COMBINED-METHOD (SELF^ &REST ARGS^)
   ;(IGNORE SELF^)
   `(CALL-NEXT-METHOD ,SELF^ . ,ARGS^)   )

(DATAFUN CODE-MAP CONTINUE-COMBINED-METHOD !'MAGIC-AS-FUNCTION)

;(DATAFUN EXCL-READER -
;   (DEFUN (STREAM CH)
;      (IGNORE CH)
;      (IN (FROM STREAM) CHAR)
;      `(SLOT-CONT ,(IN (FROM STREAM) T))   ))

; The macros SLOT and SLOT-IS-FILLED should occur only in method bodies,
; where they will be expanded by METHOD-BODY-MASSAGE.

(DEFMACRO SLOT (S)
  (COND ((NOT (MEMQ S EXPECTED-SLOTS*))
	 (EARROR SLOT S
	    "Unexpected slot " S))
	(T S)   ))

;(DEFMACRO SET-SLOT (S X) `(SETQ ,S ,X)   )
;(DEFSETF SLOT SET-SLOT)

(DEFMACRO SLOT-IS-FILLED (S)
   (COND (SELF-VAR*
	  `(CLOS:SLOT-BOUNDP ,SELF-VAR* ',S))
	 (T
	  (EARROR SLOT-IS-FILLED -NOCONTINUE
	     "SLOT-IS-FILLED for slot " S " not trapped by method massager"))))

(DEFOP INITIALIZE (OB) OB)

(CLOS:DEFCLASS NISP-OBJECT () ())

(CLOS:DEFMETHOD CLOS:INITIALIZE-INSTANCE :AFTER ((OB NISP-OBJECT) &REST INITARGS)
   (DECLARE (IGNORE INITARGS))
   (INITIALIZE OB)   )

; (SLOT-DEFAULTS sl val sl val ...) initializes unfilled slots.  Order is 
; important, and later slots may use values of earlier ones.
(DEFMACRO SLOT-DEFAULTS (&REST SLOTDEFS)
   `(PROGN
        ,@(FLABELS ((NEXTPAIR (SLOTDEFS)
		       (COND ((NULL SLOTDEFS) '())
			     (T
			      `((COND ((NOT (SLOT-IS-FILLED ,(CAR SLOTDEFS)))
				       (!= (SLOT ,(CAR SLOTDEFS))
					   ,(CADR SLOTDEFS)))   )
				,@(NEXTPAIR (CDDR SLOTDEFS))))   )))
	     (NEXTPAIR SLOTDEFS))))



