;;; -*- Mode:Common-Lisp; Package:NISP; Base:10 -*-
;;; Base definitions for NILS -- Feb 27, 1987
;;; Copyright (C) 1988, Drew McDermott, Yale University (see "copyright" file).
(IN-PACKAGE :NISP)

(PROCLAIM '(OPTIMIZE (SPEED 3) (SAFETY 0) (SPACE 0)
                     #+:NEWFANGLED (DEBUG 1)
                     ))

(DEFVAR HOST-DIALECT* 'COMMON) ; Or T

;; !: KING macro char., looks at next character and, if it has an
;; EXCL-READER prop, calls it as a function with the char as arg.
;; The character is still sitting in the input stream.
(EVAL-WHEN (COMPILE EVAL LOAD)
  (SET-MACRO-CHARACTER #\!
       #'(LAMBDA (STREAM CHAR)
	   (LISP:DECLARE (LISP:IGNORE CHAR))
	   (LET* ((NEXT-CHAR (PEEK-CHAR NIL STREAM T NIL T))
		  (NEXT-CHAR-S (INTERN (STRING NEXT-CHAR)
				       (FIND-PACKAGE "NISP")))
		  (EXCL-PROP (GET NEXT-CHAR-S 'EXCL-READER)))
	     (COND (EXCL-PROP
		    (FUNCALL EXCL-PROP STREAM NEXT-CHAR-S))
		   ((MEMBER NEXT-CHAR '(#\Space #\Tab #\Newline #\Return #\Linefeed #\Page)
			    :TEST #'CHAR=)
		    '\!)
		   (T
		    ;; if any problems here, could try UNREAD-CHAR + (VALUES)
		    (INTERN (CONCATENATE 'STRING "!" (STRING (READ STREAM T NIL T)))
			    ;(FIND-PACKAGE "NISP")
			    )))))
       T
       NISP-READ-TABLE*))

; !` is now just backquote
(EVAL-WHEN (COMPILE EVAL LOAD)
  (SETF (GET '\` 'EXCL-READER)
	#'(LAMBDA (STREAM CH)
	    (LISP:DECLARE (LISP:IGNORE CH))
	    (READ STREAM T NIL T)   )))

; Useful macro in backquote. ,@(INCLUDE-IF test -stuff-) includes stuff if
; test is passed
(DEFMACRO INCLUDE-IF (TST . STUFF)
  `(COND (,TST (LIST . ,STUFF)) (T NIL)   ))

;; Version control.  !S([-] -systems-) causes following thing to
;;    be treated as a comment if not in appropriate system.
;; !D ... does same for HOST-DIALECT*, !V is old synonym
(EVAL-WHEN (COMPILE EVAL LOAD)
  (SETF (GET 'S 'EXCL-READER)
	#'(LAMBDA (STREAM CHAR-V)
	    (LISP:DECLARE (LISP:IGNORE CHAR-V)) ;done with #\S - ignore arg
	    (READ-CHAR STREAM T NIL T)	        ; and remove "S" from stream
	    (LET ((VLIST (READ STREAM T NIL T)))
	      (IF (IF (EQ (CAR VLIST) '-)       ; if next expression not for us
		      (MEMBER HOST-SYS* (CDR VLIST) :TEST #'EQ)
		      (NOT (MEMBER HOST-SYS* VLIST :TEST #'EQ)))
		  (LET ((*READ-SUPPRESS* T))
		    (READ STREAM T NIL T) )))   ; read from stream + do nothing
	    (VALUES)   )))	                ; return value

(EVAL-WHEN (COMPILE EVAL LOAD)
  (SETF (GET 'D 'EXCL-READER)
	#'(LAMBDA (STREAM CHAR-V)
	    (LISP:DECLARE (LISP:IGNORE CHAR-V)) ;done with #\D - ignore arg
	    (READ-CHAR STREAM T NIL T)	        ; and remove "D" from stream
	    (LET ((VLIST (READ STREAM T NIL T)))
	      (IF (IF (EQ (CAR VLIST) '-)       ; if next expression not for us
		      (MEMBER HOST-DIALECT* (CDR VLIST) :TEST #'EQ)
		      (NOT (MEMBER HOST-DIALECT* VLIST :TEST #'EQ)))
		  (LET ((*READ-SUPPRESS* T))
		    (READ STREAM T NIL T) )))   ; read from stream + do nothing
	    (VALUES)   )))	                ; return value

(SETF (GET 'V 'EXCL-READER) (GET 'D 'EXCL-READER))

(EVAL-WHEN (COMPILE EVAL LOAD)
  (DEFUN NISP-EVAL-FEATURE (L)
    (COND ((NULL L) NIL)
	  ((ATOM L) (MEMBER L NISP-FEATURES*))
	  ((EQ (CAR L) 'AND)
	   (LISP:EVERY #'NISP-EVAL-FEATURE (CDR L)))
	  ((EQ (CAR L) 'OR)
	   (LISP:SOME #'NISP-EVAL-FEATURE (CDR L)))
	  ((EQ (CAR L) 'NOT)
	   (NOT (NISP-EVAL-FEATURE (CADR L))))
	  (T ;;--interpret a list as a conjunction
	   (LISP:EVERY #'NISP-EVAL-FEATURE L))))
  (SETF (GET 'Z 'EXCL-READER)
	  #'(LAMBDA (STREAM CHAR-V)
	      (LISP:DECLARE (LISP:IGNORE CHAR-V)) ;done with #\Z - ignore arg
	      (READ-CHAR STREAM T NIL T)          ;and remove "Z" from stream
	      (IF (NOT (NISP-EVAL-FEATURE (READ STREAM T NIL T)))
		  (LET ((*READ-SUPPRESS* T))
		    (READ STREAM T NIL T)))       ; read from stream + do nothing
	      (VALUES))))                         ; return value

;; added 5.6.88 #T and #F
(SET-DISPATCH-MACRO-CHARACTER #\# #\T
   #'(LAMBDA (STREAM SUBCHAR ARG)
       (LISP:DECLARE (LISP:IGNORE STREAM SUBCHAR ARG))
       T))

(SET-DISPATCH-MACRO-CHARACTER #\# #\F
   #'(LAMBDA (STREAM SUBCHAR ARG)
       (LISP:DECLARE (LISP:IGNORE STREAM SUBCHAR ARG))
       NIL))

;(DEFMACRO IGNORE (&REST VARS)
;  `(LISP:DECLARE (LISP:IGNORE ,@VARS)))

(DEFMACRO DECLARE-IGNORE (&REST VARS)
  `(LISP:DECLARE (LISP:IGNORE ,@VARS)))

(DEFMACRO \\ (ARGS . BODY)
   `(FUNCTION (LAMBDA ,ARGS ,@(IGNORE-CONVERT BODY)))   )

(DEFMACRO \; (&REST BODY)         ; See debugging note ** Firby
  (DECLARE (LISP:IGNORE BODY))
  (VALUES))

(DEFMACRO FUNKTION (F)
  (IF (SYMBOLP F)
      `(QUOTE ,F)
      `(FUNCTION ,F)))

; Make !'x = (FUNKTION x).
(DEFUN EX-FUNMAC (S F)
  (READ-CHAR S)
  (SETQ F (READ S T NIL T))
  (COND ((ATOM F) (LIST 'FUNKTION F))
	(T (LIST 'FUNCTION
		 (COND ((AND (CONSP F) (EQ (CAR F) '\\))
			`(LAMBDA ,(CADR F) ,@(IGNORE-CONVERT (CDDR F))))
		       (T F)   )))   ))

(SETF (GET '\' 'EXCL-READER) #'EX-FUNMAC)

(DEFUN IS-FUN-NAME (X)
   (AND (SYMBOLP X)
        (FBOUNDP X))   )

(DEFUN FUN-NAME (FN)  ; Possibly this could be improved.
   (IF (SYMBOLP FN) FN NIL))

(DEFUN SYMBOL->FUN (S)
   (IF (FBOUNDP S)
       (SYMBOL-FUNCTION S)
       S))

(DEFUN SYM->FUN (S) (SYMBOL->FUN S))

;; GET-FUNDEF: NISP function, returns () if and only if no definition, else
;;   massaged sources if available, else implementation-specific expression
;; That is, it returns one of these things:
;;  (LAMBDA ...): Straightforward function definition.  Obeys Nisp (= CL)
;;     lambda-list conventions.
;;  (MACRO ...): Same, but for macro.
;;  (NLAMBDA ...): Same, but for special form, and no current implementation
;;     can ever return something like this.
;;  (INTERNAL-FUNCTION . <x>): Nonstraightforward function definition, i.e.,
;;     not in DEFUN format.
;;  (INTERNAL-MACRO . <x>): Nonstraightforward macro definition, that is,
;;     not in DEFMACRO format.
;;  (INTERNAL-MAGIC . <x>): Special form.
(DEFUN GET-FUNDEF (FNAME)
   (LET ((D (MACRO-FUNCTION FNAME)))
            ;; 1.Macro:
      (COND (D `(INTERNAL-MACRO . ,D))  ; Too hard, especially in VMS,
                                        ; to decipher
            ((IS-MAGIC FNAME)
             `(INTERNAL-MAGIC . ,(SYMBOL-FUNCTION FNAME)))
            ;; 2.Function:
            ((AND (FBOUNDP FNAME)
                  (CONSP (SETQ D (SYMBOL-FUNCTION FNAME))))
             (COND
               ;; EXPLORER: put it's NAMED-LAMBDA's into correct form  ** Firby
               ((AND (EQ HOST-SYS* 'TI)
                     (EQ (CAR D) 'NAMED-LAMBDA))
                (MASSAGE-FUNDEF FNAME (CONS 'LAMBDA (CDDR D))))
               ;; SYMBOLICS: put it's SI:DIGESTED-LAMBDA's into correct form  ** Wright
               ;((AND (EQ HOST-SYS* 'SYMBOLICS)
               ;      (EQ (CAR D) 'SI:DIGESTED-LAMBDA))
               ; (MASSAGE-FUNDEF FNAME (CADR D)))
               ((EQ (CAR D) 'LAMBDA)
                (MASSAGE-FUNDEF FNAME D))
               (T `(INTERNAL-FUNCTION . ,D))   ))
            ;; 3.else results of (SYMBOL-FUNCTION FNAME)
           (T `(INTERNAL-FUNCTION . ,D))   )))

(DEFUN MASSAGE-FUNDEF (FNAME D)
   (LET ((ARGL (CADR D))
         (BODY (CDDR D)))
      ; Undo weird CommonLisp blockification
      (COND ((AND (NULL (CDR BODY))
                  (CONSP (CAR BODY))
                  (EQ (CAAR BODY) 'BLOCK)
                  (EQ (CADAR BODY) FNAME))
             (SETQ BODY (CDDAR BODY)))   )
      `(LAMBDA ,ARGL . ,BODY)   ))

(DEFUN PUT-FUNDEF (SYM DFN)
   (COND ((CONSP DFN)
          (CASE (CAR DFN)
             (MACRO (EVAL `(DEFMACRO ,SYM . ,(CDR DFN))))
             (LAMBDA (EVAL `(DEFUN ,SYM . ,(CDR DFN))))
             (NLAMBDA (EVAL `(DF ,SYM . ,(CDR DFN))))
             (INTERNAL-MACRO (SETF (MACRO-FUNCTION SYM) (CDR DFN)))
             ((INTERNAL-FUNCTION INTERNAL-MAGIC)
              (SETF (SYMBOL-FUNCTION SYM) (CDR DFN)))
             (T (ERROR "Meaningless function definition for ~S -- ~S"
                       SYM DFN))   ))
         ((NULL DFN)
          (SETF (SYMBOL-FUNCTION SYM) NIL)
          (SETF (MACRO-FUNCTION SYM) NIL))
         (T (SETF (SYMBOL-FUNCTION SYM) DFN))   )
   DFN   )

(DEFSETF GET-FUNDEF PUT-FUNDEF)

(DEFMACRO DE (&REST DEF) `(DEFUN . ,DEF)   )

(DEFVAR COMPILE-SW* NIL)

(DEFMACRO DF (NAME (ARG) . BODY)
   (LET ((EXPRVERSION (INTERN (CONCATENATE 'STRING (SYMBOL-NAME NAME) "-X")
			      (FIND-PACKAGE "NISP"))))
      `(PROGN (DEFUN ,EXPRVERSION (,ARG) . ,BODY)
              (DEFMACRO ,NAME (&REST ,ARG)
                  `(,',EXPRVERSION ',,ARG)   ))   ))

(DEFMACRO SYMBOLFUN (E) E)

;; IS-MACRO returns NIL for non-symbols, MACRO-FUNCTION returns error
(DEFUN IS-MACRO (X)
  (AND (SYMBOLP X)
       (MACRO-FUNCTION X)))
;       (NOT (SPECIAL-FORM-P X)))   )  ; I'm not convinced.

(DEFUN IS-MAGIC (X)
   (OR (AND (SYMBOLP X)
            (OR (MACRO-FUNCTION X)           ;IS-MACRO (VAX) duplicated SYMBOLP check ** Wright
                (SPECIAL-FORM-P X)))
       (AND (CONSP X)
            (MEMQ (CAR X) '(NLAMBDA INTERNAL-MAGIC))))   )
       
(DEFVAR SUBR-SYNONYMS* NIL)

(DEFUN SUBR-SYNONYM (SYN SUBR)
   (SETF (SYMBOL-FUNCTION SYN) (SYMBOL-FUNCTION SUBR))
   (SETQ SUBR-SYNONYMS* (CONS (LIST SYN SUBR) SUBR-SYNONYMS*))
   SYN)

#+(AND :NEWFANGLED (NOT :HARLEQUIN-COMMON-LISP))
(SUBR-SYNONYM 'SPECIAL-FORM-P 'SPECIAL-OPERATOR-P)

;; 4.27.88 changed next two from SUBR-SYNONYM to avoid multiple value return
(DEFUN ONE-MACRO-EXPAND (EXP)
  (VALUES (MACROEXPAND-1 EXP)))

(DEFUN MACRO-EXPAND-EXP (EXP)
  (VALUES (MACROEXPAND EXP)))

(SUBR-SYNONYM 'IS-FUN 'FUNCTIONP)

;(SUBR-SYNONYM 'FUNDEF->FUN 'IDENTITY)
(DEFUN FUNDEF->FUN (X)
   (EVAL `(FUNCTION ,X))   )

(SUBR-SYNONYM 'FUNDEF->LAMBDA 'IDENTITY)

(SUBR-SYNONYM 'CR 'IDENTITY)

(SUBR-SYNONYM 'GVAL 'EVAL)
(SUBR-SYNONYM 'GSET 'SET)

(DEFUN CONDENSE (X)
   (COND ((SIMPLE-VECTOR-P X)
          (COND ((= (VECTOR-LENGTH X) 0) '#())
                ((= (VECTOR-LENGTH X) 1)
                 (VECTOR (CONDENSE (VREF X 0))))
                (T
                 (VECTOR (CONDENSE (VREF X 0)) '--))   ))
          ((OR (SYMBOLP X) (SIMPLE-STRING-P X) (NUMBERP X))
           X)
          ((CONSP X)
           (CONS (CONDENSE (CAR X)) (AND (CDR X) '(--))))
          (T '--)   ))

(SUBR-SYNONYM 'IS-NUMBER 'NUMBERP)
(SUBR-SYNONYM 'IS-FLOAT 'FLOATP)
(SUBR-SYNONYM 'IS-RATIONAL 'RATIONALP)
(DEFUN IS-RATIO (X) (TYPEP X 'RATIO)   )
(SUBR-SYNONYM 'IS-INTEGER 'INTEGERP)
(DEFUN IS-FIXNUM (X) (TYPEP X 'FIXNUM))

(SUBR-SYNONYM 'IS-EVEN 'EVENP)
(SUBR-SYNONYM 'IS-ODD 'ODDP)

;; Nov.4.87 added
(SUBR-SYNONYM 'FLOOR2 'FLOOR)
(SUBR-SYNONYM 'CEILING2 'CEILING)
(SUBR-SYNONYM 'TRUNCATE2 'TRUNCATE)
(SUBR-SYNONYM 'ROUND2 'ROUND)
(SUBR-SYNONYM 'QUOTIENT 'TRUNCATE)
(SUBR-SYNONYM 'REMAINDER 'REM)

(SUBR-SYNONYM 'ATAN2 'ATAN)

(DEFUN BIT-FIELD (I POS SIZE)
   (LDB (BYTE SIZE POS) I)   )

(DEFUN BIT-FIELD-MODIFIED (I POS SIZE NEW)
   (DPB NEW (BYTE SIZE POS) I)   )

(DEFSETF BIT-FIELD BIT-FIELD-MODIFIED)

(DEFUN FX+ (I J) (DECLARE (FIXNUM I J)) (THE FIXNUM (+ I J)))
(DEFUN FX- (I J) (DECLARE (FIXNUM I J)) (THE FIXNUM (- I J)))
(DEFUN FX* (I J) (DECLARE (FIXNUM I J)) (THE FIXNUM (* I J)))
(DEFUN FX/ (I J) (DECLARE (FIXNUM I J)) (THE FIXNUM (TRUNCATE I J)))

(DEFUN FL+ (I J) (DECLARE #+:LCL4.0-BUG-1 (OPTIMIZE (SPEED 0)) (FLOAT I J)) (THE FLOAT (+ I J)))
(DEFUN FL- (I J) (DECLARE #+:LCL4.0-BUG-1 (OPTIMIZE (SPEED 0)) (FLOAT I J)) (THE FLOAT (- I J)))
(DEFUN FL* (I J) (DECLARE (FLOAT I J)) (THE FLOAT (* I J)))
(DEFUN FL/ (I J) (DECLARE (FLOAT I J)) (THE FLOAT (/ I J)))

(DEFUN FX= (I J) (DECLARE (FIXNUM I J)) (= I J))
(DEFUN FX< (I J) (DECLARE (FIXNUM I J)) (< I J))
(DEFUN FX> (I J) (DECLARE (FIXNUM I J)) (> I J))
(DEFUN FX=< (I J)(DECLARE (FIXNUM I J)) (<= I J))
(DEFUN FX>= (I J)(DECLARE (FIXNUM I J)) (>= I J))

(DEFUN FL= (I J) (DECLARE (FLOAT I J)) (= I J))
(DEFUN FL< (I J) (DECLARE (FLOAT I J)) (< I J))
(DEFUN FL> (I J) (DECLARE (FLOAT I J)) (> I J))
(DEFUN FL=< (I J)(DECLARE (FLOAT I J)) (<= I J))
(DEFUN FL>= (I J)(DECLARE (FLOAT I J)) (>= I J))

(PROCLAIM '(INLINE FX+ FX- FX* FX/ FX= FX< FX> FX=< FX>=
                   FL+ FL- FL* FL/ FL= FL< FL> FL=< FL>=))

(SUBR-SYNONYM '=< '<=)

(SUBR-SYNONYM 'FXRANDOM 'RANDOM)
(SUBR-SYNONYM 'FLRANDOM 'RANDOM)

(SUBR-SYNONYM 'LOGOR 'LOGIOR)

(DEFUN ->INTEGER (N) (VALUES (TRUNCATE N)))
(SUBR-SYNONYM '->FLOAT 'FLOAT)

(SUBR-SYNONYM 'CHAR=< 'CHAR<=)

(DEFUN CHAR- (C1 C2) (- (CHAR-CODE C1) (CHAR-CODE C2))   )

(DEFUN CHAR+ (C D) (CODE-CHAR (+ (CHAR-CODE C) D))   )

(SUBR-SYNONYM 'IS-CHAR 'CHARACTERP)
(SUBR-SYNONYM 'IS-ALPHABETIC 'ALPHA-CHAR-P)
(SUBR-SYNONYM 'IS-DIGIT 'DIGIT-CHAR-P)
(SUBR-SYNONYM 'IS-UPPER-CASE 'UPPER-CASE-P)
(SUBR-SYNONYM 'IS-LOWER-CASE 'LOWER-CASE-P)

(DEFUN IS-WHITESPACE (CH)
   (OR (CHAR= CH #\SPACE)
       (NOT (GRAPHIC-CHAR-P CH)))   )

(DEFVAR CHARFLOOR* -1)
(DEFVAR CHARCEIL* CHAR-CODE-LIMIT)


(SUBR-SYNONYM 'CHAR->ASCII 'CHAR-CODE)
(SUBR-SYNONYM 'ASCII->CHAR 'CODE-CHAR)

(SUBR-SYNONYM 'IS-SYMBOL 'SYMBOLP)

;; Macro for building new symbols.  (SYMBOL -specs-) creates a symbol
;; whose print name is built out of specs.  An atomic or string spec is
;; concatenated in.  A spec of the form (< e1 e2 ...) has each eI evaluated
;; and its characters concatenated in.  A spec of the form (++ e) increments e
;; and concatenates in its characters.  Anything else is supposed to
;; evaluate to a list of characters, which are concatenated in.
;; Example: If A = FOO, B = (1 2 3), and C = (B A R), then
;; (SYMBOL /!! (< A) (++ (CAR B)) (CDR C) "< >") is /!!FOO2AR</ >, and
;; B becomes (2 2 3).
(DEFMACRO SYMBOL (&REST L)
   `(INTERN1 ,(SYMSTUFF L))   )

(DEFMACRO BUILD-SYMBOL (&REST L) `(SYMBOL ,@L)   )

;; Changed 88.4.15:  The old implementation didn't match the documentation,
;; and inspection showed that neither one was right.  The new version
;; dispenses with the possibility that a list of characters may be involved,
;; and assumes things it can't understand can be coerced to strings.
(DEFUN SYMSTUFF (L)
   (COND ((MEMBER '(INVIS) L :TEST #'EQUAL)
	  (FORMAT *ERROR-OUTPUT* 
		  "Warning: (INVIS) symbols no longer implemented~%")
	  (SETF L (REMOVE '(INVIS) L :TEST #'EQUAL)))   )
   `(CONCATENATE 'STRING
     . ,(MAPCAN
           (\\ (X)  (COND ((STRINGP X) (LIST `',X))
                          ((OR (NUMBERP X) (SYMBOLP X))
                           (LIST `',(SYMBOL->STRING X)))
                          ((ATOM X)
                           (LIST `(COERCE-TO-STRING ,X)))
                          ((EQ (CAR X) '<)
			   (MAPCAR (\\ (Y) `(COERCE-TO-STRING ,Y)   )
				   (CDR X)))
                          ((EQ (CAR X) '++)
                           (LIST `(LET ((| COUNT | (FX+ 1 ,(CADR X))))
				     (SETF ,(CADR X) | COUNT |)
				     (SYMBOL->STRING | COUNT |)   )))
                          (T (LIST `(COERCE-TO-STRING ,X)))   ))
            L)   ))

;; added 88.4.15 for SYMSTUFF
(DEFUN COERCE-TO-STRING (X)
   (COND ((STRINGP X) X)
	 ((CHARACTERP X) (CHAR->STRING X))
	 ((OR (NUMBERP X) (SYMBOLP X))
	  (SYMBOL->STRING X))
	 (T (FORMAT NIL "~s" X))   ))

(DEFUN INTERN1 (S) (VALUES (INTERN S ;(FIND-PACKAGE "NISP")
				   ))   )

(DEFUN NUMBER->STRING (THING)
   (LET ((*PRINT-RADIX* NIL))
     (PRINC-TO-STRING THING)   ))

(DEFUN SYMBOL->STRING (THING)
   (COND ((NUMBERP THING) (NUMBER->STRING THING))
         (T (SYMBOL-NAME THING))   ))


;;; Property List definitions moved from util, which now
;;; uses only NISP functions; also eliminated now-unnecessary
;;; PROP-SET code to return value (SETF does this anyway). ** Wright

(SUBR-SYNONYM 'PLIST 'SYMBOL-PLIST)

(DEFUN SETPLIST (SYM LST)
  (SETF (SYMBOL-PLIST SYM) LST))

(DEFSETF PLIST SETPLIST)

(DEFUN PROP (IND SYM) (GET SYM IND))

(DEFUN PROP-SET (IND SYM VAL) (SETF (GET SYM IND) VAL)   )

(DEFSETF PROP PROP-SET)

(SUBR-SYNONYM 'IS-PAIR 'CONSP)

(SUBR-SYNONYM 'LIST-COPY 'COPY-LIST)

; Is this more or less efficient than the corresponding SUBR-SYNONYM?
(DEFUN LIST-SUBSEQ (L I J) (SUBSEQ (THE LIST L) I J)   )

(DEFUN LIST-ELT (L I) (ELT (THE LIST L) I)   )

(DEFSETF LIST-ELT (L I) (X) `(SETF (ELT (THE LIST ,L) ,I) ,X)   )

;; LIST-LENGTH should not be defined in terms of LENGTH!
;; Its definition in CL is more specific, and -especially
;; without being shadowed- redefinition can cause fatal
;; errors.  Leave the better definition alone!
;; (DEFUN LIST-LENGTH (L) (LENGTH (THE LIST L))   )

(DEFUN LEN (L) (LENGTH (THE LIST L))   )

(DEFUN LIST-CONCAT (&REST LL) (APPLY #'CONCATENATE 'LIST LL))

(SUBR-SYNONYM 'NTHELT 'NTH)

(DEFSETF NTHELT (N L) (X) `(SETF (NTH ,N ,L) ,X))

(SUBR-SYNONYM 'NTHTAIL 'NTHCDR)

(SUBR-SYNONYM 'LASTTAIL 'LAST)

(DEFUN LASTTAIL-SET (L X)
   (IF (OR (ATOM L)(NULL (CDR L)))
       (ERROR "~S has no last tail which could be set to ~S~%" L (CONDENSE X))
       (DO ((L L (CDR L)))
	   ((NULL (CDDR L))
	    (SETF (CDR L) X)))))
  
(DEFSETF LASTTAIL LASTTAIL-SET)

(DEFUN LASTELT  (L) (CAR (LAST L))   )
(DEFUN LASTELEM (L) (CAR (LAST L))   )
(DEFSETF LASTELT  (L) (X) `(SETF (CAR (LAST ,L)) ,X)   )
(DEFSETF LASTELEM (L) (X) `(SETF (CAR (LAST ,L)) ,X)   )

(DEFUN TAKE (N L)
   (DECLARE (TYPE FIXNUM N)
            (TYPE LIST L))
   (COND ((< N 0)
          (LET ((G (LENGTH L)))  (SUBSEQ L (+ G N) G)   ))
         (T (SUBSEQ L 0 N))   ))

(DEFUN DROP (N L)
   (DECLARE (TYPE FIXNUM N)
            (TYPE LIST L))
   (COND ((< N 0) (SUBSEQ L 0 (+ (LENGTH L) N)))
         (T (SUBSEQ L N (LENGTH L)))   ))

(SUBR-SYNONYM 'DREVERSE 'NREVERSE)
(SUBR-SYNONYM 'IS-TAIL 'TAILP)

(DEFUN SUBST= (EQT X Y Z) (SUBST X Y Z :TEST EQT)   )

(DEFUN SUBSTQ (X Y Z) (SUBST X Y Z :TEST #'EQ)   )

;; RPLACAD... mostly in misc.nsp, but T version of these
;;  in base.t so CL version also moved to base.l
(DEFUN RPLACAD (X Y) (SETF (CADR X) Y)   )
(DEFUN RPLACADD (X Y) (SETF (CADDR X) Y)   )
(DEFUN RPLACADDD (X Y) (SETF (CADDDR X) Y)   )
(DEFUN RPLACADDDD (X Y) (SETF (CAR (CDDDDR X)) Y)   )
;avoids circular defs. for Explorers
(DEFUN RPLACDD (X Y) (SETF (CDR (CDR X)) Y))
(DEFUN RPLACDDD (X Y) (SETF (CDR (CDDR X)) Y))

(DEFUN LCONC (PTR L)
    (COND ((NULL L) PTR)
          ((NULL PTR) (SETQ PTR (CONS L (LAST L))) PTR)
          ((EQ (CAR PTR) NIL)
           (RPLACA PTR L)
           (RPLACD PTR (LAST L))
           PTR)
          (T (RPLACD (CDR PTR) L)
             (RPLACD PTR (LAST L))
             PTR)   ))

(DEFUN TCONC (PTR E) (LCONC PTR (LIST E))   )

(DEFMACRO CONSET (L X) `(PUSH ,X ,L)   )

;YOU asked for it -- you GOT it -- IOTA  !!
(DEFUN SERIES (&OPTIONAL L H I)
   (COND ((NULL I)
          (SETF I 1)
          (COND ((NULL H) (SETF H L) (SETF L 1))   ))   )
   (COND ((> L H) NIL)
         (T (MAKE-SERIES L H I))   ))

(DEFUN MAKE-SERIES (L H I)
   (DECLARE (FIXNUM L H I))
   (LET ((ANS (LIST L)))
      (DO ((TAIL ANS)
           (L (+ L I) (+ L I)))
          ((> L H) ANS)
         (SETF (CDR TAIL) (LIST L))
         (SETF TAIL (CDR TAIL))   )))

(DEFUN ASSOCQ (K AL) (ASSOC K AL :TEST #'EQ)   )

;; Explorer may complain about Zetalisp overlap with this
;!S(- TI)
(DEFUN ASSQ (K AL) (ASSOC K AL :TEST #'EQ)   )

(DEFUN ASSOC= (EQT X AL) (ASSOC X AL :TEST EQT)   )

(DEFUN MEMBER= (EQT X L) (MEMBER X L :TEST EQT)   )

(DEFUN MEMBERQ (X L) (MEMBER X L :TEST #'EQ)   )
;!S(- TI)
(DEFUN MEMQ (X L) (MEMBER X L :TEST #'EQ)   )

(DEFUN ENTER (V L) (ADJOIN V L :TEST #'EQUAL)   )
(DEFUN ENTQ (V L) (ADJOIN V L :TEST #'EQ)   )

(DEFUN ADJOIN= (EQT X L) (ADJOIN X L :TEST EQT)   )
(DEFUN ADJOINQ (X L) (ADJOIN X L :TEST #'EQ)   )

(DEFUN UNION= (EQT L1 L2) (UNION L1 L2 :TEST EQT)   )
(DEFUN UNIONQ (L1 L2) (UNION L1 L2 :TEST #'EQ)   )

(DEFUN INTERSECTION= (EQT L1 L2) (INTERSECTION L1 L2 :TEST EQT)   )
(DEFUN INTERSECTIONQ (L1 L2) (INTERSECTION L1 L2 :TEST #'EQ)   )


(DEFMACRO DEFINE-DELETER (NAME TESTER DESTRUCTO WHICH)
   (LET ((D-SW (MEMQ DESTRUCTO '(DESTRUCTIVE T D)))
         (E-SW (MEMQ WHICH '(EVERY ALL T))))
      (LET ((CLNAME (SYMBOL (< (COND (D-SW 'DELETE) (T 'REMOVE)   ))
                            (IF (EQ TESTER 'TEST) '-IF "")   )))
         `(DEFUN ,NAME
                 ,(CASE TESTER (EQTEST '(TST X L))
                               (T '(X L))   )
             (DECLARE (TYPE LIST L))
             (,CLNAME X L ,@(CASE TESTER
                               (EQTEST '(:TEST TST))
                               (TEST NIL)
                               (T `(:TEST #',TESTER))   )
                          ,@(COND (E-SW NIL) (T '(:COUNT 1))   ))   ))))

   
(DEFINE-DELETER REMOVE1=         EQTEST NONDESTRUCTIVE ONE)
(DEFINE-DELETER REMOVE1          EQL    NONDESTRUCTIVE ONE)
(DEFINE-DELETER REMOVE1Q         EQ     NONDESTRUCTIVE ONE)
(DEFINE-DELETER REMOVE1-IF       TEST   NONDESTRUCTIVE ONE)
(DEFINE-DELETER DREMOVE1=        EQTEST DESTRUCTIVE    ONE)
(DEFINE-DELETER DREMOVE1         EQL    DESTRUCTIVE    ONE)
(DEFINE-DELETER DREMOVE1Q        EQ     DESTRUCTIVE    ONE)
(DEFINE-DELETER DREMOVE1-IF      TEST   DESTRUCTIVE    ONE)
(DEFINE-DELETER REMOVE-EVERY=    EQTEST NONDESTRUCTIVE EVERY)
(DEFINE-DELETER REMOVE-EVERY     EQL    NONDESTRUCTIVE EVERY)
(DEFINE-DELETER REMOVE-EVERYQ    EQ     NONDESTRUCTIVE EVERY)
(DEFINE-DELETER REMOVE-EVERY-IF  TEST   NONDESTRUCTIVE EVERY)
(DEFINE-DELETER DREMOVE-EVERY=   EQTEST DESTRUCTIVE    EVERY)
(DEFINE-DELETER DREMOVE-EVERY    EQL    DESTRUCTIVE    EVERY)
(DEFINE-DELETER DREMOVE-EVERYQ   EQ     DESTRUCTIVE    EVERY)
(DEFINE-DELETER DREMOVE-EVERY-IF TEST   DESTRUCTIVE    EVERY)

(DEFINE-DELETER REM1             EQL    NONDESTRUCTIVE ONE)
(DEFINE-DELETER REM1Q            EQ     NONDESTRUCTIVE ONE)
(DEFINE-DELETER DREM1            EQL    DESTRUCTIVE    ONE)
(DEFINE-DELETER DREM1Q           EQ     DESTRUCTIVE    ONE)
(DEFINE-DELETER REMA             EQL    NONDESTRUCTIVE EVERY)
(DEFINE-DELETER REMAQ            EQ     NONDESTRUCTIVE EVERY)
(DEFINE-DELETER DREMA            EQL    DESTRUCTIVE    EVERY)
(DEFINE-DELETER DREMAQ           EQ     DESTRUCTIVE    EVERY)

(DEFUN COMPLEMENT= (EQT L1 L2) (SET-DIFFERENCE L1 L2 :TEST EQT)   )
(DEFUN COMPLEMENT (L1 L2) (SET-DIFFERENCE L1 L2)   )
(DEFUN COMPLEMENTQ (L1 L2) (SET-DIFFERENCE L1 L2 :TEST #'EQ)   )

(DEFUN SET-DIFFERENCE= (EQT L1 L2) (SET-DIFFERENCE L1 L2 :TEST EQT)   )
(DEFUN SET-DIFFERENCEQ (L1 L2) (SET-DIFFERENCE L1 L2 :TEST #'EQ)   )

(DEFUN IS-SUBLIST= (EQT L1 L2) (SUBSETP L1 L2 :TEST EQT)   )
(DEFUN IS-SUBLIST (L1 L2) (SUBSETP L1 L2)   )
(DEFUN IS-SUBLISTQ (L1 L2) (SUBSETP L1 L2 :TEST #'EQ)   )

(DEFUN NODUP= (EQT L) (REMOVE-DUPLICATES (THE LIST L) :TEST EQT)   )
(DEFUN NODUP (L) (REMOVE-DUPLICATES (THE LIST L))   )
(DEFUN NODUPQ (L) (REMOVE-DUPLICATES (THE LIST L) :TEST #'EQ)   )
(DEFUN DNODUP= (EQT L) (DELETE-DUPLICATES (THE LIST L) :TEST EQT)   )
(DEFUN DNODUP (L) (DELETE-DUPLICATES (THE LIST L))   )
(DEFUN DNODUPQ (L) (DELETE-DUPLICATES (THE LIST L) :TEST #'EQ)   )

(DEFUN IS-ARRAY (X) (TYPEP X 'ARRAY)   )

(SUBR-SYNONYM 'MAKE-VECTOR 'MAKE-ARRAY)
(SUBR-SYNONYM 'IS-VECTOR 'SIMPLE-VECTOR-P)  ; I guess
(SUBR-SYNONYM 'VECTOR-ELT 'SVREF)
(SUBR-SYNONYM 'VREF 'SVREF)
(DEFSETF VECTOR-ELT (V I) (X) `(SETF (SVREF ,V ,I) ,X)   )
(DEFSETF VREF (V I) (X) `(SETF (SVREF ,V ,I) ,X)   )

(DEFUN VECTOR-LENGTH (V) (ARRAY-DIMENSION V 0)   )

(DEFUN VECTOR-COPY (V) (COPY-SEQ (THE SIMPLE-VECTOR V))   )

(DEFUN VECTOR-SUBSEQ (V I J) (SUBSEQ (THE SIMPLE-VECTOR V) I J)   )

(DEFUN VECTOR-CONCAT (&REST VL) (APPLY #'CONCATENATE 'VECTOR VL)   )

;; Nov.4.87 added
(DEFUN LIST->VECTOR (L) (APPLY #'VECTOR L)   )
(DEFUN VECTOR->LIST (V) (COERCE V 'LIST)   )

;; Nov.4.87 added
(DEFUN INITIALIZED-ARRAY (DIMS INIT) (MAKE-ARRAY DIMS :INITIAL-ELEMENT INIT)   )

(SUBR-SYNONYM 'IS-STRING 'SIMPLE-STRING-P)

(DEFUN STRING-COPY (S) (COPY-SEQ (THE SIMPLE-STRING S))   )

(DEFUN STRING-SUBSEQ (S I J) (SUBSEQ (THE SIMPLE-STRING S) I J)   )

(DEFUN SUBSTRNG (STRING FROM TO)
   (LISP:DECLARE (STRING STRING))
   (SUBSEQ STRING (- FROM 1) TO)   )

(SUBR-SYNONYM 'STRING-ELT 'SCHAR)

;!S(- TI)
(DEFUN STRING-LENGTH (S) (LENGTH (THE SIMPLE-STRING S))   )

(DEFUN STRING-CONCAT (&REST VL) (APPLY #'CONCATENATE 'STRING VL)   )

(DEFUN NTHCHR (OFFSET STRING) (ELT (STRING STRING) (1- OFFSET)))


(DEFUN CHAR->SYMBOL (CHR) (VALUES (INTERN (STRING CHR) ;(FIND-PACKAGE "NISP")
					  )))

(DEFUN SYMBOL->CHAR (SYM) (SCHAR (SYMBOL-NAME SYM) 0)   )

(SUBR-SYNONYM 'CHAR->STRING 'STRING)

(DEFUN STRING->SYMBOL (STR) (VALUES (INTERN STR ;(FIND-PACKAGE "NISP")
					    )))

(DEFUN STRING->LIST (S) (COERCE S 'LIST)   )
(DEFUN LIST->STRING (L) (COERCE L 'STRING)   )

(DEFUN LIST->SYMBOL (L)
   (VALUES (INTERN (COERCE L 'STRING) ;(FIND-PACKAGE "NISP")
		   )))

(DEFUN LIST->INVISYM (L) (MAKE-SYMBOL (COERCE L 'STRING))  )

(DEFUN SYMBOL->LIST (S) (COERCE (SYMBOL->STRING S) 'LIST)   )

(DEFUN STRING->NUMBER (S)
   (DECLARE (SIMPLE-STRING S))
   (MULTIPLE-VALUE-BIND (X L) (READ-FROM-STRING S NIL NIL)
      (COND ((AND (= L (LENGTH S))
                  (NUMBERP X))
             X)
            (T (ERROR "Can't extract a number from ~S~%" S))   )))

(DEFUN MAKE-EQ-HASH-TABLE () (MAKE-HASH-TABLE :TEST #'EQ))

(DEFUN TABLE-ENTRY (HTAB KEY) (VALUES (GETHASH KEY HTAB)))

(DEFSETF TABLE-ENTRY (HTAB KEY) (X) `(SETF (GETHASH ,KEY ,HTAB) ,X))

(SUBR-SYNONYM 'IS-HASH-TABLE 'HASH-TABLE-P)
(SUBR-SYNONYM 'WALK-TABLE    'MAPHASH) ; Added 6.3.88
(SUBR-SYNONYM 'FRESH-TABLE   'CLRHASH) ; Added 7.7.88

(DEFVAR SYMS* 
  '(SYMS*.1 SYMS*.2 SYMS*.3 SYMS*.4 SYMS*.5 SYMS*.6 SYMS*.7 SYMS*.8 SYMS*.9
    SYMS*.10 SYMS*.11 SYMS*.12 SYMS*.13 SYMS*.14 SYMS*.15 SYMS*.16 SYMS*.17 SYMS*.18 SYMS*.19))

(DEFUN NSYMS (N) (SUBSEQ SYMS* 0 N)   )

(DEFMACRO *SPLICE* (&REST EXPS) `(PROGN . ,EXPS)   )

(DEFUN READABLY-PRINTABLE-ATOM (X)
   (OR (SYMBOLP X) (NUMBERP X) (STRINGP X))   )


;; HERALD: documented for T, otherwise available for special hacks
;;   e.g. setting *readtable* back to nisp-read-table* for each file
;;   on lisp machines until suitable system hacks are found. ** Wright
(DEFMACRO HERALD (&REST BODY)
   (DECLARE (LISP:IGNORE BODY))
   (VALUES))

(PROCLAIM '(SPECIAL NOW-LOADING*))
; Don't want to confuse it with DSKLAP here.

; 87.8.24:
(DEFVAR OVERDRIVE* NIL)

(DEFMACRO OVERDRIVE ()
   (SETQ OVERDRIVE* T)
   #+(and HP (not :LUCID)) `(PROCLAIM '(OPTIMIZE (SPEED 2) (SAFETY 0))) 
   #-(and HP (not :LUCID)) `(PROCLAIM '(OPTIMIZE (SPEED 3) (SAFETY 0))) )

!S(- VMS)
(DEFUN JJ () (LET ((NOW-LOADING* NIL)) (LOAD "jj"))   )
!S(VMS)
(DEFUN JJ () (LET ((NOW-LOADING* NIL)) (LOAD "JJ."))   )

;; Obsolete NISP defs. unique to CL
(SUBR-SYNONYM 'EQSTR 'STRING=)

