function sspipam(caseid)
%SSPIPAM SSPI 'sxaf' program front-end.
%       SSPIPAM('CASEID') provides a graphical user interface to 
%       the SSPI software package 'pam' program.  'CASEID' is 
%       the case identifier assigned to the input signal.  SSPI 
%       files are normally identified by the filename format 
%       'pam_caseid.*'.  Upon startup, SSPIPAM attemts to read
%       the 'pam_caseid.inp' file used to store the command-
%       line options for the 'pam' program.  If found, the 
%       dialog box values are set to those found in the '.inp'
%       file.  If the file has not been created or cannot be found,
%       the dialog box values are set to default values with 
%       the caseid set to 'CASEID'. 
%
%       SSPIPAM opens the dialog box with default values set 
%       and no caseid.  If no caseid has been assigned when the
%       'Save' or 'Execute' pushbuttons are pressed, a default 
%       caseid of 'temp' is used.
%
%       See the SSPI documentation for descriptions of the 
%       input variables to the 'pam' program.
%
%       See also SSPISXAF, LOADSSPI, LOADSURF

%       Programming note:
%       See also EXECPAM, SAVEPAM, LOADPAM.

%       Dennis W. Brown 1-16-94, DWB 1-21-94
%       Naval Postgraduate School, Monterey, CA
%       May be freely distributed.
%       Not for use in commercial products.


b_hite = 22;
b_width = 150;
b_int = 5;

rows = (0:11) .* (b_hite + b_int) + 5;
columns = (0:3) .* (b_width + b_int) + 5;

cfore = 'white';
cback = 'blue';
hback = 'magenta';

% get screen size
scz = get(0,'ScreenSize');

% create figure window in upper left corner
f = figure('Units','Pixels','Color',cback, ...
            'Position',[20 scz(4)-max(rows)-b_hite-b_int-30 ...
 		max(columns)+b_width+b_int ...
                max(rows)+b_hite+b_int], ...
            'Name','SSPI PAM Program Interface', ...
 	    'NumberTitle','off','nextplot','new', ...
            'Resize','off');

% Bit seed group
uicontrol(f,'Style','text','Horiz','right', ...
    'BackGround',cback,'ForeGround',cfore, ...
    'Position',[columns(1) rows(12) b_width b_hite], ...
    'String','Bit-seed (-bits)')

uicontrol(f,'Style','edit','Horiz','right', ...
    'BackGround',hback,'ForeGround',cfore, ...
    'Position',[columns(2) rows(12) b_width b_hite], ...
    'UserData','Bit-seed (-bits)')

% Noise-seed (-noise) group
uicontrol(f,'Style','text','Horiz','right', ...
    'BackGround',cback,'ForeGround',cfore, ...
    'Position',[columns(3) rows(12) b_width b_hite], ...
    'String','Noise-seed (-noise)')

uicontrol(f,'Style','edit','Horiz','right', ...
    'BackGround',hback,'ForeGround',cfore, ...
    'Position',[columns(4) rows(12) b_width b_hite], ...
    'UserData','Noise-seed (-noise)')

% Case-ID group
uicontrol(f,'Style','text','Horiz','right', ...
    'BackGround',cback,'ForeGround',cfore, ...
    'Position',[columns(1) rows(11) b_width b_hite], ...
    'String','Case-ID')

uicontrol(f,'Style','edit','Horiz','right', ...
    'BackGround',hback,'ForeGround',cfore, ...
    'Position',[columns(2) rows(11) b_width b_hite], ...
    'UserData','Case-ID', ...
    'CallBack',['sspi_f = gcf; set(sspi_f,''Pointer'',''watch''); ' ...
               'loadpam(sspi_f); set(sspi_f,''Pointer'',''arrow'');']);


% Number-of-Samples group
uicontrol(f,'Style','text','Horiz','right', ...
    'BackGround',cback,'ForeGround',cfore, ...
    'Position',[columns(1) rows(10) b_width b_hite], ...
    'String','Number-of-Samples')

uicontrol(f,'Style','edit','Horiz','right', ...
    'BackGround',hback,'ForeGround',cfore, ...
    'Position',[columns(2) rows(10) b_width b_hite], ...
    'UserData','Number-of-Samples', ...
    'Callback',['sspi_h = findedit(gcf,''Number-of-Samples'');'...
                'sspi_N = str2num(get(sspi_h,''String''));'...
                'sspi_N = 2^ceil(log2(sspi_N));' ...
                'set(sspi_h,''String'',int2str(sspi_N));' ...
                ]);

% Samples-per-Symbol group
uicontrol(f,'Style','text','Horiz','right', ...
    'BackGround',cback,'ForeGround',cfore, ...
    'Position',[columns(1) rows(9) b_width b_hite], ...
    'String','Samples-per-Symbol')

uicontrol(f,'Style','edit','Horiz','right', ...
    'BackGround',hback,'ForeGround',cfore, ...
    'Position',[columns(2) rows(9) b_width b_hite], ...
    'UserData','Samples-per-Symbol', ...
    'Callback',['sspi_h = findedit(gcf,''Samples-per-Symbol'');'...
                'sspi_N = str2num(get(sspi_h,''String''));'...
                'if sspi_N <= 0,' ...
                '  disp(''sspipam: Samples-per-symbol must be > 0'');' ...
                '  set(sspi_h,''String'','''');' ...
                'else,' ...
                '  set(sspi_h,''String'',int2str(sspi_N));' ...
                'end;' ...
                ]);

% Bits-per-Symbol group
uicontrol(f,'Style','text','Horiz','right', ...
    'BackGround',cback,'ForeGround',cfore, ...
    'Position',[columns(1) rows(8) b_width b_hite], ...
    'String','Bits-per-Symbol')

uicontrol(f,'Style','edit','Horiz','right', ...
    'BackGround',hback,'ForeGround',cfore, ...
    'Position',[columns(2) rows(8) b_width b_hite], ...
    'UserData','Bits-per-Symbol', ...
    'Callback',['sspi_h = findedit(gcf,''Bits-per-Symbol'');'...
                'sspi_N = str2num(get(sspi_h,''String''));'...
                'if sspi_N <= 0,' ...
                '  disp(''sspipam: Bits-per-Symbol must be > 0'');' ...
                '  set(sspi_h,''String'','''');' ...
                'else,' ...
                '  set(sspi_h,''String'',int2str(sspi_N));' ...
                'end;' ...
                ]);

% Constellation group
uicontrol(f,'Style','text','Horiz','right', ...
    'BackGround',cback,'ForeGround',cfore, ...
    'Position',[columns(1) rows(7) b_width b_hite], ...
    'String','Constellation')

uicontrol(f,'Style','popupmenu','Horiz','right', ...
    'BackGround',hback,'ForeGround',cfore, ...
    'String','PSK|QAM', ...
    'Position',[columns(2) rows(7) b_width b_hite], ...
    'UserData','Constellation');

% Pulse-Type group
uicontrol(f,'Style','text','Horiz','right', ...
    'BackGround',cback,'ForeGround',cfore, ...
    'Position',[columns(1) rows(6) b_width b_hite], ...
    'String','Pulse-Type')

uicontrol(f,'Style','popupmenu','Horiz','right', ...
    'BackGround',hback,'ForeGround',cfore, ...
    'String','rect|bl_rect|halfcos|bl_halfcos|nyq', ...
    'Position',[columns(2) rows(6) b_width b_hite], ...
    'UserData','Pulse-Type');

% Pulse-Bandwidth group
uicontrol(f,'Style','text','Horiz','right', ...
    'BackGround',cback,'ForeGround',cfore, ...
    'Position',[columns(1) rows(5) b_width b_hite], ...
    'String','Pulse-Bandwidth')

uicontrol(f,'Style','edit','Horiz','right', ...
    'BackGround',hback,'ForeGround',cfore, ...
    'Position',[columns(2) rows(5) b_width b_hite], ...
    'UserData','Pulse-Bandwidth', ...
    'Callback',['sspi_h = findedit(gcf,''Pulse-Bandwidth'');'...
                'sspi_N = str2num(get(sspi_h,''String''));'...
                'if sspi_N < 1,' ...
                '  disp(''sspipam: Pulse-Bandwidth must be > 1.0'');' ...
                '  set(sspi_h,''String'','''');' ...
                'else,' ...
                '  set(sspi_h,''String'',num2str(sspi_N));' ...
                'end;' ...
                ]);

% Pulse-Tail-Exp group
uicontrol(f,'Style','text','Horiz','right', ...
    'BackGround',cback,'ForeGround',cfore, ...
    'Position',[columns(1) rows(4) b_width b_hite], ...
    'String','Pulse-Tail-Exp')

uicontrol(f,'Style','edit','Horiz','right', ...
    'BackGround',hback,'ForeGround',cfore, ...
    'Position',[columns(2) rows(4) b_width b_hite], ...
    'UserData','Pulse-Tail-Exp', ...
    'Callback',['sspi_h = findedit(gcf,''Pulse-Tail-Exp'');'...
                'sspi_N = str2num(get(sspi_h,''String''));'...
                'if sspi_N >= 0,' ...
                '  disp(''sspipam: Pulse-Tail-Exp must be < 0'');' ...
                '  set(sspi_h,''String'','''');' ...
                'else,' ...
                '  set(sspi_h,''String'',int2str(sspi_N));' ...
                'end;' ...
                ]);

% Delay-Samples group
uicontrol(f,'Style','text','Horiz','right', ...
    'BackGround',cback,'ForeGround',cfore, ...
    'Position',[columns(1) rows(3) b_width b_hite], ...
    'String','Delay-Samples')

uicontrol(f,'Style','edit','Horiz','right', ...
    'BackGround',hback,'ForeGround',cfore, ...
    'Position',[columns(2) rows(3) b_width b_hite], ...
    'UserData','Delay-Samples', ...
    'Callback',['sspi_h = findedit(gcf,''Delay-Samples'');'...
                'sspi_N = str2num(get(sspi_h,''String''));'...
                'set(sspi_h,''String'',num2str(sspi_N));' ...
                ]);

% Real-Freq-Shift group
uicontrol(f,'Style','text','Horiz','right', ...
    'BackGround',cback,'ForeGround',cfore, ...
    'Position',[columns(1) rows(2) b_width b_hite], ...
    'String','Real-Freq-Shift')

uicontrol(f,'Style','edit','Horiz','right', ...
    'BackGround',hback,'ForeGround',cfore, ...
    'Position',[columns(2) rows(2) b_width b_hite], ...
    'UserData','Real-Freq-Shift', ...
    'Callback',['sspi_h = findedit(gcf,''Real-Freq-Shift'');'...
                'sspi_N = str2num(get(sspi_h,''String''));'...
                'if sspi_N < 0,' ...
                '  disp(''sspipam: Real-Freq-Shift must be >= 0'');' ...
                '  set(sspi_h,''String'','''');' ...
                'else,' ...
                '  set(sspi_h,''String'',int2str(sspi_N));' ...
                'end;' ...
                ]);

% Carrier-Frequency group
uicontrol(f,'Style','text','Horiz','right', ...
    'BackGround',cback,'ForeGround',cfore, ...
    'Position',[columns(3) rows(11) b_width b_hite], ...
    'String','Carrier-Frequency')

uicontrol(f,'Style','edit','Horiz','right', ...
    'BackGround',hback,'ForeGround',cfore, ...
    'Position',[columns(4) rows(11) b_width b_hite], ...
    'UserData','Carrier-Frequency', ...
    'Callback',['sspi_h = findedit(gcf,''Carrier-Frequency'');'...
                'sspi_N = str2num(get(sspi_h,''String''));'...
                'set(sspi_h,''String'',num2str(sspi_N));' ...
                ]);

% Carrier-Phase-Degree group
uicontrol(f,'Style','text','Horiz','right', ...
    'BackGround',cback,'ForeGround',cfore, ...
    'Position',[columns(3) rows(10) b_width b_hite], ...
    'String','Carrier-Phase-Degree')

uicontrol(f,'Style','edit','Horiz','right', ...
    'BackGround',hback,'ForeGround',cfore, ...
    'Position',[columns(4) rows(10) b_width b_hite], ...
    'UserData','Carrier-Phase-Degree', ...
    'Callback',['sspi_h = findedit(gcf,''Carrier-Phase-Degree'');'...
                'sspi_N = str2num(get(sspi_h,''String''));'...
                'set(sspi_h,''String'',num2str(sspi_N));' ...
                ]);

% Over-Sample group
uicontrol(f,'Style','text','Horiz','right', ...
    'BackGround',cback,'ForeGround',cfore, ...
    'Position',[columns(3) rows(9) b_width b_hite], ...
    'String','Over-Sample')

uicontrol(f,'Style','edit','Horiz','right', ...
    'BackGround',hback,'ForeGround',cfore, ...
    'Position',[columns(4) rows(9) b_width b_hite], ...
    'UserData','Over-Sample', ...
    'Callback',['sspi_h = findedit(gcf,''Over-Sample'');'...
                'sspi_N = str2num(get(sspi_h,''String''));'...
                'if sspi_N <= 0,' ...
                '  disp(''sspipam: Samples-per-symbol must be > 0'');' ...
                '  set(sspi_h,''String'','''');' ...
                'else,' ...
                '  set(sspi_h,''String'',int2str(sspi_N));' ...
                'end;' ...
                ]);

% Under-Sample group
uicontrol(f,'Style','text','Horiz','right', ...
    'BackGround',cback,'ForeGround',cfore, ...
    'Position',[columns(3) rows(8) b_width b_hite], ...
    'String','Under-Sample')

uicontrol(f,'Style','edit','Horiz','right', ...
    'BackGround',hback,'ForeGround',cfore, ...
    'Position',[columns(4) rows(8) b_width b_hite], ...
    'UserData','Under-Sample', ...
    'Callback',['sspi_h = findedit(gcf,''Under-Sample'');'...
                'sspi_N = str2num(get(sspi_h,''String''));'...
                'if sspi_N <= 0,' ...
                '  disp(''sspipam: Samples-per-symbol must be > 0'');' ...
                '  set(sspi_h,''String'','''');' ...
                'else,' ...
                '  set(sspi_h,''String'',int2str(sspi_N));' ...
                'end;' ...
                ]);

% Signal-Power (dB) group
uicontrol(f,'Style','text','Horiz','right', ...
    'BackGround',cback,'ForeGround',cfore, ...
    'Position',[columns(3) rows(7) b_width b_hite], ...
    'String','Signal-Power (dB)')

uicontrol(f,'Style','edit','Horiz','right', ...
    'BackGround',hback,'ForeGround',cfore, ...
    'Position',[columns(4) rows(7) b_width b_hite], ...
    'UserData','Signal-Power (dB)', ...
    'Callback',['sspi_h = findedit(gcf,''Signal-Power (dB)'');'...
                'sspi_N = str2num(get(sspi_h,''String''));'...
                'set(sspi_h,''String'',num2str(sspi_N));' ...
                ]);

% Noise-Power (dB) group
uicontrol(f,'Style','text','Horiz','right', ...
    'BackGround',cback,'ForeGround',cfore, ...
    'Position',[columns(3) rows(6) b_width b_hite], ...
    'String','Noise-Power (dB)')

uicontrol(f,'Style','edit','Horiz','right', ...
    'BackGround',hback,'ForeGround',cfore, ...
    'Position',[columns(4) rows(6) b_width b_hite], ...
    'UserData','Noise-Power (dB)', ...
    'Callback',['sspi_h = findedit(gcf,''Noise-Power (dB)'');'...
                'sspi_N = str2num(get(sspi_h,''String''));'...
                'set(sspi_h,''String'',num2str(sspi_N));' ...
                ]);

% AASCII-or-binary group
uicontrol(f,'Style','text','Horiz','right', ...
    'BackGround',cback,'ForeGround',cfore, ...
    'Position',[columns(3) rows(5) b_width b_hite], ...
    'String','ASCII-or-binary')

uicontrol(f,'Style','popupmenu','Horiz','right', ...
    'BackGround',hback,'ForeGround',cfore, ...
    'String','ASCII|binary', ...
    'Position',[columns(4) rows(5) b_width b_hite], ...
    'UserData','ASCII-or-binary');

% Real-Output group
uicontrol(f,'Style','text','Horiz','right', ...
    'BackGround',cback,'ForeGround',cfore, ...
    'Position',[columns(3) rows(4) b_width b_hite], ...
    'String','Real-Output')

uicontrol(f,'Style','checkbox','Horiz','left', ...
    'BackGround',hback,'ForeGround',cfore, ...
    'Position',[columns(4) rows(4) b_width b_hite], ...
    'String','Real-Output');

% Time-Output group
uicontrol(f,'Style','text','Horiz','right', ...
    'BackGround',cback,'ForeGround',cfore, ...
    'Position',[columns(3) rows(3) b_width b_hite], ...
    'String','Time-Output')

uicontrol(f,'Style','checkbox','Horiz','left', ...
    'BackGround',hback,'ForeGround',cfore, ...
    'Position',[columns(4) rows(3) b_width-40 b_hite], ...
    'String','Time-Output');

uicontrol(f,'Style','edit','Horiz','right', ...
    'BackGround',hback,'ForeGround',cfore, ...
    'Position',[columns(4)+112 rows(3) 38 b_hite], ...
    'UserData','Time-Points', ...
    'Callback',['sspi_h = findedit(gcf,''Time-Points'');'...
                'sspi_N = str2num(get(sspi_h,''String''));'...
                'if sspi_N < 0,' ...
                '  disp(''sspipam: Time-Points must be >= 0'');' ...
                '  set(sspi_h,''String'','''');' ...
                'else,' ...
                '  set(sspi_h,''String'',int2str(sspi_N));' ...
                'end;' ...
                ]);

% Frequency-Output group
uicontrol(f,'Style','text','Horiz','right', ...
    'BackGround',cback,'ForeGround',cfore, ...
    'Position',[columns(3) rows(2) b_width b_hite], ...
    'String','Frequency-Output')

uicontrol(f,'Style','checkbox','Horiz','left', ...
    'BackGround',hback,'ForeGround',cfore, ...
    'String','No|Yes', ...
    'Position',[columns(4) rows(2) b_width b_hite], ...
    'String','Frequency-Output');

% load pushbutton
uicontrol(f,'Style','pushbutton','Horiz','center', ...
    'ForeGround',cfore,'String','Load', ...
    'Position',[columns(1) rows(1) b_width b_hite], ...
    'CallBack',['sspi_f = gcf; set(sspi_f,''Pointer'',''watch''); ' ...
               'loadpam(sspi_f); set(sspi_f,''Pointer'',''arrow'');']);

% save pushbutton
uicontrol(f,'Style','pushbutton','Horiz','center', ...
    'ForeGround',cfore,'String','Save', ...
    'Position',[columns(2) rows(1) b_width b_hite], ...
    'CallBack',['sspi_f = gcf; set(sspi_f,''Pointer'',''watch''); ' ...
               'savepam(sspi_f); set(sspi_f,''Pointer'',''arrow'');']);

% Execute pushbutton
uicontrol(f,'Style','pushbutton','Horiz','center', ...
    'ForeGround',cfore,'String','Execute', ...
    'Position',[columns(3) rows(1) b_width b_hite], ...
    'CallBack',['sspi_f = gcf; set(sspi_f,''Pointer'',''watch''); ' ...
               'execpam(sspi_f); set(sspi_f,''Pointer'',''arrow'');']);

% Close pushbutton
uicontrol(f,'Style','pushbutton','Horiz','center', ...
    'ForeGround',cfore,'String','Quit', ...
    'Position',[columns(4) rows(1) b_width b_hite], ...
    'CallBack',[ ...
	'close;' ...
	]);


% default values
set(findedit(f,'Number-of-Samples'),'String','512');
set(findedit(f,'Samples-per-Symbol'),'String','2');
set(findedit(f,'Bits-per-Symbol'),'String','1');
set(findpopu(f,'Constellation'),'Value',1);
set(findpopu(f,'Pulse-Type'),'Value',5);
set(findedit(f,'Pulse-Bandwidth'),'String','1');
set(findedit(f,'Pulse-Tail-Exp'),'String','-2');
set(findedit(f,'Delay-Samples'),'String','0');
set(findedit(f,'Real-Freq-Shift'),'String','0');
set(findedit(f,'Carrier-Frequency'),'String','0');
set(findedit(f,'Carrier-Phase-Degree'),'String','0');
set(findedit(f,'Over-Sample'),'String','1');
set(findedit(f,'Under-Sample'),'String','1');
set(findedit(f,'Signal-Power (dB)'),'String','0');
set(findedit(f,'Noise-Power (dB)'),'String','-1e+20');
set(findpopu(f,'ASCII-or-binary'),'Value',2);
set(findchkb(f,'Real-Output'),'Value',0);
set(findchkb(f,'Time-Output'),'Value',1);
set(findedit(f,'Time-Points'),'String','0');
set(findchkb(f,'Frequency-Output'),'Value',0);

if nargin == 1,

    set(findedit(f,'Case-ID'),'String',caseid);
    loadpam(f);

end;

