%SPCPATH	Script to prepend the SPC Toolbox directories
%	to the MATLABPATH.
%

%	Dennis W. Brown 2-22-94
%	Naval Postgraduate School, Monterey, CA

% check for version 4.1
if ~strcmp(computer,'PCWIN') & str2num(version) < 4.1,
	disp('spctools: Matlab version 4.1 or higher required. Sorry!');
	return;
end;

% get matlab directory (net dependent)
matdir = getenv('MATLAB');

% create new matlabpath string
newpath = [...
	matdir '/toolbox/spctools:'...
	matdir '/toolbox/spctools/spccomms:'...
	matdir '/toolbox/spctools/spcgui:'...
	matdir '/toolbox/spctools/spcline:'...
	matdir '/toolbox/spctools/spcspch:'...
	matdir '/toolbox/spctools/spcsspi:'...
	matdir '/toolbox/spctools/spcutil:'...
	matdir '/toolbox/spctools/spcprog:'...
 	matlabpath ];

matlabpath(newpath)

more on
echo on

% The SPC Toolbox directories have been prepended to
% your MATLABPATH.  Be aware, name conflicts may occur
% if more than one toolbox has a function with the
% same name as an SPC Toolbox command.
%
% For further help on commands available in the SPC
% Toolbox, type:
%
%	help spctools
%	help spccomms
%	help spcline
%	help spcgui
%	help spcspch
%	help spcsspi
%	help spcprog
%	help spcutil
%
%	For questions, email LT Dennis Brown
%		browndw@ece.nps.navy.mil
%	     or dwbrown@cc.nps.navy.mil
%
%	For words of praise, email my thesis advisors:
%		Prof Loomis:  loomis@ece.nps.navy.mil
%		Prof Fargues: fargues@ece.nps.navy.mil
%
% Type "whatsnew spctools" at the Matlab prompt to
%	find out what's new with SPC Tools.
%
%
% SPC Tools last modified at 0100 on 7/6/94.
%
% If you have trouble with this version of SPC Tools, try
% the older (more tested) version.  Use SPCOLD vice SPCPATH.

echo off
more off

clear newpath matdir

if exist('spcnotes') > 0,
	spcnotes
end;
