function [gff] = armadsgn(pf,prop1,val1,prop2,val2,prop3,val3,prop4,val4, ...
    prop5,val5,prop6,val6,prop7,val7,prop8,val8)
%ARMADSGN AR/MA/ARMA design tool.
%	ARMADSGN(PARENT,SIGNAL)

%       Dennis W. Brown 5-17-94, 5-31,94
%       Naval Postgraduate School, Monterey, CA
%       May be freely distributed.
%       Not for use in commercial products.

if max(size(pf)) == 1,

	pa = get(pf,'CurrentAxes');

	signal = get(zoomed(pf),'YData');

	% default properties
	verbose = 0;
	closeonapply = 'off';	% saved in Verbose check box

else
	signal = pf;

	pf = [];

	% default properties
	verbose = 0;
	closeonapply = 'on';	% saved in Verbose check box

end;

% default properties
chain = 'on';
drive = 'on';
minph = 'on';
callbackstr = '';
play = 'on';

% must have first arg
if nargin > 1,
    for i = 1:(nargin-1)/2,
        prop = eval(['prop' int2str(i)]);
        val = eval(['val' int2str(i)]);
        if strcmp(lower(prop),'chain'),
            if strcmp(lower(val),'off'),
                chain = 'off';
            elseif strcmp(lower(val),'on'),
                chain = 'on';
            else,
                error(['armadsgn: Invalid Chain property value "' val '".']);
            end;
        elseif strcmp(lower(prop),'drivingsource'),
            if strcmp(lower(val),'off'),
                drive = 'off';
            elseif strcmp(lower(val),'on'),
                drive = 'on';
            else,
                error(['armadsgn: Invalid DrivingSource property value "' val '".']);
            end;
        elseif strcmp(lower(prop),'minimumphase'),
            if strcmp(lower(val),'off'),
                minph = 'off';
            elseif strcmp(lower(val),'on'),
                minph = 'on';
            else,
                error(['armadsgn: Invalid MinimumPhase property value "' val '".']);
            end;
              elseif strcmp(lower(prop),'verbose'),
            if strcmp(lower(val),'off'),
                verbose = 0;
            elseif strcmp(lower(val),'on'),
                verbose = 1;
            else,
                error(['armadsgn: Invalid Verbose property value "' val '".']);
            end;
        elseif strcmp(lower(prop),'closeonapply'),
            if strcmp(lower(val),'on'),
                closeonapply = 'on';
            elseif strcmp(lower(val),'off'),
                closeonapply = 'off';
            else,
                error(['armadsgn: Invalid CloseOnApply property value "' val '".']);
            end;
        elseif strcmp(lower(prop),'play'),
            if strcmp(lower(val),'on'),
                play = 'on';
            elseif strcmp(lower(val),'off'),
                play = 'off';
            else,
                error(['armadsgn: Invalid Play property value "' val '".']);
            end;
        elseif strcmp(lower(prop),'data'),
		signal = val;
        elseif strcmp(lower(prop),'callback'),
        	callbackstr = ['figure(get(gcf,''UserData''));' val];
        else
            error(['armadsgn: Invalid property "' prop '" specified.']);
        end;
    end;
end;

% -----------------------------------------------------------------------------
spcolors;
global SPC_WINDOW SPC_TEXT_FORE SPC_TEXT_BACK

% local constants
nbrcols = 5; nbrrows = 9;
b_hite = 22; 	b_int = 10;  b_frame = 6;
b_end = 10;	b_width = 100;
columns = (0:nbrcols-1) .* (b_width + 2*b_int) + b_end;
rows = (0:nbrrows-1) .* (b_hite + b_int) + b_end;
w_hite = 2*b_end + rows(nbrrows) + b_hite;
w_width = 2*b_end + columns(nbrcols) + b_width;
w_left = 30;
w_bottom = 50;
pos = [w_left w_bottom w_width w_hite];

mb = 6;
arb = mb-1;
mab = mb;
vb = 6;
db = 2;
cb = 3;
ob = 2;

gf = figure('Units','pixels','Position',pos,'color',SPC_WINDOW,...
        'Name','AR/MA/ARMA Model Tool by D.W. Brown',...
        'NumberTitle','off','BackingStore','on',...
	'Resize','off','UserData',pf);

% following line is bug workaround for version 4.1 and below
set(gf,'BackingStore','off','BackingStore','on');

global SPC_COOL_WINDOW
if SPC_COOL_WINDOW,
	SPC_TEXT_FORE = 'black';
	drawnow
	map = [linspace(0,.5,64)' zeros(64,1) linspace(0,1,64)'];
	pic = [1:64]';
	colormap(hot)
	image( pic )
	set( gca,'pos',[0 0 1 1], 'visible','off')
	drawnow;
end;

set(gf,'NextPlot','new');

% turn off PC menu
if strcmp(computer,'PCWIN'),
	set(gf,'MenuBar','none');
end;

% ---------------------- MODELS ---------------------------------

items = str2mat('AR','MA','ARMA');
radiogrp(gf,'Model',items,1,[columns(1) rows(mb)],...
	[b_width b_hite b_frame b_int],...
	'Units','pixels');

% ---------------------- AR METHODS -------------------------------

items = str2mat('Correlation','Covariance','Mod Covar','Burg');
radiogrp(gf,'AR Methods',items,1,[columns(2) rows(arb)],...
	[b_width b_hite b_frame b_int],...
	'Units','pixels');

% ---------------------- MA METHODS -------------------------------

items = str2mat('Prony','Shank','Durbin');
radiogrp(gf,'MA Methods',items,1,[columns(3) rows(mab)],...
	[b_width b_hite b_frame b_int],...
	'Units','pixels');

% -------------------------------------------------------------------------
hh = uicontrol(gf,'Style','frame','Units','pixels',...
	'Position',[columns(2)-b_frame rows(ob)-b_frame ...
		2*b_width+2*b_frame+2*b_int 2*b_hite+1*b_int+2*b_frame]);

% get the frame's color so we can set our text background the same
bcolor = get(hh,'BackGroundColor');

% if on a PC, set a special color for edit boxes so that they are
% visible. otherwise, make same as frame cause that looks better on
% Sun workstation ***Mathworks!***
if strcmp(computer,'PCWIN'),
	beditcolor = [1 1 1] * 0.7;
else,
	beditcolor = bcolor;
end;

popunbrs(gf,[columns(2) rows(ob) b_width b_hite],...
	[1 2 3 4 6 8 10 12 14],'AR Order','Units','pixels',...
	'LabelPosition',[columns(2) rows(ob+1) b_width b_hite],...
	'BackGroundColor',bcolor,'ForeGroundColor','black',...
	'Range',[1 500],'Integer','on');
set(findpopu(gf,'AR Order'),'Value',2);			% default 2nd order

popunbrs(gf,[columns(3) rows(ob) b_width b_hite],...
	[1 2 3 4 6 8 10 12 14],'MA Order','Units','pixels',...
	'LabelPosition',[columns(3) rows(ob+1) b_width b_hite],...
	'BackGroundColor',bcolor,'ForeGroundColor','black',...
	'Range',[1 500],'Integer','on');
set(findpopu(gf,'MA Order'),'Value',2);			% default 2nd order

% -------------------------------------------------------------------------

if strcmp(minph,'on'),

	% draw minimum phase desired checkbox
	uicontrol(gf,'Style','check',...
		'Units','pixels',...
		'Horiz','center',...
		'BackGroundColor',beditcolor,...
		'Position',[columns(1) rows(1) b_width b_hite],...
		'String','Min Phase',...
		'Value',0);
end;

% -------------------------------------------------------------------------

playcall = [...
	'dog_v = get(findpopu(gcf,''play''),''Value'');'...
	'if dog_v == 1,'...
		'dog_s = get(findpush(gcf,''Apply''),''UserData'');'...
		'sound(dog_s);'...
	'elseif dog_v == 2,'...
		'dog_s = get(finduitx(gcf,''Coefficients''),''UserData'');'...
		'sound(dog_s);'...
	'elseif dog_v == 3,'...
		'dog_s = get(finduitx(gcf,''Model Signal''),''UserData'');'...
		'sound(dog_s);'...
	'elseif dog_v == 4,'...
		'dog_s = get(finduitx(gcf,''Error Signal''),''UserData'');'...
		'sound(dog_s);'...
	'end;'...
	'clear dog_v dog_s'...
];

uicontrol(gf,'Style','frame','Units','pixels',...
	'Visible',play,...
	'Position',[columns(1)-b_frame rows(2)-b_frame ...
			b_width+2*b_frame 2*b_hite+1*b_int+2*b_frame]);

% print variable labels
uicontrol(gf,'Style','text',...
	'Units','pixels',...
	'Horiz','center',...
	'Visible',play,...
	'Position',[columns(1) rows(3) b_width b_hite],...
	'String','Play');

% draw minimum phase desired checkbox
uicontrol(gf,'Style','popup',...
	'Units','pixels',...
	'Horiz','center',...
	'Visible',play,...
	'Position',[columns(1) rows(2) b_width b_hite],...
	'BackGroundColor',beditcolor,...
	'ForeGroundColor','black',...
	'String','Original|Desired|Model|Error',...
	'Value',0,...
	'CallBack',playcall,...
	'UserData','play',...
	'Enable','off');

% -------------------------------------------------------------------------

uicontrol(gf,'Style','frame',...
	'Units','pixels',...
	'Position',[columns(4)-b_frame rows(vb)-b_frame ...
		2*b_width+2*b_frame+2*b_int 4*b_hite+3*b_int+2*b_frame]);

% print variable labels
uicontrol(gf,'Style','text',...
	'Units','pixels',...
	'Horiz','center',...
	'Position',[columns(4) rows(vb+3) 2*b_width+b_int b_hite],...
	'String','Variable Save Names');

% print variable labels
uicontrol(gf,'Style','text',...
	'Units','pixels',...
	'Horiz','center',...
	'Position',[columns(4) rows(vb+2) b_width b_hite],...
	'String','Coefficients');

% print variable labels
uicontrol(gf,'Style','text',...
	'Units','pixels',...
	'Horiz','center',...
	'Position',[columns(4) rows(vb+1) b_width b_hite],...
	'String','Model Signal');

% print variable labels
uicontrol(gf,'Style','text',...
	'Units','pixels',...
	'Horiz','center',...
	'Position',[columns(4) rows(vb) b_width b_hite],...
	'String','Error Signal');

%  variable names
uicontrol(gf,'Style','edit',...
	'Units','pixels',...
	'Horiz','center',...
	'Position',[columns(5) rows(vb+2) b_width b_hite],...
	'Foreground','black',...
	'Background',beditcolor,...
	'UserData','coef',...
	'CallBack', ...
		['dog_x = get(findedit(gcf,''coef''),''String''); '...
		'if ~isempty(dog_x),'...
		'  set(findedit(gcf,''modsig''),''String'',dog_x); '...
		'  set(findedit(gcf,''errsig''),''String'',dog_x); ' ...
		'end;'...
		'clear dog_x;']);

%  variable names
uicontrol(gf,'Style','edit',...
	'Units','pixels',...
	'Horiz','center',...
	'Position',[columns(5) rows(vb+1) b_width b_hite],...
	'Foreground','black',...
	'Background',beditcolor,...
	'UserData','modsig');

%  variable names
uicontrol(gf,'Style','edit',...
	'Units','pixels',...
	'Horiz','center',...
	'Position',[columns(5) rows(vb) b_width b_hite],...
	'Foreground','black',...
	'Background',beditcolor,...
	'UserData','errsig');

applycall = [...
	'dog_y = get(findpush(gcf,''Apply''),''UserData'');'...
	'eval(''[dog_b,dog_a,dog_m,dog_e,dog_d,dog_g] = ' ...
		'armagen(gcf,get(gcf,''''UserData''''));'');'...
	'set(finduitx(gcf,''Coefficients''),''UserData'',dog_d(:));'...
	'set(finduitx(gcf,''Model Signal''),''UserData'',dog_m(:));'...
	'set(finduitx(gcf,''Error Signal''),''UserData'',dog_e(:));'...
	'set(findpopu(gcf,''play''),''Enable'',''on'');'...
	'clear dog_y;'...
	];


% save varibles if names present callback
savecall = [...
	'dog_name = get(findedit(gcf,''coef''),''String'');'...
	'if ~isempty(dog_name),'...
		'eval([dog_name ''_a = dog_a;'']);'...
		'eval([dog_name ''_b = dog_b;'']);'...
		'if length(dog_g) ~= 1,'...
			'eval([dog_name ''_g = dog_g;'']);'...
		'end;'...
	'end;'...
	'dog_name = get(findedit(gcf,''modsig''),''String'');'...
	'if ~isempty(dog_name),'...
		'eval([dog_name ''_m = dog_m;'']);'...
	'end;'...
	'dog_name = get(findedit(gcf,''errsig''),''String'');, '...
	'if ~isempty(dog_name), '...
		'eval([dog_name ''_e = dog_e;'']); '...
	'end;'...
	];
end;

uicontrol(gf,'Style','push',...
	'String','Apply',...
	'UserData',pf,...
	'Position',[columns(5) rows(1) b_width b_hite],...
	'UserData',signal,...
	'CallBack',['dog_gf = gcf;' applycall savecall callbackstr ...
		'clear dog_name dog_a dog_b dog_m dog_e dog_d dog_g;' ...
	'if strcmp(get(findchkb(dog_gf,''Verbose''),''UserData''),''on''),'...
		'close(dog_gf); clear dog_gf; return; end; clear dog_gf'...
	]);

% draw verbose checkbox
uicontrol(gf,'Style','check',...
	'Units','pixels',...
	'Horiz','center',...
	'BackGroundColor',beditcolor,...
	'ForeGroundColor','black',...
	'Position',[columns(4) rows(1) b_width b_hite],...
	'String','Verbose',...
	'Value',verbose,...
	'UserData',closeonapply);

% -------------------------------------------------------------------------

if strcmp(drive,'on'),

	items = str2mat('Impulse','GWN');
	radiogrp(gf,'Driving Source',items,1,[columns(4) rows(db)],...
		[b_width b_hite b_frame b_int],'Units','pixels');

end;

% -------------------------------------------------------------------------

if strcmp(chain,'on'),

	uicontrol(gf,'Style','frame','Units','pixels',...
		'Position',[columns(5)-b_frame rows(cb)-b_frame ...
		b_width+2*b_frame 2*b_hite+1*b_int+2*b_frame]);

	% draw chain checkbox
	uicontrol(gf,'Style','check',...
		'Units','pixels',...
		'Horiz','center',...
		'BackGroundColor',beditcolor,...
		'ForeGroundColor','black',...
		'Position',[columns(5) rows(cb+1) b_width b_hite],...
		'String','Chain','Value',0);

	% draw chain length popupmenu
	popunbrs(gf,[columns(5) rows(cb) b_width b_hite],...
		[10 20 30 40 60 80 100],'chain','Units','pixels',...
		'BackGroundColor',bcolor,'ForeGroundColor','black',...
		'Label','off',...
		'Range',[1 500],'Integer','off');
	set(findpopu(gf,'chain'),'Value',2);		% default 2nd order

end;

if ~isempty(pf)

	gff = gf;

else,

	set(findedit(gf,'coef'),'String','temp');
	set(findedit(gf,'modsig'),'String','temp');
	set(findedit(gf,'errsig'),'String','temp');

end;
