/* 
 * Copyright (C) 1993 Mark Boyns (boyns@sdsu.edu)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "conf.h"
#include <sys/types.h>
#include <sys/param.h>
#include <stdio.h>
#include <string.h>
#include "hash.h"
#include "search.h"
#include "rplayd.h"

#ifdef __STDC__
void	hash_init(int hash_table_size)
#else
void	hash_init(hash_table_size)
int	hash_table_size;
#endif
{
	if (hcreate(hash_table_size) == 0)
	{
		report("cannot create hash table\n");
		done(1);
	}
}

#ifdef __STDC__
char	*hash_get(char *hash_key)
#else
char	*hash_get(hash_key)
char	*hash_key;
#endif
{
	ENTRY	e, *ep;

	e.key = hash_key;
	ep = hsearch(e, FIND);

	return ep ? (char *)ep->data : NULL;
}

#ifdef __STDC__
void	hash_put(char *hash_key, char *data)
#else
void	hash_put(hash_key, data)
char	*hash_key;
char	*data;
#endif
{
	ENTRY	e;

	e.key = hash_key;
	e.data = data;

	if (hsearch(e, ENTER) == NULL)
	{
		report("hash_put: the hash table is full\n");
		done(1);
	}
}

#ifdef __STDC__
void	hash_delete(char *hash_key)
#else
void	hash_delete(hash_key)
char	*hash_key;
#endif
{
	ENTRY	e;
	
	e.key = hash_key;

	if (hsearch(e, DELETE) == NULL)
	{
		report("hash_delete: %s not in the hash table\n", hash_key);
		done(1);
	}
}

/*
 * create a hash key name for the given sound
 */
#ifdef __STDC__
char	*hash_name(char *pathname)
#else
char	*hash_name(pathname)
char	*pathname;
#endif
{
	static char	name[MAXPATHLEN];
	char		*extension;

	if (pathname[0] == '/')
	{
		pathname = strrchr(pathname, '/') + 1;
	}

	strcpy(name, pathname);
	extension = strrchr(name, '.');
	if (extension)
	{
		*extension = '\0';
	}

	return name;
}
