
/* 
 * Copyright (C) 1993 Mark Boyns (boyns@sdsu.edu)
 *
 * This file is part of rplay.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "conf.h"
#include "version.h"
#include <stdio.h>
#include <string.h>
#include "rplay.h"

#ifdef __STDC__
main(int argc, char **argv)
#else
main(argc, argv)
int	argc;
char	**argv;
#endif
{
	int		rplay_fd, c, command, volume, val;
	int		list_count, count, priority, do_random;
	char		*hosts = NULL, *p, *q;
	RPLAY		*rp;  
	extern char	*optarg; 
	extern int	optind;

	if (argc < 2)
	{
		usage();
	}

	command = RPLAY_PLAY;
	volume = RPLAY_DEFAULT_VOLUME;
	count = RPLAY_DEFAULT_COUNT;
	list_count = RPLAY_DEFAULT_LIST_COUNT;
	priority = RPLAY_DEFAULT_PRIORITY;
	do_random = 0;

	while ((c = getopt(argc, argv, "P:N:n:v:spch:r")) != -1)
	{
		switch (c)
		{
		case 'v':
			volume = atoi(optarg);
			break;

		case 'n':
			count = atoi(optarg);
			break;

		case 'N':
			list_count = atoi(optarg);
			break;

		case 'P':
			priority = atoi(optarg);
			break;

		case 's':   
			command = RPLAY_STOP;
			break;

		case 'p': 
			command = RPLAY_PAUSE;
			break;

		case 'c':  
			command = RPLAY_CONTINUE;
			break;
		
		case 'r':   
			do_random++;
			break;

		case 'h':
			hosts = optarg;
			break;

		case '?':
			usage();
		} 
	}
		     
	if (argc == optind)
	{
		usage();
	}

	if (hosts == NULL)
	{
		hosts = rplay_default_host();
	}

	rp = rplay_create(command);
	if (rp == NULL)
	{
		rplay_perror("rplay_create");
		exit(1);
	}
	  
	if (rplay_set(rp, RPLAY_LIST_COUNT, list_count, NULL) < 0)
	{
		rplay_perror("rplay_set");
		exit(1);
	}

	if (rplay_set(rp, RPLAY_PRIORITY, priority, NULL) < 0)
	{
		rplay_perror("rplay_set");
		exit(1);
	}

	while (argv[optind] != NULL)
	{
		val = rplay_set(rp, RPLAY_APPEND,
			RPLAY_SOUND,	argv[optind++],
			RPLAY_VOLUME,	volume,
			RPLAY_COUNT,	count,
			NULL);
		if (val < 0)
		{
			rplay_perror("rplay_set");
			exit(1);
		}
	}

	if (do_random)
	{
		val = rplay_set(rp, RPLAY_RANDOM_SOUND, NULL);
		if (val < 0)
		{
			rplay_perror("rplay_set");
			exit(1);
		}
	}

	q = hosts;
	do
	{
		p = q;
		q = strchr(p, ':');
		if (q != NULL)
		{
			*q++ = '\0';
		}
		rplay_fd = rplay_open(p);
		if (rplay_fd < 0)
		{
			rplay_perror(p);
			exit(1);
		}
		if (rplay(rplay_fd, rp) < 0)
		{
			rplay_perror(p);
			exit(1);
		}
		rplay_close(rplay_fd);
	}
	while (q != NULL);

	exit(0);
}

usage()
{
	printf("\n%s\n\n", rplay_version);
	printf("usage: rplay [options] sound ...\n");
	printf("\t-c      Continue.\n");
	printf("\t-h host Specify the rplay host, default = %s.\n", rplay_default_host());
	printf("\t-n n    Number of times to play each sound, default = %d.\n",
		RPLAY_DEFAULT_COUNT); 
	printf("\t-N n    Number of times to play the sound list, default = %d.\n",
		RPLAY_DEFAULT_LIST_COUNT);
	printf("\t-P n    Sound priority n (%d <= n <= %d), default = %d.\n",
		RPLAY_MIN_PRIORITY,
		RPLAY_MAX_PRIORITY,
		RPLAY_DEFAULT_PRIORITY);
	printf("\t-p      Pause.\n");
	printf("\t-r      Randomly choose one of the given sounds.\n");
	printf("\t-s      Stop.\n");
	printf("\t-v n    Volume n (%d <= n <= %d), default = %d.\n",
		RPLAY_MIN_VOLUME,
		RPLAY_MAX_VOLUME,
		RPLAY_DEFAULT_VOLUME);
	printf("\n");
	exit(1);
}
