static char SccsID[] = "@(#)detrend.c	1.4   7/17/91";
/*
  Copyright (C) 1994 Edmund Lai.
     
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*	DETREND.C
 *
 *	Convert a sample sequence into a zero mean sequence.
 *
 *	Edmund Lai
 *	Department of Electrical & Electronic Engineering
 *	The University of Western Australia
 *
 *---------------------------------------------------------------
 *
 *	void detrend (int,int *,double *);
 *
 *	n	: sample sequence length.
 *	s	: sample sequence.
 *	xx	: the resulting zero mean sequence (suitable for
 *		  windowing).
 *
 *----------------------------------------------------------------*/


void detrend_short (n,s,xx)
int	n;
short	s[];
double	xx[];
{
	int	i;
	double	sum,average;

	sum = 0.0;
	for (i = 0; i < n; i++)  sum += (double) s[i];
	average = sum / (double)n;
	for (i = 0; i < n; i++)  xx[i] = (double) s[i] - average;
}

void detrend_char (n,c,xx)
int	n;
signed char	c[];
double	xx[];
{
	int	i;
	double	sum,average;

	sum = 0.0;
	for (i = 0; i < n; i++)  sum += (double) c[i];
	average = sum / (double)n;
	for (i = 0; i < n; i++)  xx[i] = (double) c[i] - average;
}
