static char SccsID[] = "@(#)detrend.c	1.4   7/17/91";

/*	DETREND.C
 *
 *	Convert a sample sequence into a zero mean sequence.
 *
 *	Edmund Lai
 *	Department of Electrical & Electronic Engineering
 *	The University of Western Australia
 *
 *---------------------------------------------------------------
 *
 *	void detrend (int,int *,double *);
 *
 *	n	: sample sequence length.
 *	s	: sample sequence.
 *	xx	: the resulting zero mean sequence (suitable for
 *		  windowing).
 *
 *----------------------------------------------------------------*/


void detrend_short (n,s,xx)
int	n;
short	s[];
double	xx[];
{
	int	i;
	double	sum,average;

	sum = 0.0;
	for (i = 0; i < n; i++)  sum += (double) s[i];
	average = sum / (double)n;
	for (i = 0; i < n; i++)  xx[i] = (double) s[i] - average;
}

void detrend_char (n,c,xx)
int	n;
signed char	c[];
double	xx[];
{
	int	i;
	double	sum,average;

	sum = 0.0;
	for (i = 0; i < n; i++)  sum += (double) c[i];
	average = sum / (double)n;
	for (i = 0; i < n; i++)  xx[i] = (double) c[i] - average;
}
