/*
  title: fview_io.h
  purpose: Standard header record for interface to the fview program.
  
  author: Gareth Lee.
  date:   21-10-93

  changes:
*/

/* Magic numbers to verify compliance to correct formats */
#define FVIEW_SAMPLE_MAGIC  "fview1sh"
#define FVIEW_FEATURE_MAGIC "fview1fh"

/*
  FviewSampleHeader: a 128 byte Header record that all fview format converters
    must generate as output.
*/
typedef struct {

  char     magic[8];                                         /* magic number */
  unsigned number_samples;      /* number of 16 bit two's compliment samples */
  unsigned sample_freq;                            /* sample frequency in Hz */
  unsigned info_size;     /* size of additional information on the utterance */

} FviewSampleHeader;

/* FviewFeatureHeader: a 128 byte Header record that all fview filters must
     generate as output.
*/
typedef struct {
  
  char     magic[8];                                         /* magic number */
  unsigned vector_dimension;     /* num elements forming each feature vector */
  unsigned number_observations;      /* num feature vectors in the utterance */
  unsigned info_size;     /* size of additional information on the utterance */
  
} FviewFeatureHeader;

