/*
  title:     entropy_seg.h
  purpose:   Locate observations within sequence associated with high
             predictive entropy.

  author:    Gareth Lee.
  date:      04-07-93
  modified:  05-07-93

  changes:
*/

#define free_vector(v) free(v)

/* prototypes */
void linear_predict(int frames, int dims, double** obs, double** error);
void mean_covar(int frames, int dims, double** error, double* mean, double** covar);
void invert(int dims, double** m, double** I);
double mahalanobis(int dims, double* vector, double* mean, double** icovar);
double** make_matrix(int r, int c);
void free_matrix(int r, double** p);
double* make_vector(int r);
int find_segmentation(int frames, int dims, double** obs, int* order,
                      int direction, int ratio);
int find_diff_segmentation(int frames, int dims, double** obs, int* order,
                           int direction, int ratio);
int find_diff2_segmentation(int frames, int dims, double** obs, int* order,
                            int direction, int ratio);

/* end of entropy_seg.h */
