#include "nodes.h"

/*			UNI_NODE_

    The constructor sets the initial value of G to 0.

*/

UNI_NODE_::UNI_NODE_()
{
    g = 0;
}



/*			GET_G

    Returns node's G-value.

*/

int UNI_NODE_::get_g() const
{
    return(g);
}


/*			SET_G

    Sets node's G-value.

*/

void UNI_NODE_::set_g(int val)
{
    g = val;
}



/*			EVAL

    This function determines the order of two nodes based on their
    g-values. If node A has a lower g-value than node B this means
    that node A ranks before node B (nodes are stored in order of
    ascending g-values because we are looking for the cheapest path,
    i.e, the node with the lowest g-value so far).

*/

int UNI_NODE_::eval(const SVOBJECT_ &other) const
{
    return(g - ((UNI_NODE_ &)other).get_g());
}
