/* Learning program. */
#include "insectdraw.h"
#include <stdlib.h>
#include <math.h>
/*#include <floatingpoint.h>*/
#include <sys/time.h>

/* Functions to do random numbers. */
#define RAN_DOUBLE(l, h)	(((double) random()/0x80000000U)*((h) - (l)) + (l))
#define RAN_INT(l, h)		((int) (RAN_DOUBLE(0, (h)-(l)+1) + (l)))
#define SEED    1   /* If not defined, will use 1 as the seed */

long random();
void randomize()
{
	struct timeval t;
	struct timezone tz;

	gettimeofday(&t, &tz);
	srandom(t.tv_usec);
}

#define LAST_TURNS 3
#define NOOFWALLS 22

int total_dist = 0, prop_total_dist = 0;
int turn_seq[100],prop_turn_seq[100];
int last_turn = 0,last_prop_turn = 0;
int no_of_turns = 0;
int trial = 0;

/* Redefining deltatheta. */
#define deltatheta 12
/*#define deltax 4
#define deltaz 4*/

FILE *fplog; /* Log file. */
FILE *fprec; /* File with a recorded sequence. */

int PLAYBACK;
int RECORD;

main(argc,argv)
int argc;
char *argv[];
{
    short val;
    double dx,dz;
    int i,m = 0;

    /* Implant random seed */
    randomize();

    /* Open log file. */
    fplog = fopen("insect.log","w");
    Check_Args(argc,argv);

    /* Set up graphics environment. */
    GSettings();
 
    /* Set up control keys. */
    set_control();

    /* Initialize robot coordinates. */
    Init_Robot();

    /* Set(load) up the maze. */
    Load_Maze(argv[1]);

    /* Initial drawing. */
    Initial_Draw();

    printf("\nBegining trial %d\n",trial);
    fprintf(fplog,"Begining trial %d\n",trial);
    while( (moving == 1) || (rotating == 1) ||
           ((dev = qread(&val))&&(dev != QKEY))) {

       /* Reset. */
       if (dev == CKEY) {
           Init_Robot();
           Initial_Draw();
           trial++;
           printf("Begining trial %d\n",trial);
           fprintf(fplog,"Begining trial %d\n",trial);
           moving = 1;rotating = 0; begin_rotation = 0;
           dev = GKEY;
           continue;
       }

       /* Position the robot. */
       Move_Position_rob();

       m++;
       /* Update the viewing points and draw. */
       Update_View_Draw(&m);

      qreset();

    } /* end while */
    gexit();
}

Check_Args(argc,argv)
int argc;
char *argv[];
{
  char temp[30];

  PLAYBACK = 0; RECORD = 0;    

  if (argc == 2) return(1);
  if (argc == 3) {
      strcpy(temp,argv[2]);
      if (!strcmp(temp,"play")) {
          PLAYBACK = 1;
          if ((fprec = fopen("insect.rec","r")) == NULL) {
              printf("No recorded file.\n");
              exit(1);
          }

      }
      else if (!strcmp(temp,"record"))
               RECORD = 1;
  }
  printf("Program in %s mode.\n",temp);
}

Move_Position_rob()
{
   double dx = 0,dy = 0,dz = 0;
   int i,j;
   static double theta;

   switch(dev) {
     case GKEY:
          rotating = 0;
          if (legmoving)
              Move_legs_forward();
          else {
              if (movebody) {
                  Move_body_forward();
                  movebody = 0;
                  prop_total_dist++;
              } 
              else {
                 Device devs[1] = SKEY;
                 short vals[1];

                 Move_middle_forward();
                 legmoving = 1;
                 getdev((long)1,devs,vals);
                 if (vals[0] == 1) {
                     moving = 0;
                     if (RECORD) {
                         /* Record the last sequence in a file. */
                         Record_Seq();
                     }
		 }
                 else
                    if (Too_Close()) {
                       moving = 0;begin_rotation = 1;
                       rotating = 1;
                       if (PLAYBACK) {
                           static int p = 0;

                           if (p == 0)
                               Load_Rec_Seq();

                           no_of_turns = Translate_Turn(turn_seq[p]);
                           printf("%d%s ",no_of_turns,
                                       ( dev == LKEY ? "L" : "R"));
                           p++;
                           if (p > last_turn) {
                               PLAYBACK = 0;moving = 0; rotating = 0;
                               dev = SKEY;
			   }
                       } 
                       else {
                          no_of_turns = 
                              Translate_Turn(Guess_No_Turns());
                          printf("%d%s ",no_of_turns,
                                      ( dev == LKEY ? "L" : "R"));
                          fprintf(fplog,"%d%s ",no_of_turns,
                                      ( dev == LKEY ? "L" : "R"));
                          fflush(stdout);fflush(fplog);
		       }
                    }
              }
	  }
          break;
     case LKEY:
     case RKEY:
          if (!rotating || begin_rotation) {
              begin_rotation = 0;
              /* Get the original coordinates. */
              for(i = 0; i < 8; i++)
                  obody[i] = body[i];
              TCamLookfrom = CamLookfrom;
              TCamLookat = CamLookat;
              Teye_center = eye_center;
              theta = 0;

              for(j = 0; j < NUMBEROFLEGS; j++)
                  for(i = 0; i < 8; i++) {
                    oupper_leg[j][i]=upper_leg[j][i];
                    olower_leg[j][i]=lower_leg[j][i];
                  }

              /* Calculate center of rotation. */
              get_center();

              rotating = 1;  
	  }
          if (dev == RKEY) {
             dtheta += deltatheta;
             theta += deltatheta;
          }
          else {
             dtheta -= deltatheta;
             theta -= deltatheta;
	  }

          rotate_robot(theta*M_PI/180.0,xc,zc);
          /* Rotate robot the appropriate "guessed"
             amount.*/
          if (no_of_turns == 0)
             Recheck_Distance();
          else {
             moving = 0;
             no_of_turns--;
          }
          break;
     }
}

Record_Seq()
{
   int i;

   if ((fprec = fopen("insect.rec","w")) == NULL) {
      printf("Couldn't open file to record sequence.\n");
      gexit();
   }
   for(i = 0; i < last_turn + 1; i++) {
       fprintf(fprec,"%d ",turn_seq[i]);
   }
   fclose(fprec);
}

Load_Rec_Seq()
{
   int i = 0;
   char temp[10];

   while(!feof(fprec)) {
      fscanf(fprec,"%s",temp);
      turn_seq[i] = atoi(temp);
      i++;
   }
   last_turn = i - 1;

   fclose(fprec);
}

char *Print_Turn(t)
int t;
{
   static char trn[6];
   int i,d;

   d = (t <= 5 ? LKEY : RKEY);
   for(i = 0; i < 5; i++) trn[i] = ' ';trn[i] = '\0';

   switch(t) {
   case 5:
   case 6: sprintf(trn,"%d%s",1,( d == LKEY ? "L" : "R"));
           return(trn);
   case 4:
   case 7: sprintf(trn,"%d%s",2,( d == LKEY ? "L" : "R"));
           return(trn);
   case 3:
   case 8: sprintf(trn,"%d%s",3,( d == LKEY ? "L" : "R"));
           return(trn);
   case 2:
   case 9: sprintf(trn,"%d%s",4,( d == LKEY ? "L" : "R"));
           return(trn);
   case 1:
   case 10:
           sprintf(trn,"%d%s",5,( d == LKEY ? "L" : "R"));
           return(trn);
   }
   printf("Print_Turn: Couldn't translate turn %d.\n",t);
   fprintf(fplog,"Print_Turn: Couldn't translate turn %d.\n",t);
   gexit();
}


Recheck_Distance()
{
   int i;

   rotating = 0;
   moving = 1;

   if (Too_Close()) { /* Still too close. */
      dev = CKEY;

      printf("Trial failed.\n");
      fprintf(fplog,"Trial failed.\n");
      printf("Current best path distance: %d\n",total_dist);
      fprintf(fplog,"Current best path distance: %d\n",total_dist);
      for(i = 0; i < last_turn + 1; i++) {
          printf("%s ",
            (((i == 0) && (turn_seq[i] == 0)) ? "0" :Print_Turn(turn_seq[i])));
          fprintf(fplog,"%s ",
            (((i == 0) && (turn_seq[i] == 0)) ? "0" :Print_Turn(turn_seq[i])));
      }

      printf("\nProposed path distance: %d\n",prop_total_dist);
      fprintf(fplog,"\nProposed path distance: %d\n",prop_total_dist);

      for(i = 0; i < last_prop_turn; i++) {
          printf("%s ",Print_Turn(prop_turn_seq[i]));
          fprintf(fplog,"%s ",Print_Turn(prop_turn_seq[i]));
      }
      printf("\n\n");
      fprintf(fplog,"\n\n");
      fflush(fplog);

      if (Out_of_Maze())
          prop_total_dist = 0;

      sleep(1);

      /* Compare proposed distance with greatest distance so far. */
      if (prop_total_dist > total_dist) {
          /* Make proposed path to be the new path. */
          for(i = 0; i < last_prop_turn; i++)
             turn_seq[i] = prop_turn_seq[i];
          total_dist = prop_total_dist; 
          last_turn = last_prop_turn - 1;
          prop_total_dist = 0;
          last_prop_turn = 0;
      }
      else { /* Start again. */
          for(i = 0; i < last_prop_turn + 1; i++)
              prop_turn_seq[i] = 0;
          last_prop_turn = 0; prop_total_dist = 0;
      }
   }
   else dev = GKEY;
}

Out_of_Maze()
{
   if (CamLookfrom.x < 1.0)
      return(1);
   return(0);
}

Guess_No_Turns()
{
   int prob_turn;

   if ( (total_dist == 0) || (last_turn < LAST_TURNS) ) {
       /* That is, it is too early to copy previous
          behaviors.  Just guess randomly. */
       prop_turn_seq[last_prop_turn] = Random_Guess();
       last_prop_turn++;
       return(prop_turn_seq[last_prop_turn - 1]);
   }

   if (last_turn - LAST_TURNS > last_prop_turn - 1) {
       prop_turn_seq[last_prop_turn] = 
                         turn_seq[last_prop_turn];
       last_prop_turn++;
       return(prop_turn_seq[last_prop_turn - 1]);
   }
   else {
     /* Guess amount of turns based on the LAST_TURNS previous turns.*/
     if (last_prop_turn <= last_turn) {
         prob_turn = turn_seq[last_prop_turn];
         prob_turn = Biased_Guess(prob_turn);
         prop_turn_seq[last_prop_turn] = prob_turn;
         last_prop_turn++;
         return(prob_turn);
     }
     else { /* Here we surpassed the LAST_TURNS turns of the previous
               path.  There is no way to continue exploration without
               guessing. */
          prop_turn_seq[last_prop_turn] = Random_Guess();
          last_prop_turn++;
          return(prop_turn_seq[last_prop_turn - 1]);
     }
   }
}

float Random01()
{
   float no;

   no = (float)RAN_DOUBLE(0.0,1.0);
   return(no);
}

Random_Guess()
{
   float g;
   int gi;

   g = 10.0*Random01();
   gi = nint(g);
   if (gi == 0)
       gi = 1;      /* Verify this assumption. */
   return(gi);
}

nint(t)
float t;
{
   return((int)t);
}


Translate_Turn(t)
int t;
{
   dev = ( t <= 5 ? LKEY : RKEY);

   switch(t) {
   case 5:
   case 6: return(1);
   case 4:
   case 7: return(2);
   case 3:
   case 8: return(3);
   case 2:
   case 9: return(4);
   case 1:
   case 10:
           return(5);
   }
   printf("Error: Couldn't translate turn %d.\n",t);
   gexit();
}

Biased_Guess(turn)
int turn;
{
   float g01;
   int g;
   static int count = 0;
   float ranges[3][4] = { {0.05,0.3,0.7,0.95}, /* Use flattened Gaussians as
                          {0.1,0.4,0.6,0.9},  it approaches the last choice.*/
                          {0.2,0.4,0.6,0.8} };

   /* Guess a turn but give more likelihood of selection
      to a turn close to 'turn'. Here using a Gaussian.*/
   g01 = Random01();

   if (g01 <= ranges[count][0]) g = abs(turn - 2);
   if ( (g01 >= ranges[count][0]) && (g01 <= ranges[count][1]) )
      g = abs(turn - 1);
   if ( (g01 >= ranges[count][1]) && (g01 <= ranges[count][2]) ) g = turn;
   if ( (g01 >= ranges[count][2]) && (g01 < ranges[count][3]) ) g = turn + 1;
   if (g01 >= ranges[count][3]) g = turn + 2;
   if (g == 11) g = 7;
   if (g == 10) g = 8;
   if (g == -1) g = 1;
   if (g == 0) g = 2;
/*
   printf("Previous turn: %s ",Print_Turn(turn));
   printf("New turn: %s\n",Print_Turn(g));
   fprintf(fplog,"Previous turn: %s ",Print_Turn(turn));
   fprintf(fplog,"New turn: %s\n",Print_Turn(g));

   fflush(stdout);fflush(fplog);
*/

   if (count == 2)
       g = Random_Guess();

   count++;
   if (count > 2)
      count = 0;

   return(g);
}


Too_Close()
{
   double x,z;
   int i;

   x = CamLookfrom.x; z = CamLookfrom.z;

   for(i = 0; i < NOOFWALLS; i++)
       if (Inside_BBox(i,x,z))
           return(1);

   return(0);
}

Inside_BBox(box,x,z)
int box;
double x,z;
{
   double xmin,xmax,zmin,zmax;

   struct {
        double xmin,xmax,zmin,zmax;


   } BBox[NOOFWALLS] = { {-2.5,2.5,.3,3},
                         {-2,3,-2,-0.3},
			 {4.3,6,-6,5},
			 {2,6,-6,-3.3},
			 {2,3.7,-6,-2},
			 {1.5,3.7,3,9},
			 {6,13,4,5.7},
			 {1.5,11.5,6.8,9},
			 {11.5,17.5,6.8,9},
			 {12,13,-2,4},
			 {16.5,17.5,-1,9},
			 {12,13,-8,-2},
			 {16.5,17.5,-7,-1},
			 {17.5,21.5,-8,-7},
			 {20.5,21.5,-13,-7},
			 {11.5,21.5,-13,-12},
			 {7.5,11.5,-13,-12},
			 {2,12,-9,-8},
			 {2,3,-18,-8},
			 {4.5,5.5,-17,-13},
			 {2,6,-17,-16},
			 {5.5,9.5,-13,-17}  };

   xmin = BBox[box].xmin; xmax = BBox[box].xmax;
   zmin = BBox[box].zmin; zmax = BBox[box].zmax;


   if ( ((x >= xmin) && (x <= xmax)) &&
        ((z >= zmin) && (z <= zmax)) ) {
/*
      printf("Inside %d BBox returning yes\n",box);
      printf("x %f z %f xmin %f, xmax %f, zmin %f, zmax %f\n",
              x,z,xmin,xmax,zmin,zmax); 
*/
      return(1);

    }
   return(0);
}

