#include "insectm.h"

Update_View_Draw(m)
int *m;
{
  int i;

  for(i = 0; i < 2; i++) {

      winset(W[i]);
      pushmatrix();
      if (!rotating) {

          if (i == 0) {
              Lookfrom.x += incxb/8;
              Lookfrom.z += inczb/8;
              Lookat.x += incxb/8;
              Lookat.z += inczb/8;
              lookat(Lookfrom.x,
                     Lookfrom.y,
                     Lookfrom.z,
                     Lookat.x,
                     Lookat.y,
                     Lookat.z,twist);
          }
          else {
             if (*m == 7) *m = 0;
             lookat(CamLookfrom.x,
                    CamLookfrom.y,
                    CamLookfrom.z,
                    CamLookat.x,
                    CamLookat.y,
                    CamLookat.z,twist);
          }
    }
    else { /* Do the rotation. */
       *m = 0;
        if (i == 0)
           lookat(Lookfrom.x,
                  Lookfrom.y,
                  Lookfrom.z,
                  Lookat.x,
                  Lookat.y,
                  Lookat.z,twist);
        else {
           lookat(CamLookfrom.x,
                  CamLookfrom.y,
                  CamLookfrom.z,
                  CamLookat.x,
                  CamLookat.y,
                  CamLookat.z,twist);
        }
    }
    Draw();
    popmatrix();

  } /* end for */
}

Load_Maze(mazefile)
char *mazefile;
{

   FILE *fp;
   int i = 0;
   char temp[30];
   short R,G,B;

   if ((fp = fopen(mazefile,"r")) == NULL) {
      printf("Couldn't find mazefile: \"%s\".\n",
             mazefile);
      return(1);
   }

   while(!feof(fp)) {
      fscanf(fp,"%s",temp); 
      fscanf(fp,"%s",temp); 
      Maze[i].size = temp[0];
      fscanf(fp,"%s",temp); 
      Maze[i].theta = atof(temp);
      fscanf(fp,"%s",temp); 
      Maze[i].t.x = atof(temp);
      fscanf(fp,"%s",temp); 
      Maze[i].t.y = atof(temp);
      fscanf(fp,"%s",temp); 
      Maze[i].t.z = atof(temp);
      fscanf(fp,"%s",temp);R = (short)atoi(temp);
      fscanf(fp,"%s",temp);G = (short)atoi(temp);
      fscanf(fp,"%s",temp);B = (short)atoi(temp);
      Maze[i].color[0] = R;
      Maze[i].color[1] = G;
      Maze[i].color[2] = B;

/*
      Maze[i].color = R;
      Maze[i].color = (Maze[i].color<<16);
      Maze[i].color = (G<<8);
      Maze[i].color = (B<<16);
*/
  
/*printf("size %c theta %f (%f,%f,%f) color %d\n",
Maze[i].size,Maze[i].theta,Maze[i].t.x,
Maze[i].t.y,Maze[i].t.z,Maze[i].color);*/
      i++;
   }
   NOOFWALLS = i - 1;
}



Draw_Maze()
{
   int i;
   char size;
   double theta;
   double dx,dz;

   for(i = 0; i < NOOFWALLS; i++) {
       size = Maze[i].size;
       theta = Maze[i].theta;
       rgbvec[0] = Maze[i].color[0];
       rgbvec[1] = Maze[i].color[1];
       rgbvec[2] = Maze[i].color[2];
       dx = Maze[i].t.x;
       dz = Maze[i].t.z;
       pushmatrix();
       translate(dx,0,dz);
       rot(theta,'y');
       c3s(rgbvec);
       Draw_Wall(size);
       popmatrix();
   }
}

Draw_Wall(size)
char size;
{
   int i,j;
   vertex w[8];
   double vert[3];

   if (size == 's') {
       for(i = 0; i < 8; i++)
           w[i] = sm[i];
   }
   else if (size == 'm') {
            for(i = 0; i < 8; i++)
                w[i] = med[i];
        }
        else {
            for(i = 0; i < 8; i++)
                w[i] = lar[i];
        }

  for(i = 0; i < 6; i++) {
      /* if (i == 5 || i == 4)
          cpack(RGB_DARKGRAY); */

      bgnpolygon();
      for(j = 0; j < 4;j++) {
          vert[0] = w[face[i][j]].x;
          vert[1] = w[face[i][j]].y;
          vert[2] = w[face[i][j]].z;
          v3d(vert);
      }
      endpolygon();
  }
}


Initial_Draw()
{
  int i;

  for(i = 0; i < 2;i++) {
      winset(W[i]);
      zbuffer(TRUE);
      pushmatrix();
      if (i == 0)
         lookat(Lookfrom.x,Lookfrom.y,Lookfrom.z,
                Lookat.x,Lookat.y,Lookat.z,twist);
      else
         lookat(CamLookfrom.x,
                CamLookfrom.y,
                CamLookfrom.z,
                CamLookat.x,
                CamLookat.y,
                CamLookat.z,twist);
      Draw();
      popmatrix();
  }
}

get_center()
{
   int i;
   double xmin,zmin,xmax,zmax;

   /* Start the rotation. */
   xmin = INF;zmin = INF;
   xmax = -INF;zmax = -INF;

   for(i = 0; i < 8; i++) {
       xmin = MIN(obody[i].x,xmin);
       zmin = MIN(obody[i].z,zmin);
       xmax = MAX(obody[i].x,xmax);
       zmax = MAX(obody[i].z,zmax);
   }

   xc = xmin + (xmax - xmin)/2.0;
   zc = zmin + (zmax - zmin)/2.0;
}


Draw()
{
  rgbvec[0] = 0;rgbvec[1] = 0;rgbvec[2] = 0;
  c3s(rgbvec);  /* RGB_BLACK */
  clear();
  zclear();
  draw_floor();
  Draw_Maze();
  draw_rob();
  swapbuffers();
}

GSettings()
{
   long xsize, ysize;
   float aspect;
   int i;

   if (getgdesc(GD_BITS_NORM_SNG_RED) == 0) {
    fprintf(stderr, "single buffered RGB not available on this machine\n");
	return 1;
    }

    prefsize(900, 400);
    prefposition(500,1400,0,400);
    W[0] = winopen("Maze");
    prefsize(500, 300);
    prefposition(800,1300,600,900);
    W[1] = winopen("Camera view");


    for(i = 0; i < 2; i++) {
        winset(W[i]);
        mmode(MVIEWING);
        getsize(&xsize, &ysize);
        aspect = (float)xsize / (float)ysize;
        perspective(900, aspect, 0.1,20);
        RGBmode();
        doublebuffer();
        gconfig();
        /* backface(TRUE); */
    }
}

Init_View_Points()
{
   Lookfrom = ILookfrom;
   Lookat = ILookat;

   CamLookfrom = ICamLookfrom;
   CamLookat = ICamLookat;

   eye_center = Ieye_center;
}

Init_Robot()
{
   int i,j;
   int angle;

   rotating = 0;moving = 0;legmoving = 1;
   begin_rotation = 0;

   Init_View_Points();

   /* First, initialize increments. */
   incxb = 0; inczb = 0;dtheta = 0;
   for(i = 0; i < NUMBEROFLEGS; i++) {
      incxl[i] = 0.0; incyl[i] = 0.0;      
   }

   /* Set body. */
   for(i = 0; i < 8; i++)
      body[i] = b[i];

   /* Set eye. */
   eye = 1;
   makeobj(eye);
   /* RGB_RED */
   rgbvec[0] = 255;rgbvec[1] = 0;rgbvec[2] = 0;
   c3s(rgbvec);
   for(angle = 0; angle < 3600; angle += 300) {
       rotate(300,'y');
       circf(0.0, 0.0,0.05);
   }
   closeobj();

   /* Here, the legs are numbered 0 thru 7, where 0,1,2 are the
      front,middle and back left legs and 3,4 and 5 are the front,
      middle and back right legs.
   */

   /* Set upper and lower legs. */
   for(j = 0; j < NUMBEROFLEGS; j++)
       for(i = 0; i < 8; i++) {
           if (j < 3) {
               upper_leg[j][i] = ul[i];
               lower_leg[j][i] = ll[i];
           }
           else {
                upper_leg[j][i] = ur[i];
                lower_leg[j][i] = lr[i];
           }
   }

   /* Adjust legs to obtain the middle and back legs. */
   for(j = 0; j < NUMBEROFLEGS; j++)
       for(i = 0; i < 8; i++) {
           switch(j) {
             case 1:
	     case 4:
               upper_leg[j][i].x += -0.6;
               lower_leg[j][i].x += -0.6;
               break;
	     case 2:
             case 5:
               upper_leg[j][i].x += -1.2;
               lower_leg[j][i].x += -1.2;
               break;
           }               
       }
}

/* Draw routines. */

void draw_rob()
{
 pushmatrix();
 translate(eye_center.x,eye_center.y,eye_center.z);
 callobj(eye);
 popmatrix();

 draw_body();
 draw_legs();
}

draw_legs()
{
   int i;

   for(i = 0; i < NUMBEROFLEGS; i++)
       draw_leg(i);
}

draw_leg(l)
int l;
{
  int i,j;
  double vert[3];

  /* Draw upper leg. */
  /* RGB_MYBLUE */
  rgbvec[0] = 80;rgbvec[1] = 120;rgbvec[2] = 180;
  c3s(rgbvec);
  for(i = 0; i < 6; i++) {
      if (i == 5 || i == 4)
          c3s(rgbvec); /* RGB_MYBLUE */

      bgnpolygon();
      for(j = 0; j < 4;j++) {
          vert[0] = upper_leg[l][face[i][j]].x;
          vert[1] = upper_leg[l][face[i][j]].y;
          vert[2] = upper_leg[l][face[i][j]].z;
          v3d(vert);
      }
      endpolygon();
  }
  /* Draw lower leg. */
  /* RGB_MYBLUE */
  rgbvec[0] = 80;rgbvec[1] = 120;rgbvec[2] = 180;
  c3s(rgbvec);
  for(i = 0; i < 6; i++) {
      if (i == 5 || i == 4)
          c3s(rgbvec);

      bgnpolygon();
      for(j = 0; j < 4;j++) {
          vert[0] = lower_leg[l][face[i][j]].x;
          vert[1] = lower_leg[l][face[i][j]].y;
          vert[2] = lower_leg[l][face[i][j]].z;
          v3d(vert);
      }
      endpolygon();
  }
}

draw_body()
{
  int i,j;
  double vert[3];

  /* RGB_GRAY */
  rgbvec[0] = 180;rgbvec[1] = 180;rgbvec[2] = 180;
  c3s(rgbvec);
  for(i = 0; i < 6; i++) {
      if (i == 5 || i == 4) {
         /* RGB_DARKGRAY */
         rgbvec[0] = 120;rgbvec[1] = 120;rgbvec[2] = 120;
         c3s(rgbvec);
      }

      bgnpolygon();
      for(j = 0; j < 4;j++) {
          vert[0] = body[face[i][j]].x;
          vert[1] = body[face[i][j]].y;
          vert[2] = body[face[i][j]].z;
          v3d(vert);
      }
      endpolygon();
  }
}

void draw_floor()
{
   double x,z;
   double p[3];
   int sw = 0;

   for (z = -30; z < 30; z+= 3.0) {
       for (x = -30; x < 27; x+= 3.0) {
           bgnpolygon();
               sw = (sw == 0 ? 1: 0);
               if (sw) {
                   /* RGB_DARKBLUE */
                   rgbvec[0] = 90;rgbvec[1] = 90;
                   rgbvec[2] = 110;
                   c3s(rgbvec);
               }
               else {
                   /*cpack(RGB_LIGHTBLUE);*/
                   rgbvec[0] = 90;rgbvec[1] = 90;
                   rgbvec[2] = 170;
                   c3s(rgbvec);
	       }
               p[0]=x;p[1]=0;p[2]=z;v3d(p);
               p[0]=x+3;p[2]=z;v3d(p);
               p[0]=x+3;p[2]=z-3;v3d(p);
               p[0]=x;p[2]=z-3;v3d(p);
               p[0]=x;p[2]=z;v3d(p);
            endpolygon();
       }
   }
}


Move_legs_forward()
{
   int i;
   double dx,dz;
   double theta;
   static int turn = 0;
   int seq[4] = {0,3,2,5};

   theta = (M_PI/180.0)*dtheta;
   /* Move all legs forward in the 'x' direction. */
   dx = deltax*cos(theta);
   dz = deltaz*sin(theta);
   incxl[0] += deltax;
   for(i = 0; i < 8; i++) {
       if ( (i == 0) || (i == 1) || 
            (i == 4) || (i == 5) ) {
            /*printf("dx = %f, dz = %f, theta = %f\n",
                      dx,dz,dtheta);*/
            upper_leg[seq[turn]][i].x += dx;
            upper_leg[seq[turn]][i].z += dz;
       }
       lower_leg[seq[turn]][i].x += dx;
       lower_leg[seq[turn]][i].z += dz;
   }

   /* Update turn(leg of the turn). */
   turn++;
   if (turn > 3) {
       /* Move_body_forward();*/
       legmoving = 0;movebody = 1;
       turn = 0;
   }

   /* Start moving legs. If the last leg was moved, stop
      and start moving body. */
   moving = 1;
}

Move_middle_forward()
{
   int i,l;
   double dx,dz;
   double theta;

   theta = (M_PI/180.0)*dtheta;
   dx = deltax*cos(theta);
   dz = deltaz*sin(theta);

   /* Also move the middle leg. */
   for(l = 0; l < 2; l++) {
       for(i = 0; i < 8; i++) {
           if ( (i == 0) || (i == 1) || 
                (i == 4) || (i == 5) ) {
                /* printf("leg %d dx = %f, dz = %f, 
                theta = %f\n",3*l + 1,dx,dz,dtheta); */
                upper_leg[3*l + 1][i].x += dx;
                upper_leg[3*l + 1][i].z += dz;
           }
           lower_leg[3*l + 1][i].x += dx;
           lower_leg[3*l + 1][i].z += dz;
      }
   }
}

Move_body_forward()
{
   int i,l;
   double dx,dz;
   double theta;

   theta = (M_PI/180.0)*dtheta;

   /* Move body and upper leg junctions. */
   dx = deltax*cos(theta);
   dz = deltaz*sin(theta);
   incxb = dx;inczb = dz;
   for(i = 0; i < 8; i++) {
       body[i].x += dx;
       body[i].z += dz;
   }
   for(l = 0; l < NUMBEROFLEGS; l++) {          
       for(i = 0; i < 8; i++) {
           if ( (i == 3) || (i == 2) ||
                (i == 6) || (i == 7) ) {
              upper_leg[l][i].x += dx;
              upper_leg[l][i].z += dz;
           }
       }
   }
   /* Update camera. */
   CamLookfrom.x += dx; CamLookfrom.z += dz;
   CamLookat.x += dx; CamLookat.z += dz;
   eye_center.x += dx; eye_center.z += dz;

}


rotate_point(theta,xc,zc,ox,oz,newx,newz)
double theta,xc,zc,ox,oz,*newx,*newz;
{

  *newx = (ox - xc)*cos(theta) -
          (oz - zc)*sin(theta) + xc;
  *newz = (ox - xc)*sin(theta) + 
          (oz - zc)*cos(theta) + zc;
}

rotate_robot(theta,xc,zc)
double theta;
double xc,zc;
{
   int i,j;

   /* Rotate body. */
   for(i = 0; i < 8; i++)
       rotate_point(theta,xc,zc,obody[i].x,obody[i].z,
                    &body[i].x,&body[i].z);

   /* Rotate camera and lookat. */
  rotate_point(theta,xc,zc,TCamLookfrom.x,TCamLookfrom.z,
               &CamLookfrom.x,&CamLookfrom.z);
  rotate_point(theta,xc,zc,TCamLookat.x,TCamLookat.z,
               &CamLookat.x,&CamLookat.z);

  /* Rotate the eyes. */
  rotate_point(theta,xc,zc,Teye_center.x,Teye_center.z,
               &eye_center.x,&eye_center.z);


   
   /* Rotate legs. */
   for(j = 0; j < NUMBEROFLEGS; j++)
       for(i = 0; i < 8; i++) {
           upper_leg[j][i].x = 
             (oupper_leg[j][i].x - xc)*cos(theta) -
             (oupper_leg[j][i].z - zc)*sin(theta);
           upper_leg[j][i].z = 
             (oupper_leg[j][i].x - xc)*sin(theta) + 
             (oupper_leg[j][i].z - zc)*cos(theta);

           lower_leg[j][i].x = 
             (olower_leg[j][i].x - xc)*cos(theta) -
             (olower_leg[j][i].z - zc)*sin(theta);
           lower_leg[j][i].z = 
             (olower_leg[j][i].x - xc)*sin(theta) + 
             (olower_leg[j][i].z - zc)*cos(theta);
       }
   /* Translate back. */
   for(j = 0; j < NUMBEROFLEGS; j++)
       for(i = 0; i < 8; i++) {
           upper_leg[j][i].x += xc;
           upper_leg[j][i].z += zc;
           lower_leg[j][i].x += xc;
           lower_leg[j][i].z += zc;
       }
}

set_control()
{
   qdevice(CKEY);
   qdevice(QKEY);
   qdevice(LKEY);
   qdevice(RKEY);
   qdevice(LEFTARROWKEY);
   qdevice(RIGHTARROWKEY);
   qdevice(DOWNARROWKEY);
   qdevice(UPARROWKEY);
   qdevice(GKEY);
   qdevice(BKEY);
}

