#include <stdio.h>
#include <math.h>
#include <gl/gl.h>
#include <gl/device.h>

#define RGB_BLACK   0x000000  
#define RGB_RED	    0x0000ff
#define RGB_MYBLUE  0xccbb88
#define RGB_GREEN   0x00ff00
#define RGB_BLUE    0xff0000
#define RGB_LIGHTBLUE    0xcc5555
#define RGB_DARKBLUE     0x665555
#define RGB_CYAN    0xffff00
#define RGB_GRAY    0xbbbbbb
#define RGB_DARKGRAY    0x999999

#define MIN(a,b) (a < b ? a : b)
#define MAX(a,b) (a > b ? a : b)

#define NUMBEROFLEGS 6

/* Definition of the robot in a given instant. */
double incxl[NUMBEROFLEGS],incyl[NUMBEROFLEGS];
double incxb,inczb;
double dtheta;

/* Motion indicators. */
double legrange;
int forward;
int rotating;
double INF = 9999999999999.0;
double xc,zc;

typedef struct {
           double x;
           double y;
           double z;
	 } vertex;

/* Definition of the actual robot. */
vertex body[8],obody[8];
vertex upper_leg[NUMBEROFLEGS][8];
vertex lower_leg[NUMBEROFLEGS][8];
vertex oupper_leg[NUMBEROFLEGS][8];
vertex olower_leg[NUMBEROFLEGS][8];

/* Definition of the "initial" body */
vertex b[8] = {
  {-1.0,0.7,0.5},
  {-1.0,0.7,0},
  {1.0,0.7,0},
  {1.0,0.7,0.5},
  {-1.0,0.3,0.5},
  {-1.0,0.3,0},
  {1.0,0.3,0},
  {1.0,0.3,0.5} };

/* Definition of the front upper left leg */
vertex ul[8] = {
  {0.55,0.55,-0.9},
  {0.65,0.55,-0.9},
  {0.7,0.6,0},
  {0.5,0.6,0},
  {0.55,0.45,-0.9},
  {0.65,0.45,-0.9},
  {0.7,0.4,0},
  {0.5,0.4,0} };


/* Definition of the front lower left leg */
vertex ll[8] = {
  {0.575,0.0,-0.975},
  {0.625,0,-0.975},
  {0.65,0.55,-1.0},
  {0.55,0.55,-1.0},
  {0.575,0,-0.925},
  {0.625,0,-0.925},
  {0.65,0.55,-0.9},
  {0.55,0.55,-0.9} };

/* Definition of the front upper right leg. */
vertex ur[8] = {
  {0.65,0.55,1.4},
  {0.55,0.55,1.4},
  {0.5,0.6,0.5},
  {0.7,0.6,0.5},
  {0.65,0.45,1.4},
  {0.55,0.45,1.4},
  {0.5,0.4,0.5},
  {0.7,0.4,0.5} };


/* Definition of the front lower right leg. */
vertex lr[8] = {
  {0.625,0.0,1.475},
  {0.575,0,1.475},
  {0.55,0.55,1.5},
  {0.65,0.55,1.5},
  {0.625,0,1.425},
  {0.575,0,1.425},  
  {0.55,0.55,1.4},
  {0.65,0.55,1.4}};

int face[6][4] = {
  {1,2,6,5},
  {5,6,7,4},
  {4,7,3,0},
  {0,3,2,1},
  {0,1,5,4},
  {2,3,7,6} };

/* Definition of the maze walls. Small, medium and 
   large. */

vertex sm[4] = {
   {1.5,0,0},
   {-1.5,0,0},
   {-1.5,1,0},
   {1.5,1,0} };

vertex med[4] = {
   {2.5,0,0},
   {-2.5,0,0},
   {-2.5,1,0},
   {2.5,1,0} };

vertex lar[4] = {
   {3.5,0,0},
   {-3.5,0,0},
   {-3.5,1,0},
   {3.5,1,0} };

/* Definition of the wall and maze structures. */
#define NOOFWALLS 1

struct Wall {
   int size;
   double theta;
   vertex t;
};

struct Wall Maze[NOOFWALLS];
