#include "insect.h"

#define deltax 0.12
#define deltay 0.12
#define deltaz 0.12

/* Here, 2 degrees. */
#define deltatheta 2 

/* Define the viewpoint. */
vertex ILookfrom = {0.0,1.4,-2.0};
vertex ILookat = {0,0,0};
vertex Lookfrom,Lookat;

/* Define the camera viewpoint. */
vertex ICamLookfrom = {1.07,0.5,0.25};
vertex ICamLookat = {2.07,0.5,0.25};
vertex CamLookfrom,CamLookat;
vertex TCamLookfrom,TCamLookat;

double twist = 0;

/* Define the eye(center of eye ball). */
Object eye = 1;
vertex Ieye_center = {1.0,0.5,0.25};
vertex eye_center,Teye_center;

/* Window ids. */
long W[2];

/* Definition of the robot in a given instant. */
double incxl[NUMBEROFLEGS],incyl[NUMBEROFLEGS];
double incxb,inczb;
double dtheta;

/* Motion indicators. */
int rotating;
int moving;
int legmoving;
int movebody;

main()
{
    short val;
    long dev;
    double dx,dz;
    int i,m = 0;

    /* Set up graphics environment. */
    GSettings();
 
    /* Set up control keys. */
    set_control();

    /* Initialize robot coordinates. */
    Init_Robot();

    /* Initial drawing. */
    Initial_Draw();

    while( (moving == 1) ||
           ((dev = qread(&val))&&(dev != QKEY))) {

       /* Reset. */
       if (dev == CKEY) {
           Init_Robot();
           Initial_Draw();
           continue;
       }

       /* Position the robot. */
       Move_Position_rob(dev);

       m++;
       /* Update the viewing points and draw. */
       Update_View_Draw(&m);

       qreset();

    } /* end while */
    gexit();
}

Update_View_Draw(m)
int *m;
{
  int i;

  for(i = 0; i < 2; i++) {

      winset(W[i]);
      pushmatrix();
      if (!rotating) {

          if (i == 0) {
              Lookfrom.x += incxb/8;
              Lookfrom.z += inczb/8;
              Lookat.x += incxb/8;
              Lookat.z += inczb/8;
              lookat(Lookfrom.x,
                     Lookfrom.y,
                     Lookfrom.z,
                     Lookat.x,
                     Lookat.y,
                     Lookat.z,twist);
          }
          else {
             if (*m == 7) *m = 0;
             lookat(CamLookfrom.x,
                    CamLookfrom.y,
                    CamLookfrom.z,
                    CamLookat.x,
                    CamLookat.y,
                    CamLookat.z,twist);
          }
    }
    else { /* Do the rotation. */
       *m = 0;
        if (i == 0)
           lookat(Lookfrom.x,
                  Lookfrom.y,
                  Lookfrom.z,
                  Lookat.x,
                  Lookat.y,
                  Lookat.z,twist);
        else {
           lookat(CamLookfrom.x,
                  CamLookfrom.y,
                  CamLookfrom.z,
                  CamLookat.x,
                  CamLookat.y,
                  CamLookat.z,twist);
        }
    }
    Draw();
    popmatrix();

  } /* end for */
}

Initial_Draw()
{
  int i;

  for(i = 0; i < 2;i++) {
      winset(W[i]);
      zbuffer(TRUE);
      pushmatrix();
      if (i == 0)
         lookat(Lookfrom.x,Lookfrom.y,Lookfrom.z,
                Lookat.x,Lookat.y,Lookat.z,twist);
      else
         lookat(CamLookfrom.x,
                CamLookfrom.y,
                CamLookfrom.z,
                CamLookat.x,
                CamLookat.y,
                CamLookat.z,twist);
      Draw();
      popmatrix();
  }
}

Move_Position_rob(dev)
long dev;
{
   double dx = 0,dy = 0,dz = 0;
   double xmin,zmin,xmax,zmax;
   int i,j;
   static double theta;

   switch(dev) {
     case GKEY:
          if (legmoving)
              Move_legs_forward();
          else {
              if (movebody) {
                  Move_body_forward();
                  movebody = 0;
              } 
              else {
                 Device devs[1] = SKEY;
                 short vals[1];

                 Move_middle_forward();
                 legmoving = 1;
                 getdev((long)1,devs,vals);
                 if (vals[0] == 1)
                     moving = 0;
              }
	  }
          rotating = 0;
          break;
     case BKEY:
          Move_body_forward();
          rotating = 0;
          break;
     case LEFTARROWKEY:
          dx += deltax;
          rotating = 0;
          break;
     case RIGHTARROWKEY:
          dx -= deltax;
          rotating = 0;
          break;
     case UPARROWKEY:
          dz += deltaz;
          rotating = 0;
          break;
     case DOWNARROWKEY:
          dz -= deltaz;
          rotating = 0;
          break;
     case LKEY:
     case RKEY:
          if (!rotating) {
              /* Get the original coordinates. */
              for(i = 0; i < 8; i++)
                  obody[i] = body[i];
              TCamLookfrom = CamLookfrom;
              TCamLookat = CamLookat;
              Teye_center = eye_center;
              theta = 0;

              for(j = 0; j < NUMBEROFLEGS; j++)
                  for(i = 0; i < 8; i++) {
                    oupper_leg[j][i]=upper_leg[j][i];
                    olower_leg[j][i]=lower_leg[j][i];
                  }

              /* Start the rotation. */
              xmin = INF;zmin = INF;
              xmax = -INF;zmax = -INF;

              /* Calculate center of rotation. */
              for(i = 0; i < 8; i++) {
                  xmin = MIN(obody[i].x,xmin);
                  zmin = MIN(obody[i].z,zmin);
                  xmax = MAX(obody[i].x,xmax);
                  zmax = MAX(obody[i].z,zmax);
              }
              xc = xmin + (xmax - xmin)/2.0;
              zc = zmin + (zmax - zmin)/2.0;

              rotating = 1;  
	  }
          if (dev == RKEY) {
             dtheta += deltatheta;
             theta += deltatheta;
          }
          else {
             dtheta -= deltatheta;
             theta -= deltatheta;
	  }

          rotate_robot(theta*M_PI/180.0,xc,zc);

          break;
     }
     if ( (dev == LEFTARROWKEY) ||
          (dev == RIGHTARROWKEY) ||
          (dev == UPARROWKEY) ||
          (dev == DOWNARROWKEY) ) {
         /* Update body and legs. */
         for(i = 0; i < 8; i++) {
             body[i].x += dx;
             body[i].z += dz;
         }
   
         /* Legs. */
         for(j = 0; j < NUMBEROFLEGS; j++)
             for(i = 0; i < 8; i++) {
                 upper_leg[j][i].x += dx;
                 upper_leg[j][i].z += dz;
                 lower_leg[j][i].x += dx;
                 lower_leg[j][i].z += dz;
             }
     }
}


Draw()
{
  cpack(RGB_BLACK);
  clear();
  zclear();
  draw_floor();
  draw_rob();
  swapbuffers();
}

GSettings()
{
   long xsize, ysize;
   float aspect;
   int i;

   if (getgdesc(GD_BITS_NORM_SNG_RED) == 0) {
    fprintf(stderr, "single buffered RGB not available on this machine\n");
	return 1;
    }

    prefsize(900, 400);
    W[0] = winopen("Maze");
    prefsize(500, 300);
    W[1] = winopen("Camera view");

    for(i = 0; i < 2; i++) {
        winset(W[i]);
        mmode(MVIEWING);
        getsize(&xsize, &ysize);
        aspect = (float)xsize / (float)ysize;
        perspective(900, aspect, 0.1,20);
        RGBmode();
        doublebuffer();
        gconfig();
        /* backface(TRUE); */
    }
}

Init_View_Points()
{
   Lookfrom = ILookfrom;
   Lookat = ILookat;

   CamLookfrom = ICamLookfrom;
   CamLookat = ICamLookat;

   eye_center = Ieye_center;
}

Init_Robot()
{
   int i,j;
   int angle;

   rotating = 0;moving = 0;legmoving = 1;

   Init_View_Points();

   /* First, initialize increments. */
   incxb = 0; inczb = 0;dtheta = 0;
   for(i = 0; i < NUMBEROFLEGS; i++) {
      incxl[i] = 0.0; incyl[i] = 0.0;      
   }

   /* Set body. */
   for(i = 0; i < 8; i++)
      body[i] = b[i];

   /* Set eye. */
   eye = 1;
   makeobj(eye);
   cpack(RGB_RED);
   for(angle = 0; angle < 3600; angle += 300) {
       rotate(300,'y');
       circf(0.0, 0.0,0.05);
   }
   closeobj();

   /* Here, the legs are numbered 0 thru 7, where 0,1,2 are the
      front,middle and back left legs and 3,4 and 5 are the front,
      middle and back right legs.
   */

   /* Set upper and lower legs. */
   for(j = 0; j < NUMBEROFLEGS; j++)
       for(i = 0; i < 8; i++) {
           if (j < 3) {
               upper_leg[j][i] = ul[i];
               lower_leg[j][i] = ll[i];
           }
           else {
                upper_leg[j][i] = ur[i];
                lower_leg[j][i] = lr[i];
           }
   }

   /* Adjust legs to obtain the middle and back legs. */
   for(j = 0; j < NUMBEROFLEGS; j++)
       for(i = 0; i < 8; i++) {
           switch(j) {
             case 1:
	     case 4:
               upper_leg[j][i].x += -0.6;
               lower_leg[j][i].x += -0.6;
               break;
	     case 2:
             case 5:
               upper_leg[j][i].x += -1.2;
               lower_leg[j][i].x += -1.2;
               break;
           }               
       }
}

/* Draw routines. */

void draw_rob()
{
 pushmatrix();
 translate(eye_center.x,eye_center.y,eye_center.z);
 callobj(eye);
 popmatrix();

 draw_body();
 draw_legs();
}

draw_legs()
{
   int i;

   for(i = 0; i < NUMBEROFLEGS; i++)
       draw_leg(i);
}

draw_leg(l)
int l;
{
  int i,j;
  double vert[3];

  /* Draw upper leg. */
  cpack(RGB_MYBLUE);
  for(i = 0; i < 6; i++) {
      if (i == 5 || i == 4)
          cpack(RGB_MYBLUE);

      bgnpolygon();
      for(j = 0; j < 4;j++) {
          vert[0] = upper_leg[l][face[i][j]].x;
          vert[1] = upper_leg[l][face[i][j]].y;
          vert[2] = upper_leg[l][face[i][j]].z;
          v3d(vert);
      }
      endpolygon();
  }
  /* Draw lower leg. */
  cpack(RGB_MYBLUE);
  for(i = 0; i < 6; i++) {
      if (i == 5 || i == 4)
          cpack(RGB_MYBLUE);

      bgnpolygon();
      for(j = 0; j < 4;j++) {
          vert[0] = lower_leg[l][face[i][j]].x;
          vert[1] = lower_leg[l][face[i][j]].y;
          vert[2] = lower_leg[l][face[i][j]].z;
          v3d(vert);
      }
      endpolygon();
  }
}

draw_body()
{
  int i,j;
  double vert[3];

  cpack(RGB_GRAY);
  for(i = 0; i < 6; i++) {
      if (i == 5 || i == 4)
          cpack(RGB_DARKGRAY);

      bgnpolygon();
      for(j = 0; j < 4;j++) {
          vert[0] = body[face[i][j]].x;
          vert[1] = body[face[i][j]].y;
          vert[2] = body[face[i][j]].z;
          v3d(vert);
      }
      endpolygon();
  }
}

void draw_floor()
{
   double x,z;
   double p[3];
   int sw = 0;

   for (z = -10; z < 10; z+= 1.0) {
       for (x = -10; x < 9; x+=1.0) {
           bgnpolygon();
               sw = (sw == 0 ? 1: 0);
               if (sw)
                   cpack(RGB_DARKBLUE);
               else cpack(RGB_LIGHTBLUE);
               p[0]=x;p[1]=0;p[2]=z;v3d(p);
               p[0]=x+1;p[2]=z;v3d(p);
               p[0]=x+1;p[2]=z-1;v3d(p);
               p[0]=x;p[2]=z-1;v3d(p);
               p[0]=x;p[2]=z;v3d(p);
            endpolygon();
       }
   }
}


Move_legs_forward()
{
   int i;
   double dx,dz;
   double theta;
   static int turn = 0;
   int seq[4] = {0,3,2,5};

   theta = (M_PI/180.0)*dtheta;
   /* Move all legs forward in the 'x' direction. */
   dx = deltax*cos(theta);
   dz = deltaz*sin(theta);
   incxl[0] += deltax;
   for(i = 0; i < 8; i++) {
       if ( (i == 0) || (i == 1) || 
            (i == 4) || (i == 5) ) {
            /*printf("dx = %f, dz = %f, theta = %f\n",
                      dx,dz,dtheta);*/
            upper_leg[seq[turn]][i].x += dx;
            upper_leg[seq[turn]][i].z += dz;
       }
       lower_leg[seq[turn]][i].x += dx;
       lower_leg[seq[turn]][i].z += dz;
   }

   /* Update turn(leg of the turn). */
   turn++;
   if (turn > 3) {
       /* Move_body_forward();*/
       legmoving = 0;movebody = 1;
       turn = 0;
   }

   /* Start moving legs. If the last leg was moved, stop
      and start moving body. */
   moving = 1;
}

Move_middle_forward()
{
   int i,l;
   double dx,dz;
   double theta;

   theta = (M_PI/180.0)*dtheta;
   dx = deltax*cos(theta);
   dz = deltaz*sin(theta);

   /* Also move the middle leg. */
   for(l = 0; l < 2; l++) {
       for(i = 0; i < 8; i++) {
           if ( (i == 0) || (i == 1) || 
                (i == 4) || (i == 5) ) {
                /* printf("leg %d dx = %f, dz = %f, 
                theta = %f\n",3*l + 1,dx,dz,dtheta); */
                upper_leg[3*l + 1][i].x += dx;
                upper_leg[3*l + 1][i].z += dz;
           }
           lower_leg[3*l + 1][i].x += dx;
           lower_leg[3*l + 1][i].z += dz;
      }
   }
}

Move_body_forward()
{
   int i,l;
   double dx,dz;
   double theta;

   theta = (M_PI/180.0)*dtheta;

   /* Move body and upper leg junctions. */
   dx = deltax*cos(theta);
   dz = deltaz*sin(theta);
   incxb = dx;inczb = dz;
   for(i = 0; i < 8; i++) {
       body[i].x += dx;
       body[i].z += dz;
   }
   for(l = 0; l < NUMBEROFLEGS; l++) {          
       for(i = 0; i < 8; i++) {
           if ( (i == 3) || (i == 2) ||
                (i == 6) || (i == 7) ) {
              upper_leg[l][i].x += dx;
              upper_leg[l][i].z += dz;
           }
       }
   }
   /* Update camera. */
   CamLookfrom.x += dx; CamLookfrom.z += dz;
   CamLookat.x += dx; CamLookat.z += dz;
   eye_center.x += dx; eye_center.z += dz;

}


rotate_robot(theta,xc,zc)
double theta;
double xc,zc;
{
   int i,j;

   /* Rotate body. */
   for(i = 0; i < 8; i++) {
       body[i].x = (obody[i].x - xc)*cos(theta) -
                   (obody[i].z - zc)*sin(theta);
       body[i].z = (obody[i].x - xc)*sin(theta) + 
                   (obody[i].z - zc)*cos(theta);
   }
   /* Rotate camera and lookat. */
   CamLookfrom.x=(TCamLookfrom.x - xc)*cos(theta) -
                 (TCamLookfrom.z - zc)*sin(theta);
   CamLookfrom.z=(TCamLookfrom.x - xc)*sin(theta) +
                 (TCamLookfrom.z - zc)*cos(theta);
   
   CamLookat.x = (TCamLookat.x - xc)*cos(theta) -
                 (TCamLookat.z - zc)*sin(theta);
   CamLookat.z = (TCamLookat.x - xc)*sin(theta) +
                 (TCamLookat.z - zc)*cos(theta);
   
   eye_center.x=(Teye_center.x - xc)*cos(theta) -
                (Teye_center.z - zc)*sin(theta);
   eye_center.z=(Teye_center.x - xc)*sin(theta) +
                (Teye_center.z - zc)*cos(theta);

   /* Translate back. */
   for(i = 0; i < 8; i++) {
       body[i].x += xc;
       body[i].z += zc;
   }
   CamLookfrom.x += xc; CamLookfrom.z += zc;
   CamLookat.x += xc; CamLookat.z += zc;
   eye_center.x += xc; eye_center.z += zc;
   
   /* Rotate legs. */
   for(j = 0; j < NUMBEROFLEGS; j++)
       for(i = 0; i < 8; i++) {
           upper_leg[j][i].x = 
             (oupper_leg[j][i].x - xc)*cos(theta) -
             (oupper_leg[j][i].z - zc)*sin(theta);
           upper_leg[j][i].z = 
             (oupper_leg[j][i].x - xc)*sin(theta) + 
             (oupper_leg[j][i].z - zc)*cos(theta);

           lower_leg[j][i].x = 
             (olower_leg[j][i].x - xc)*cos(theta) -
             (olower_leg[j][i].z - zc)*sin(theta);
           lower_leg[j][i].z = 
             (olower_leg[j][i].x - xc)*sin(theta) + 
             (olower_leg[j][i].z - zc)*cos(theta);
       }
   /* Translate back. */
   for(j = 0; j < NUMBEROFLEGS; j++)
       for(i = 0; i < 8; i++) {
           upper_leg[j][i].x += xc;
           upper_leg[j][i].z += zc;
           lower_leg[j][i].x += xc;
           lower_leg[j][i].z += zc;
       }
}

set_control()
{
   qdevice(CKEY);
   qdevice(QKEY);
   qdevice(LKEY);
   qdevice(RKEY);
   qdevice(LEFTARROWKEY);
   qdevice(RIGHTARROWKEY);
   qdevice(DOWNARROWKEY);
   qdevice(UPARROWKEY);
   qdevice(GKEY);
   qdevice(BKEY);
}

