unit PCRobots;

interface

const    ARENA_FREE=0;
         ARENA_WALL=1;
         ARENA_DAMAGE=3;
         ARENA_REFUEL=30;
         SHELL_MISSED=0;
         SHELL_HIT_WALL=1;
         SHELL_CLOSE_BLAST=2;
         SHELL_NEAR_MISS=3;
         SHELL_DIRECT_HIT=4;


type      Pattern_buffer=array[0..5] of shortint;
          Patbuf_ptr=^Pattern_buffer;
          Map_buffer=array[0..8,0..8] of shortint;
          Mapbuf_ptr=^Map_buffer;

procedure Swaptask;
procedure Movement(speed,angle:integer);
function  Scan(angle,res:integer;var range:integer):integer;
function  Shoot(angle,range:integer):integer;
procedure Getxy(var x,y:integer);
function  Transmit(target,data:integer):integer;
function  Receive(var source,data:integer):integer;
function  Damage:integer;
function  Speed:integer;
function  Battery:integer;
function  Ticks:longint;
function  L_Sin(angle:integer):longint;
function  L_Cos(angle:integer):longint;
function  L_Tan(angle:integer):longint;
function  L_Atan(ratio:longint):integer;
function  L_Sqrt(value:longint):longint;
procedure Set_Pattern(Buffer:Patbuf_ptr);
procedure Debug_Flag(flag,setflag:integer);
procedure Buy_Armour(armour_units:integer);
procedure Buy_Shells(shells:word);
function  Shells_Left:integer;
procedure Get_Local_Map(ptr:MapBuf_ptr);
procedure Invisibility(invis_flag:integer);
function  Get_Shell_Status:integer;
function  IsInvisible:integer;
function  L_Atan2(y,x:integer):integer;
function	Configure(speed,manouevre,range,armour,acceleration,invisibility:integer):integer;

implementation

uses DOS;

procedure Swaptask;
 var regs:Registers;
BEGIN
 regs.ax:=0;
 intr($e0,regs);
END;

procedure Movement(speed,angle:integer);
 var regs:Registers;
BEGIN
 regs.ax:=1;
 regs.bx:=speed;
 regs.cx:=angle;
 intr($e0,regs);
END;

function  Scan(angle,res:integer;var range:integer):integer;
 var regs:Registers;
BEGIN
 regs.ax:=2;
 regs.bx:=angle;
 regs.cx:=res;
 intr($e0,regs);
 range:=regs.bx;
 Scan:=regs.ax;
END;

function  Shoot(angle,range:integer):integer;
 var regs:Registers;
BEGIN
 regs.ax:=3;
 regs.bx:=angle;
 regs.cx:=range;
 intr($e0,regs);
 Shoot:=regs.ax;
END;

procedure Get_Remote_Map(ptr:MapBuf_ptr;x,y:integer);
 var regs:Registers;
BEGIN
 regs.ax:=$21;
 regs.bx:=seg(ptr^);
 regs.cx:=ofs(ptr^);
 regs.dh:=x;
 regs.dl:=y;
 intr($e0,regs);
END;

procedure Getxy(var x,y:integer);
 var regs:Registers;
BEGIN
 regs.ax:=$10;
 intr($e0,regs);
 x:=regs.bx;
 y:=regs.cx;
END;

function  Transmit(target,data:integer):integer;
 var regs:Registers;
BEGIN
 regs.ax:=$11;
 regs.bx:=target;
 regs.cx:=data;
 intr($e0,regs);
 Transmit:=regs.ax;
END;

function  Receive(var source,data:integer):integer;
 var regs:Registers;
BEGIN
 regs.ax:=$12;
 intr($e0,regs);
 source:=regs.bx;
 data:=regs.cx;
 Receive:=regs.ax;
END;

function  Damage:integer;
 var regs:Registers;
BEGIN
 regs.ax:=$13;
 intr($e0,regs);
 Damage:=regs.bx;
END;

function  Speed:integer;
 var regs:Registers;
BEGIN
 regs.ax:=$14;
 intr($e0,regs);
 Speed:=regs.bx;
END;

function  Battery:integer;
 var regs:Registers;
BEGIN
 regs.ax:=$15;
 intr($e0,regs);
 Battery:=regs.bx;
END;

function  Ticks:longint;
 var regs:Registers;
BEGIN
 regs.ax:=$16;
 intr($e0,regs);
 Ticks:=(regs.bx shl 16)+regs.cx;
END;

function  L_Sin(angle:integer):longint;
 var regs:Registers;
BEGIN
 regs.ax:=$17;
 regs.bx:=angle;
 intr($e0,regs);
 L_Sin:=((longint)regs.bx shl 16)+regs.cx;
END;

function  L_Cos(angle:integer):longint;
 var regs:Registers;
BEGIN
 regs.ax:=$18;
 regs.bx:=angle;
 intr($e0,regs);
 L_Cos:=((longint)regs.bx shl 16)+regs.cx;
END;

function  L_Tan(angle:integer):longint;
 var regs:Registers;
BEGIN
 regs.ax:=$19;
 regs.bx:=angle;
 intr($e0,regs);
 L_Tan:=((longint)regs.bx shl 16)+regs.cx;
END;

function  L_Atan(ratio:longint):integer;
 var regs:Registers;
BEGIN
 regs.ax:=$1a;
 regs.bx:=(ratio shr 16);
 regs.cx:=(ratio and $ffff);
 intr($e0,regs);
 L_Atan:=regs.ax;
END;

function  L_Sqrt(value:longint):longint;
 var regs:Registers;
BEGIN
 regs.ax:=$1b;
 regs.bx:=(value shr 16);
 regs.cx:=(value and $ffff);
 intr($e0,regs);
 L_Sqrt:=((longint)regs.bx shl 16)+regs.cx;
END;

procedure Set_Pattern(Buffer:Patbuf_ptr);
 var regs:Registers;
BEGIN
 regs.ax:=$1c;
 regs.bx:=seg(Buffer^);
 regs.cx:=ofs(Buffer^);
 intr($e0,regs);
END;

procedure Debug_Flag(flag,setflag:integer);
 var regs:Registers;
BEGIN
 regs.ax:=$1d;
 regs.bx:=flag;
 regs.cx:=setflag;
 intr($e0,regs);
END;

procedure Buy_Armour(armour_units:integer);
 var regs:Registers;
BEGIN
 regs.ax:=$1e;
 regs.bx:=armour_units;
 intr($e0,regs);
END;

procedure Buy_Shells(shells:word);
 var regs:Registers;
BEGIN
 regs.ax:=$1f;
 regs.bx:=shells;
 intr($e0,regs);
END;

function  Shells_Left:integer;
 var regs:Registers;
BEGIN
 regs.ax:=$20;
 intr($e0,regs);
 Shells_Left:=regs.bx;
END;

procedure Get_Local_Map(ptr:MapBuf_ptr);
 var regs:Registers;
BEGIN
 regs.ax:=$21;
 regs.bx:=seg(ptr^);
 regs.cx:=ofs(ptr^);
 intr($e0,regs);
END;

procedure Invisibility(invis_flag:integer);
 var regs:Registers;
BEGIN
 regs.ax:=$22;
 regs.bx:=invis_flag;
 intr($e0,regs);
END;

function  Get_Shell_Status:integer;
 var regs:Registers;
BEGIN
 regs.ax:=$23;
 intr($e0,regs);
 Get_Shell_Status:=regs.bx;
END;

function  IsInvisible:integer;
 var regs:Registers;
BEGIN
 regs.ax:=$24;
 intr($e0,regs);
 IsInvisible:=regs.bx;
END;

function  L_Atan2(y,x:integer):integer;
 var regs:Registers;
BEGIN
 regs.ax:=$25;
 regs.bx:=y;
 regs.cx:=x;
 intr($e0,regs);
 L_Atan2:=regs.ax;
END;

function Get_Robot_Id:integer;
BEGIN
 regs.ax:=$26;
 intr($e0,regs);
 Get_Robot_Id:=regs.ax;
END;

function Check_Iff(Id:integer):integer;
BEGIN
 regs.ax:=$28;
 regs.bx:=Id;
 intr($e0,regs);
 Check_Iff:=regs.ax;
END;

function Get_Team_Id:integer;
BEGIN
 regs.ax:=$2b;
 intr($e0,regs);
 Get_Team_Id:=regs.ax;
END;

function	Configure(speed,manouevre,range,armour,acceleration,invisibility:integer):integer;
 var regs:Registers;
BEGIN
 regs.ax:=$80;
 regs.bx:=(speed and 7) + ((manouevre and 7) shl 4) + ((range and 7) shl 8)+
		((armour and 7) shl 12);
 regs.cx:=(acceleration and 7) + ((invisibility and 1) shl 3);

 intr($e0,regs);
 Configure:=regs.ax;
END;

end.
