;;; -*- Package: Toolset; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolset)

(DEFCLASS RECOGNITION-AGENT (DRAGON) 
       
       ;; output confidence set
 ((OUTPUT-CONFIDENCE-VOCABULARY :TYPE CONFIDENCE-SET :INITARG 
				OUTPUT-CONFIDENCE-VOCABULARY)
       
       ;; most recent confidence value

  (CONFIDENCE-VALUE :TYPE SYMBOL :INITARG CONFIDENCE-VALUE
		    :INITFORM NIL)
       
       ;; where the RA gets the information to set confidence,
       
       ;; the inputs

  (FEATURES :TYPE VECTOR :INITARG FEATURES)
  (NUMBER-OF-FEATURES :TYPE INTEGER :INITFORM 0 :INITARG NUMBER-OF-FEATURES)
       
       ;; showable or source code form of feature specs

  (DISPLAY-FEATURES :TYPE VECTOR :INITARG DISPLAY-FEATURES)
       
       ;; kinds of feature fetches. Choice of SYMBOL, RA, IDB,
       
       ;; INVOKE, ASK-USER.  This is set by the feature parser.

  (FEATURE-FETCH-TYPES :TYPE (VECTOR SYMBOL) :INITARG FEATURE-FETCH-TYPES)
       
       ;; expected types of symbols supplied by features after
       
       ;; processing by the transforms.  Choice of SYMBOL,
       
       ;; NUMBER, or a confidence set class name.  This is set
       
       ;; by the feature parser.

  (FEATURE-VALUE-TYPES :TYPE (VECTOR SYMBOL) :INITARG FEATURE-VALUE-TYPES)

  (FEATURE-CACHE :TYPE VECTOR :INITARG FEATURE-CACHE)
  (TRANSFORMS :TYPE VECTOR :INITARG TRANSFORMS)
  (DISPLAY-TRANSFORMS :TYPE VECTOR :INITARG DISPLAY-TRANSFORMS)
       
       ;; where the results get sent.  This is  for later use
       
       ;; in bottom-up invocation without return values.

  (OUTPUT-DESTINATION :TYPE VECTOR :INITARG OUTPUT-DESTINATION)
       
       ;; showable or source code form of output specs

  (DISPLAY-OUTPUT-DESTINATION :TYPE VECTOR :INITARG DISPLAY-OUTPUT-DESTINATION)

  (GENERIC-FUNCTION :ALLOCATION :CLASS :INITFORM "To match a fixed `concept' to the situation and determine a confidence that the concept applies to the situation."
         )))
