;; -*- Mode: Lisp; -*-

;;; KDF's lisp init for hacking at PARC

(change-memory-management :growth-limit 2048
			  :growth-rate 8)

(load "~dekleer/kdf/atms/march93/tmsload.lisp")
(load "~dekleer/kdf/adb/v3-3/adbload.lisp")
(load "~dekleer/kdf/qpe/v2-7/qpeload.lisp")

(format t
"~%WARNING: Setting tms::*reclaim-flag* and tms::*delay-assumptions* to NIL")

(setq tms::*reclaim-flag* nil tms::*delay-assumptions* nil)

(defun load-all ()
  (eval `(,(intern "LOAD-ATMS" (find-package :TMS))))
  (eval `(,(intern "LOAD-ADB" (find-package :ADB))))
  (eval `(,(intern "INIT" (find-package :ADB)) t))
  (eval `(,(intern "LOAD-QPE" (find-package :QPE)))))

(defun compile-all ()
  (eval `(,(intern "COMPILE-ATMS" (find-package :TMS))))
  (eval `(,(intern "COMPILE-ADB" (find-package :ADB))))
  (eval `(,(intern "INIT" (find-package :ADB)) t))
  (eval `(,(intern "COMPILE-QPE" (find-package :QPE)))))

