;;;;
;;;; Zeno domain for transportation problems
;;;;

(in-package "ZENO")

(defun truck-world-domain ()
  (reset-domain)
  (add-domain-function 'vehicle-capacity)
  (add-domain-function 'vehicle-speed)
  (add-domain-function 'object-size)
  (add-domain-function 'distance-between)

  (define (operator drive)
      :parameters (?veh ?from ?to)
      :resources ((vehicle ?veh))
      :at-time (?s ?e)
      :precondition (:and (:neq ?from ?to)    ;; don't be stupid
			  (:holds-at ?s (veh-location ?veh ?from))
			  )
      :effects
      ((:cause 
          (= (- ?e ?s)
             (* (distance-between ?from ?to)
                (vehicle-speed ?veh))))
       (:cause
	(:and
	 (:holds-at ?e (:not (veh-location ?veh ?from)))
	 (:holds-at ?e (veh-location ?veh ?to))))
       ))


  (define (operator load)
     :at-time (?s ?e)
     :resources ((vehicle ?veh))
     :parameters (?obj ?veh ?from)
     :precondition (:and (:neq ?obj ?veh)
			 (:static (object ?obj))
			 (:static (vehicle ?veh))
			 (:holds-at ?s (veh-location ?veh ?from))
			 (:holds-at ?s (location ?obj ?from))
			 (<= (object-size ?obj)
			     (:value-at ?s (vehicle-current-capacity ?veh))))

     :effects
     ((:cause
       (= (:value-at ?e (vehicle-current-capacity ?veh))
	  (- (:value-at ?s (vehicle-current-capacity ?veh))
	     (object-size ?obj))))
      (:cause
       (:and
	(:holds-at ?e (:not (location ?obj ?from)))
	(:holds-at ?e (in ?obj ?veh)))))
      )


  (define (operator unload)
     :at-time (?s ?e)
     :resources ((vehicle ?veh))
     :parameters (?obj ?veh ?place)
     :precondition (:and (:neq ?obj ?veh)
			 (:static (object ?obj))
			 (:static (vehicle ?veh))
			 (:holds-at ?s (veh-location ?veh ?place))
			 (:holds-at ?s (in ?obj ?veh)))
     :effects
     ((:cause
       (= (:value-at ?e (vehicle-current-capacity ?veh))
	  (+ (:value-at ?s (vehicle-current-capacity ?veh))
	     (object-size ?obj))))
      (:cause
       (:and
	(:holds-at ?e (location ?obj ?place))
	(:holds-at ?e (:not (in ?obj ?veh)))))))
  )


(defvar *tw-defaults*
    '(:and
      (:static (object refrigerator-1))
      (:static (object refrigerator-2))
      (:static (vehicle truck-1))
      (:static (place parking-lot))
      (:static (place warehouse-1))
      (:static (place customer-1))

      (= 10 (vehicle-capacity truck-1))
      (= (vehicle-capacity truck-1)    
       (:value-at 0 (vehicle-current-capacity truck-1)))
      (= 2 (vehicle-speed truck-1))
      (= 7 (object-size refrigerator-1))
      (= 4 (object-size refrigerator-2))
      (= 8 (distance-between parking-lot warehouse-1))
      (= 20 (distance-between parking-lot customer-1))
      (= 8 (distance-between warehouse-1 parking-lot))
      (= 12 (distance-between warehouse-1 customer-1))
      (= 12 (distance-between customer-1 warehouse-1))
		
      (:holds-at 0 (veh-location truck-1 parking-lot))
      (:holds-at 0 (location refrigerator-1 warehouse-1))
      (:holds-at 0 (location refrigerator-2 warehouse-1))
      ))


(defproblem truckworld-1 (0 :goal)
  :domain 'truck-world-domain
  :inits `((:cause ,*tw-defaults*))
  :goal '(:and
	  (:holds-at :goal (location refrigerator-1 customer-1))
	  (:holds-at :goal (location refrigerator-2 customer-1)))
  )

(defproblem truckworld-2 (0 :goal)
    :domain 'truck-world-domain
    :inits `((:cause ,*tw-defaults*))
    :goal '(:holds-at :goal (in refrigerator-1 truck-1))
    )

(defproblem truckworld-3 (0 :goal)
    :domain 'truck-world-domain
    :inits `((:cause ,*tw-defaults*))
    :goal '(:and
	    (:holds-at :goal (in refrigerator-1 truck-1))
	    (:holds-at :goal (veh-location truck-1 customer-1)))
    )

(defproblem truckworld-4 (0 :goal)
    :domain 'truck-world-domain
    :inits `((:cause ,*tw-defaults*))
    :goal '(:and
	    (:holds-at :goal (location refrigerator-1 customer-1))
	    (:holds-at :goal (veh-location truck-1 customer-1)))
    )

(defproblem truckworld-5 (0 :goal)
    :domain 'truck-world-domain
    :inits `((:cause ,*tw-defaults*))
    :goal '(:and
	    (:holds-at :goal (location refrigerator-1 customer-1))
	    (:holds-at :goal (veh-location truck-1 warehouse-1)))
    )


(defproblem truckworld-6 (0 :goal)
    :domain 'truck-world-domain
    :inits `((:cause ,*tw-defaults*))
    :goal '(:and
	    (:holds-at :goal (location refrigerator-1 customer-1))
	    (:holds-at :goal (veh-location truck-1 warehouse-1))
	    (:holds-at :goal (in refrigerator-2 truck-1)))
    )

(defproblem truckworld-7 (0 :goal)
      :domain 'truck-world-domain
      :inits `((:cause ,*tw-defaults*))
      :goal '(:and
	      (:holds-at :goal (location refrigerator-1 customer-1))
	      (:holds-at :goal (location refrigerator-2 customer-1))
	      (:holds-at :goal (veh-location truck-1 customer-1)))
      )


#||
		
The essence of this problem is that the two refrigerators together are
to big to fit in the truck at once.  The plan that I would expect it
to eventually find is:

	Drive (truck-1, parking-lot, warehouse-1)
	Load (refrigerator-1, truck-1)
	Drive (truck-1, warehouse-1, customer-1)
	Unload (refrigerator-1, truck-1)
	Drive (truck-1, customer-1, warehouse-1)
	Load (refrigerator-2, truck-1)
	Drive (truck-1, warehouse-1, customer-1)
	Unload (refrigerator-2, truck-1)

But instead, it is generating this inconsistent plan:

	Drive (truck-1, parking-lot, warehouse-1)
	Load (refrigerator-1, truck-1)
	Load (refrigerator-2, truck-1)
	Drive (truck-1, customer-1, warehouse-1)
	Unload (refrigerator-1, truck-1)
	Unload (refrigerator-2, truck-1)

Not any more.
#plan<S=2; O=0; U=0>
ZENO(98): (sc-control 'truckworld-1 'speedy-truck)
Warning: 5118768 bytes have been tenured, next gc will be global.
See the documentation for variable EXCL:*GLOBAL-GC-BEHAVIOR* for more
         information.

(0 ?S.5 ?E.5 ?S.4 ?E.4 ?S.7 ?E.7 ?S.1 ?E.1 ?S.6 ?E.6 ?S.3 ?E.3 ?S.8 ?E.8 ?S.2
 ?E.2 :GOAL) 
#plan<S=8; O=0; U=0> of rank 36

:Init()..................................  |-------------------------------------------------------------------|
  Location(refrigerator-1,warehouse-1)...  |-------------------------------------------|
  Location(refrigerator-2,warehouse-1)...  |-----------|
  Veh-location(truck-1,parking-lot)......  |---|
  Vehicle-current-capacity(truck-1)......  |-----------|
Drive(truck-1,parking-lot,warehouse-1)...      |---|
  Veh-location(truck-1,warehouse-1)......          |---|
  Veh-location(truck-1,warehouse-1)......          |-----------|
Load(refrigerator-2,truck-1,warehouse-1).              |---|
  In(refrigerator-2,truck-1).............                  |-----------|
  Vehicle-current-capacity(truck-1)......                  |-----------|
Drive(truck-1,warehouse-1,customer-1)....                      |---|
  Veh-location(truck-1,customer-1).......                          |-----------|
  Veh-location(truck-1,customer-1).......                          |---|
Unload(refrigerator-2,truck-1,customer-1)                              |---|
  Location(refrigerator-2,customer-1)....                                  |-----------------------------------|
  Vehicle-current-capacity(truck-1)......                                  |-----------|
Drive(truck-1,customer-1,warehouse-1)....                                      |---|
  Veh-location(truck-1,warehouse-1)......                                          |---|
  Veh-location(truck-1,warehouse-1)......                                          |-----------|
Load(refrigerator-1,truck-1,warehouse-1).                                              |---|
  In(refrigerator-1,truck-1).............                                                  |-----------|
Drive(truck-1,warehouse-1,customer-1)....                                                      |---|
  Veh-location(truck-1,customer-1).......                                                          |---|
Unload(refrigerator-1,truck-1,customer-1)                                                              |---|
  Location(refrigerator-1,customer-1)....                                                                  |---|
                                           0  S.5 E.5 S.4 E.4 S.7 E.7 S.1 E.1 S.6 E.6 S.3 E.3 S.8 E.8 S.2 E.2Goal
Complete!
Succeeded in 254.48 seconds.
Unify:    16424 clauses unified.
Plans:    1325 visited of 3716 created.
          40 inconsistent, 31 invalid, 167 impossible.
Posted:   9359 constraints, generating 4094 codesgs,
          4742 eqns, 137 lineq, 376 nonlin.
Solved:   9911 ero's (8820 actually needed; 264 from simplex)
          182 Simplex pivots, 3474 Gaussian pivots, 436 wakeups.

Gauss->Simplex: 271
Gauss->Nonlin:  0
Simplex->Gauss: 2656
#plan<S=8; O=0; U=0>
ZENO(99): (setf p *)
#plan<S=8; O=0; U=0>
ZENO(100): (show-metrics p)
At time 0   , Vehicle-current-capacity(truck-1)=10.0d0
At time E.4 , Vehicle-current-capacity(truck-1)=6.0d0
At time E.1 , Vehicle-current-capacity(truck-1)=10.0d0
At time FOREVER, Object-size(refrigerator-2)=4.0d0
At time FOREVER, Object-size(refrigerator-2)=4.0d0
At time FOREVER, Object-size(refrigerator-2)=4.0d0
At time FOREVER, Object-size(refrigerator-2)=4.0d0
At time FOREVER, Vehicle-capacity(truck-1)=10.0d0
At time FOREVER, Vehicle-capacity(truck-1)=10.0d0
At time FOREVER, Vehicle-speed(truck-1)=2.0d0
At time FOREVER, Vehicle-speed(truck-1)=2.0d0
At time FOREVER, Distance-between(warehouse-1,customer-1)=12.0d0
At time FOREVER, Distance-between(warehouse-1,customer-1)=12.0d0
At time FOREVER, Vehicle-speed(truck-1)=2.0d0
At time FOREVER, Vehicle-speed(truck-1)=2.0d0
At time FOREVER, Distance-between(warehouse-1,customer-1)=12.0d0
At time FOREVER, Distance-between(warehouse-1,customer-1)=12.0d0
At time FOREVER, Vehicle-speed(truck-1)=2.0d0
At time FOREVER, Vehicle-speed(truck-1)=2.0d0
At time FOREVER, Distance-between(customer-1,warehouse-1)=12.0d0
At time FOREVER, Distance-between(customer-1,warehouse-1)=12.0d0
At time FOREVER, Vehicle-speed(truck-1)=2.0d0
At time FOREVER, Vehicle-speed(truck-1)=2.0d0
At time FOREVER, Distance-between(parking-lot,warehouse-1)=8.0d0
At time FOREVER, Distance-between(parking-lot,warehouse-1)=8.0d0
At time FOREVER, Object-size(refrigerator-2)=4.0d0
At time FOREVER, Object-size(refrigerator-2)=4.0d0
At time FOREVER, Object-size(refrigerator-1)=7.0d0
At time FOREVER, Object-size(refrigerator-1)=7.0d0
NIL
ZENO(101): (show (plan-constraints p))


(show (plan-constraints p))
Equations:
?V697.3 = 10.0
?V700.4 = 4.0
v1079 = 6.0
?V698.4 = 6.0
?V702.1 = 6.0
?V701.1 = 10.0
v1076 = 10.0
?V697.4 = 10.0
v1064 = 24.0
v1065 = 24.0
v1062 = 24.0
v1063 = 24.0
v1058 = 16.0
v1059 = 16.0
v1056 = 24.0
v1057 = 24.0
v120 = 24.0
?V695.8 = 2.0
?V694.8 = 12.0
?E.8 + -1.0 ?S.8 = 24.0
v121 = 24.0
v118 = 16.0
v119 = 16.0
v59 = 24.0
?V695.7 = 2.0
?V694.7 = 12.0
?E.7 + -1.0 ?S.7 = 24.0
v60 = 24.0
v14 = 24.0
?V695.6 = 2.0
?V694.6 = 12.0
?E.6 + -1.0 ?S.6 = 24.0
v15 = 24.0
v7 = 16.0
?V695.5 = 2.0
?V694.5 = 8.0
?E.5 + -1.0 ?S.5 = 16.0
v8 = 16.0
?V696.4 = 4.0
?V699.4 = 10.0
v5 = 6.0
?V696.3 = 7.0
?V699.3 + -1.0 ?V700.3 + -1.0 ?V698.3 = 0.0
v3 + -1.0 ?V698.3 = 0.0
?V703.2 + ?V702.2 + -1.0 ?V701.2 = 0.0
v2 + -1.0 ?V701.2 = 0.0
?V703.1 = 4.0
v1 = 10.0
?V705 = 10.0
?V714 = 12.0
?V713 = 12.0
?V712 = 8.0
?V711 = 20.0
?V710 = 8.0
?V709 = 4.0
?V708 = 7.0
?V707 = 2.0
?V706 = 10.0
?V704 = 10.0

Inequalities:
s1 = 3.0
s2 = 6.0

Nonlinear delays:
ZENO(102): (dolist (x (cdr (plan-ordering p))) (print x))

(< ?E.5 ?S.4) 
(< ?E.6 ?S.3) 
(< ?E.7 ?S.1) 
(< ?E.8 ?S.2) 
(< ?E.1 ?S.6) 
(<= ?E.7 ?S.1) 
(< ?E.3 ?S.8) 
(< ?E.6 ?S.8) 
(< ?S.8 ?E.8) 
(< 0 ?S.8) 
(<= ?E.8 ?S.2) 
(< ?E.4 ?S.7) 
(< ?S.7 ?E.7) 
(< 0 ?S.7) 
(<= ?E.7 ?S.6) 
(< ?E.4 ?S.6) 
(< ?E.5 ?S.6) 
(< ?S.6 ?E.6) 
(< 0 ?S.6) 
(<= ?E.6 ?S.3) 
(< ?S.5 ?E.5) 
(< 0 ?S.5) 
(<= ?E.5 ?S.4) 
(< ?S.4 ?E.4) 
(< 0 ?S.4) 
(<= ?E.4 ?S.1) 
(< ?S.3 ?E.3) 
(< 0 ?S.3) 
(<= ?E.3 ?S.2) 
(< ?E.2 :GOAL) 
(< ?S.2 ?E.2) 
(< 0 ?S.2) 
(<= ?E.2 :GOAL) 
(< ?E.1 :GOAL) 
(< ?S.1 ?E.1) 
(< 0 ?S.1) 
(<= ?E.1 :GOAL) 
NIL
ZENO(103): 

||#
