;;
;;; Test gathering stuff
;;

(in-package "ZENO")

(defvar *data* nil)

(defun sample-mean (samples)
  (/ (apply #'+ samples)
     (length samples)))

(defun sample-variance (samples)
  (let ((mean (sample-mean samples))
	(sum-squares 0))
    (dolist (xi samples)
      (incf sum-squares
	    (* (- xi mean) (- xi mean))))
    (/ sum-squares (- (length samples) 1))))

(defun stats (samples)
  ;; assumes 10 samples
  (list (sample-mean samples)
	(* 1.833 (sqrt (* 0.1 (sample-variance samples))))))

(defun collect-samples (prob)
  (setf p nil)
  (excl:gc)
  (when (symbolp prob) 
    (setf prob (find prob *tests* :key #'problem-name)))
  (funcall (problem-domain prob))
  (let ((samples nil))
    (print (problem-name prob))
    (dotimes (i 10)
      (multiple-value-bind (plan ok? time)
	  (zeno
	   (problem-start prob) (problem-end prob)
	   (problem-inits prob) (problem-goal prob)
	   'simple-rank 'bestf-search)
	(unless ok?
	  (return-from collect-samples nil))
	(push time samples)
	(princ (1+ i))
	(if (< i 9) (princ "..."))
	(force-output)))
    (list (cons (problem-name prob) (stats samples))
	  (get-stat .visited.)
	  samples)))
    
(defvar *benchmarks*
    '(sussman-anomaly get-paid (hanoi 2) ysp door-latch phd))

(defun test-suite ()
  (let ((result nil))
    (dolist (prob *benchmarks*)
      (if (consp prob)
	  (setf prob (eval prob)))
      (push
       (collect-samples prob) result)
;      (if (null (car result)) (return-from test-suite nil))
      (print (caar result)))
    (values result)))

(defun lifo-test ()
;  (setf *goal-splitting* nil)
  (setf *fifo-flaws* nil)
  (list
   "LIFO goal selection"
   (test-suite)))

(defun fifo-test ()
;  (setf *goal-splitting* nil)
  (setf *fifo-flaws* t)
  (list
   "FIFO goal selection"
   (test-suite)))

(defun ramp-depth (&optional (offset 0))
  (let ((result nil))
    (setf *search-limit* 3000)
    (setf *goal-splitting* t)
    (dotimes (i 5)
      (setf *max-goal-splits* (+ i offset))
      (push
       (list (format nil "Split level ~d" (+ offset i))
	     (lifo-test)
	     (fifo-test))
       result)
      (print (car result)))
    (values result)))

(defun show-lifo (x)
  (let ((a nil))
    (loop for count from 0 to 5
	do
	  (format t "~%**~s**~%~%" (elt *benchmarks* (- 5 count)))
	  (loop for test in x
	      for index from 0
	      as lifo = (second (second test))
	      do
		(setf a (car (elt lifo count)))
		(if a
		    (format t "~& ~a ~s ~s"
			    index 
			    (float (/ (second a) 1000))
			    (float (/ (third a) 1000)))
		  (format t "~% ~a 100 0" index))))))

(defun show-fifo (x)
  (let ((a nil))
    (loop for count from 0 to 5
	do
	  (format t "~%**~s**~%~%" (elt *benchmarks* (- 5 count)))
	  (loop for test in x
	      for index from 0
	      as fifo = (second (third test))
	      do
		(setf a (car (elt fifo count)))
		(if a
		    (format t "~& ~a ~s ~s"
			    index 
			    (float (/ (second a) 1000))
			    (float (/ (third a) 1000)))
		  (format t "~% ~a 100 0" index))))))
