;;
;;; Statistics gathering
;;

(in-package "ZENO")

(defvar *statistics* (make-array 256 :initial-element 0))

(defmacro count-stat (index)
  `(incf (elt *statistics* ,index)))

(defmacro record-stat (index value)
  `(setf (elt *statistics* ,index) ,value))

(defmacro reset-stat ()
  `(fill *statistics* 0))

(defmacro get-stat (index)
  `(elt *statistics* ,index))

(defconstant .plan. 0)			;the created plan
(defconstant .cpu-time. 1)		;total cpu time
(defconstant .branch. 2)		;average branching factor
(defconstant .created. 3)		;plans created
(defconstant .visited. 4)		;plans visited
(defconstant .inconsistent. 5)		;number of inconsistent plans
(defconstant .invalid. 6)		;number of invalid plans
(defconstant .dead-end. 7)		;number of dead ends
(defconstant .goals. 8)			;number of goals
(defconstant .inits. 9)			;number of inits
(defconstant .gpivot. 10)		;gaussian pivots
(defconstant .spivot. 11)		;simplex pivots
(defconstant .equations. 12)		;equations added
(defconstant .ineq. 13)			;inequalities added
(defconstant .nonlin. 14)		;nonlinear equations added
(defconstant .wakeup. 15)		;number of wakeups
(defconstant .ero. 16)			;elementary row operations
(defconstant .implicits. 17)		;implicit equalities found
(defconstant .constraints. 18)		;number of metric constraints posted
(defconstant .unify. 19)		;number of unificiations
(defconstant .codesg. 20)		;number of symbolic EQ/NEQs posted
(defconstant .gauss->simplex. 21)	;constraints passed from gauss to simplex
(defconstant .simplex->gauss. 22)	;from simplex to gaussian
(defconstant .gauss->nonlin. 23)	;from gauss to nonlin
(defconstant .success. 24)		;plan succeeded?
(defconstant .valid-ero. 25)		;necessary elementary row ops.
(defconstant .simplex-ero. 26)		;ero's during simplex op.

;;;;;;;;;;;;;;;;;;;;;;;;
;;; Print out statistics from single run

(defun DISPLAY-STATS ()
  (format t "~:[Failed~;Succeeded~] in ~f seconds.~%~
Unify:    ~d clauses unified.
Plans:    ~d visited of ~d created.
          ~d inconsistent, ~d invalid, ~d impossible.
Posted:   ~d constraints, generating ~d codesgs,
          ~d eqns, ~d lineq, ~d nonlin.
Solved:   ~d ero's (~d actually needed; ~d from simplex)
          ~d Simplex pivots, ~d Gaussian pivots, ~d wakeups.

Gauss->Simplex: ~d
Gauss->Nonlin:  ~d
Simplex->Gauss: ~d
"
  (get-stat .success.)
  (float (/ (get-stat .cpu-time.) internal-time-units-per-second))
  (get-stat .unify.)
  (get-stat .visited.) (get-stat .created.)
  (get-stat .inconsistent.) (get-stat .invalid.) (get-stat .dead-end.)
  (get-stat .constraints.) (get-stat .codesg.)
  (get-stat .equations.) (get-stat .ineq.) (get-stat .nonlin.)
  (get-stat .ero.) (get-stat .valid-ero.) (get-stat .simplex-ero.)
  (get-stat .spivot.) (get-stat .gpivot.) (get-stat .wakeup.)
  (get-stat .gauss->simplex.)
  (get-stat .simplex->gauss.)
  (get-stat .gauss->nonlin.)
  ))
