;;; Compile and load ZENO if no defsystem available

" All rights reserved. Use of this software is permitted for non-commercial
  research purposes, and it may be copied only for that use.  All copies must
  include this copyright message.  This software is made available AS IS, and
  neither the authors nor the University of Washington make any warranty about
  the software or its performance.

  When you first acquire this software please send mail to 
  bug-zeno@cs.washington.edu; the same address should be used for problems."

(defpackage "ZENO")
(defpackage "VARIABLE")
(defpackage "CHOICE")
(defpackage "RULE-NET")
(defpackage "SC")


#+aclpc(defparameter *zeno-dir* "c:\\thesis\\")
;(defparameter *zeno-dir* "/projects/ai/planners/zeno/")
#+RS6000(defparameter *zeno-dir* "/u/jsp/thesis/code/cp3/")
(defparameter *source* ".lsp")
;(defparameter *binary* ".sfasl4")
#+RS6000(defparameter *binary* ".fasl")
#+aclpc(defparameter *binary* ".fsl")

(defun compile&load-file (fname)
  (compile-file (concatenate 'string fname *source*))
  (load (concatenate 'string fname *binary*)))

#+RS6000
(defsystem :zeno
    (:default-pathname "/u/jsp/thesis/code/cp3/"
	:default-file-type "lsp")
  (:parallel
   (:serial "stat"
	    "codesg"
	    "struct"
	    "util"
	    "parser"
	    "time"
	    "mparse"
	    (:parallel (:serial "gauss" "simplex" "nonlin")
		       (:serial "zeno1" "zeno2" "gantt" "ndomains"))
	    "test")
   (:serial
    "choose" "rules" "scr" "zenoex")))
   
(defvar *files*
    '("stat" "codesg" "struct" "util" "parser" "time" "mparse"
      "gauss" "simplex" "nonlin" "gantt" "zeno1" "zeno2"
      "ndomains"
      ;;
      ;; Tony's neat SCR stuff
      ;;
      "choose" "rules" "scr" "zenoex"))

(defun LOAD-ZENO ()
  (dolist (file *files*)
    (load (concatenate 'string *zeno-dir* file *binary*))))

(defun COMPILE-ZENO ()
;  (load-zeno)
  (dolist (file *files*)
    (compile&load-file (concatenate 'string *zeno-dir* file ))))
