;;; Copyright (C) 1994 by Istituto per la Ricerca Scientifica e Tecnologica 
;;; (IRST) (38050 Povo, Trento Italy) and the Trustees of the University 
;;; of Rochester (Rochester, NY 14627, USA).  All rights reserved.
;;; See the COPYRIGHT.TEXT file for more information

;; separation of the ui from the engine, and some other cleanups 
;; by Brad Miller miller@cs.rochester.edu 12/7/93

#| Nov. 24 1993

 *****************************************************
 *                                                   *
 *  TimeGraph II (TG-II) - Temporal Reasoning System *
 *                                                   *
 *  written by Alfonso Gerevini                      *
 *  IRST 38050 Povo Trento Italy                     *
 *  and                                              *
 *  Department of Computer Science                   *
 *  University of Rochester, 14627 Rochester, USA    *
 *                                                   *
 *  Email: gerevini@irst.it or                       *
 *         gerevini@cs.rochester.edu	             *
 *                                                   *
 *****************************************************

|#

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                            ;;
;;    DATA STRUCTURES AND GLOBAL VARIABLES    ;;
;;                                            ;; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package TG-II)


;; THE USER INTERVAL INTERFACE 
; the 13 atomic interval relations are represented by 
; bit-vector of size 24. Each item in the vector corresponds
; to a different point relations between endpoins of the intervals.
; Each block of six bits represents the following point relation:
; =,<,<=,>,>=,<>
; Bits 1-6 for relations between begin(I1) and begin(I2)
; Bits 7-12 for begin(I1) and end(I2)
; Bits 13-18 for end(I1) and end(I2)
; Bits 19-24 for end(I1) and begin(I2)
; Meanings:
;     =,E	equals 
;	D	during (proper)
;	Di	contains (proper)
;	S	starts
;	Si	started-by
;	F	finishes
;	Fi	finished-by
;     P,B	precedes (before)
;     A,P-	preceded-by (after)
;	M	meets
;	Mi	met-by
;	O	overlaps
;	Oi	overlapped-by
(defconstant P  #*011001011001011001011001)
(defconstant O  #*011001011001011001000111)
(defconstant F  #*000111011001101010000111)
(defconstant M  #*011001011001011001101010)
(defconstant D  #*000111011001011001000111)
(defconstant S  #*101010011001011001000111)
(defconstant =  #*101010011001101010000111)
(defconstant A  #*000111000111000111000111)
(defconstant Si #*101010011001000111000111)
(defconstant Oi #*000111011001000111000111)
(defconstant Fi #*011001011001101010000111)
(defconstant Mi #*000111101010000111000111)
(defconstant Di #*011001011001000111000111)
;; Standard names
(defconstant B  P)
(defconstant P- A)
(defconstant E  =)
(defconstant O- Oi)
(defconstant S- Si)
(defconstant F- Fi)
(defconstant M- Mi)
(defconstant D- Di)
(defconstant DURING D)

(defparameter *p-mode* t)

;; The size of bit-vector
(defconstant +vector-dimension+ 24)

;; the 187 pointizable Allen relations are stored in the hash table
;; (pointizable-relations-table) *prtab*

;; The 187 pointizable Allen relations are stored in *prtab*, a hash table.
;; The relations are read from a file pointed to by *table-file*
(defconstant +number-pointizable-relations+ 187)
(defparameter *prtab*
    (make-hash-table :size +number-pointizable-relations+))

(defmacro get-pr (pr)
  `(gethash ,pr *prtab*))

;; names of the atomic Allen's interval relations
(defconstant +atomic-allen-rels+ '(:= :e :d :di :d- :s :si :s- :f :fi :f- :p :b
                                   :a :p- :m :mi :m- :o :oi :o-))

(defconstant +names-atomic-allen-rel+ `((:= . ,=) 
					(:e . ,e) 
					(:d . ,d) 
					(:di . ,di)
					(:d- . ,d-) 
					(:s . ,s)
					(:si . ,s)
					(:s- . ,si)
					(:f . ,f)
					(:fi . ,fi)
					(:f- . ,f-)
					(:p . ,p)
					(:b . ,b)
					(:a . ,a)
					(:p- . ,p-)
					(:m . ,m)
					(:mi . ,mi)
					(:m- . ,m-)
					(:o . ,o)
					(:oi . ,oi)
					(:o- . ,o-)))

(defconstant +internal-names-atomic-allen-rel+ '((:= . =) 
						 (:e . e) 
						 (:d . d) 
						 (:di . di)
						 (:d- . d-) 
						 (:s . s)
						 (:si . s)
						 (:s- . si)
						 (:f . f)
						 (:fi . fi)
						 (:f- . f-)
						 (:p . p)
						 (:b . b)
						 (:a . a)
						 (:p- . p-)
						 (:m . m)
						 (:mi . mi)
						 (:m- . m-)
						 (:o . o)
						 (:oi . oi)
						 (:o- . o-)))

;; The hash table containing intervals and their endpoints
(defvar *itab* (make-hash-table :rehash-size 1.5))

(defmacro get-i (i)
  `(gethash ,i *itab*))

;; The counter used to generate unique names for timepoints
(defvar *counter* 1)

;; varaible containing the list of the stipulated interval relations
;; the variable is set to nil after having created the timegraph
(defvar *stipulated-relations* nil)

;; list of the intervals in the database
(defvar *intervals* nil)

;;; THE POINT USER INTERFACE 

;; tables for the user point interface
(defvar *point-integer-table* (make-hash-table :size 1000))
(defvar *integer-point-table* (make-hash-table :size 1000))

(defmacro pt->int (pt)
  `(gethash ,pt *point-integer-table*))

(defmacro int->pt (int)
  `(gethash ,int *integer-point-table*))

