;;; Copyright (C) 1994 by Istituto per la Ricerca Scientifica e Tecnologica 
;;; (IRST) (38050 Povo, Trento Italy) and the Trustees of the University 
;;; of Rochester (Rochester, NY 14627, USA).  All rights reserved.
;;; See the COPYRIGHT.TEXT file for more information

(in-package user)

;; Modify this for your local installation. 

(setf (logical-pathname-translations "tg-ii")
  (list
   (list "*.*" (parse-namestring 
		"/u/gerevini/lisp/tg-ii/ftp/public/*."))
   (list "**;*.*" (parse-namestring 
		   "/u/gerevini/lisp/tg-ii/ftp/public/**/*.*"))))

(defparameter *table-file* "tg-ii:pointizable-relations")

(defpackage :timegraph-II
  (:nicknames :tg-ii) 
  (:use common-lisp #+cl-lib cl-lib)
  (:export #:init-tg #:set-point-mode #:make-tg #:asserta #:assert-a 
	   #:assertpr #:assert-pr #:arel #:prel #:query-a #:query-pr
	   #:list-points #:less-or-equal #:less-than #:greater-or-equal 
	   #:greater-than #:equal-to #:not-equal-to #:not<=>prel 
	   #:print-chains #:print-tg #:print-chains-summary #:pointizable))

(defsystem :timegraph-II
    (:default-pathname "tg-ii:")
  #-cl-lib (:module cl-lib ("cl-lib-definitions"))
  (:module DEFS ("definitions")
           #-cl-lib
	   (:uses-definitions-from cl-lib))
  (:module TOP ("tg2")
	   (:uses-definitions-from DEFS))
  (:module UI-DEFS ("ui-defs")
           (:uses-definitions-from DEFS))
  (:module TIME-INTERVALS ("interval-interface")
	   (:uses-definitions-from DEFS UI-DEFS TOP))
  (:module TIME-POINTS ("point-interface")
	   (:uses-definitions-from DEFS UI-DEFS TOP)))


  





























