;;;;
;;;; Test domain for the projector
;;;;


(setf start-car
      (PROJECTOR:make-event :name 'start-car
			    :outcome-list
			    (list (PROJECTOR:make-outcome
				   :condition '(and have-gas battery-charged)
				   :effect 'car-running
				   :min-dur 1 :max-dur 3)
				  (PROJECTOR:make-outcome
				   :condition '(or (not have-gas) (not battery-charged))
				   :effect '(not car-running)
				   :min-dur 5 :max-dur 10))))


(setf drive-to-work
      (PROJECTOR:make-event :name 'drive-to-work
			    :outcome-list
			    (list (PROJECTOR:make-outcome
				   :condition '(and at-home car-running)
				   :effect '(and at-work (not at-home))
				   :min-dur 20 :max-dur 30)
				  (PROJECTOR:make-outcome
				   :condition '(or (not at-home) (not car-running))
				   :effect nil
				   :min-dur 0 :max-dur 0))))

(setf take-bus-to-work
      (PROJECTOR:make-event :name 'take-bus-to-work
			    :outcome-list
			    (list (PROJECTOR:make-outcome
				   :condition '(or have-bus-pass have-money)
				   :effect '(and at-work (not at-home))
				   :min-dur 40 :max-dur 60)
				  (PROJECTOR:make-outcome
				   :condition '(and (not have-bus-pass) (not have-money))
				   :effect nil
				   :min-dur 0 :max-dur 0))))

(setf stop-car
      (PROJECTOR:make-event :name 'stop-car
			    :outcome-list
			    (list (PROJECTOR:make-outcome
				   :condition T
				   :effect '(not car-running)
				   :min-dur 1 :max-dur 2))))

