;;; -*- Mode:Common-Lisp; Package:POS; Syntax:COMMON-LISP; Default-character-style:(FIX BOLD NORMAL); Base:10 -*-
;;; Copyright 1988 David Throop at the University of Texas at Austin
;;; X Windows additions by Kee Kimbrell Spring 1991
;;; Allegro CL additions by Mike Chien and Kee Kimbrell Summer 1991

;;; SYMBOLICS version of Machine Dependent Parameters.

(in-package :pos)

#+:ccl
(use-package :ccl :pos)

#+symbolics
(use-package :scl :pos)

#+symbolics
(import '(self send defmethod))


;;; This file is full of parameters and some functions that are specific to the particular
;;; host machine and terminal on which the output is diplayed.

;;; Although these functions are, generally, device dependent, the parameters in the front
;;; of this file are identical between their SYMBOLICS and EXPLORER versions.


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;  X-WINDOWS SPECIFIC CODE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

#+(or x-windows :pos-lispview)
(defparameter *window-number* 		0)

#+(or x-windows :pos-lispview)
(defparameter *thickness*		1)			; Global thicness of lines

#+(or x-windows :pos-lispview)
(defparameter *alu*			"black")		; Global color

#+(or x-windows :pos-lispview)
(defparameter *ps-file*			"ps.out")


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;  CCL SPECIFIC CODE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

#+:ccl
(defparameter *window-number* 		1)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;  COMMON CODE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defparameter *symbol-x-offset* 	-3)			; peculiar positional offsets to get
(defparameter *symbol-y-offset*         +4)                     ; symbols in the right place.
 
(defparameter xscreen
              #-:ccl 			1037.                   ; horizontal screen size
              #+:ccl                    633.)

(defparameter yscreen
              #-:ccl 			700.                    ; vertical screen size
              #+:ccl                    483.)

(defparameter bmargin                                           ; Size of margin at bottom of screen
              #+:ccl                    0.
              #-:ccl	                50.)		


(defparameter *black*	
              #+ti	                tv:alu-seta		; Drawing Black and White is at least on 3600's
              #+symbolics               1
              #+x-windows	 	"black"
              #+:ccl                    ccl::*black-pattern*
              #+:pos-lispview	 	"black"
              #-(or ti symbolics x-windows :pos-lispview :ccl) "black")

(defparameter *white* 
              #+ti               	tv:alu-andca		; implemented in hardware.
              #+symbolics               0
              #+x-windows		"white"
              #+:ccl                    ccl::*white-pattern*
              #+:pos-lispview	 	"white"
              #-(or ti symbolics x-windows :pos-lispview :ccl) "white")

(defparameter *gray-one*
              #+ti                      tv:alu-seta
              #+symbolics               0.1
              #+x-windows               "gray30"
              #+:ccl                    ccl::*dark-gray-pattern*
              #+:pos-lispview	 	"dimgray"
              #-(or ti symbolics x-windows :pos-lispview :ccl) "gray-one")

(defparameter *gray-two*
              #+ti                      tv:alu-seta
              #+symbolics               0.2
              #+x-windows               "gray30"
              #+:ccl                    ccl::*dark-gray-pattern*
              #+:pos-lispview	 	"dimgray"
              #-(or ti symbolics x-windows :pos-lispview :ccl) "gray-two")

(defparameter *gray-three*
              #+ti                      tv:alu-seta
              #+symbolics               0.3
              #+x-windows               "gray40"
              #+:ccl                    ccl::*dark-gray-pattern*
              #+:pos-lispview	 	"lightgray"
              #-(or ti symbolics x-windows :pos-lispview :ccl) "gray-three")

(defparameter *gray-four*
              #+ti                      tv:alu-seta
              #+symbolics               0.4
              #+x-windows               "gray40"
              #+:ccl                    ccl::*gray-pattern*
              #+:pos-lispview	 	"lightgray"
              #-(or ti symbolics x-windows :pos-lispview :ccl) "gray-four")

(defparameter *gray-five*
              #+ti                      tv:alu-seta
              #+symbolics               0.5
              #+x-windows               "gray50"
              #+:ccl                    ccl::*gray-pattern*
              #+:pos-lispview	 	"gray"
              #-(or ti symbolics x-windows :pos-lispview :ccl) "gray-five")

(defparameter *gray-six*
              #+ti                      tv:alu-seta
              #+symbolics               0.6
              #+x-windows               "gray60"
              #+:ccl                    ccl::*gray-pattern*
              #+:pos-lispview	 	"gray"
              #-(or ti symbolics x-windows :pos-lispview :ccl) "gray-six")

(defparameter *gray-seven*  
              #+ti                      tv:alu-seta
              #+symbolics               0.7
              #+x-windows               "gray70"
              #+:ccl                    ccl::*light-gray-pattern*
              #+:pos-lispview	 	"gray"
              #-(or ti symbolics x-windows :pos-lispview :ccl) "gray-seven")

(defparameter *gray-eight*
              #+ti                      tv:alu-seta
              #+symbolics               0.8
              #+x-windows               "gray80"
              #+:ccl                    ccl::*light-gray-pattern*
              #+:pos-lispview	 	"darkslategray"
              #-(or ti symbolics x-windows :pos-lispview :ccl) "gray-eight")

(defparameter *gray-nine*
              #+ti                      tv:alu-seta
              #+symbolics               0.9
              #+x-windows               "gray90"
              #+:ccl                    ccl::*light-gray-pattern*
              #+:pos-lispview	 	"darkslategray"
              #-(or ti symbolics x-windows :pos-lispview :ccl) "gray-nine")

(defparameter *gray-ten*
              #+ti                      tv:alu-seta
              #+symbolics               1.0
              #+x-windows               "gray100"
              #+:ccl                    ccl::*light-gray-pattern*
              #+:pos-lispview	 	"darkslategray"
              #-(or ti symbolics x-windows :pos-lispview :ccl) "gray-ten")
              

(defparameter *flip* 
              #+ti	                tv:alu-xor
              #+symbolics               1.0
              #+x-windows		"black"
              #+:ccl                    nil
              #+:pos-lispview	 	"black"
              #-(or ti symbolics x-windows :pos-lispview :ccl) "black")



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;  FONT CODE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Define some fonts for common-plotting styles

;;; Fonts, discussion in general.  Fonts on the symbolics are represented
;;; by a list in the following format: '(:type :style :size).  I have adopted
;;; this scheme to the x windows fonts also.  This is a poor way to deal with
;;; all the fonts that x windows provides, but this code has to run on several 
;;; platforms, not just x windows.  

(defparameter *axis-font*					; for labeling axis points
              #+symbolics 		'(:fix nil :small)	;   Symbolics version
              #+ti                      'fonts:tvfont		;   Explorer version
              #+x-windows		'(:fix nil :small)
              #+:ccl                    '(9 "Monaco")
              #-(or symbolics ti x-windows :ccl) '(:fix nil :small))

(defparameter axis-font					; for labeling axis points
              #+symbolics 		'(:fix nil :small)	;   Symbolics version
              #+ti                      'fonts:tvfont		;   Explorer version
              #+x-windows		'(:fix nil :small)
              #+:ccl                    '(9 "Monaco")
              #-(or symbolics ti x-windows :ccl) '(:fix nil :small))

(defparameter *label-font*					; for labeling individual plots
	      #+symbolics 		'(:fix :bold :large)	;   Symbolics version
              #+ti 			'fonts:medfnb		;   Explorer version
	      #+x-windows               '(:fix :bold :large)
              #+:ccl                    '(9 "Monaco" :bold)
              #-(or symbolics ti x-windows :ccl) '(:fix bold :large))

(defparameter label-font					; for labeling individual plots
	      #+symbolics 		'(:fix :bold :large)	;   Symbolics version
              #+ti 			'fonts:medfnb		;   Explorer version
	      #+x-windows               '(:fix :bold :large)
              #+:ccl                    '(9 "Monaco" :bold)
              #-(or symbolics ti x-windows :ccl) '(:fix :bold :large))

(defparameter *plain-font*
	     #+symbolics		'(nil nil nil)
	     #+ti			'fonts:cptfont
             #+x-windows                '(nil nil nil)
             #+:ccl                     '(12 "Helvetica")
             #-(or symbolics ti x-windows :ccl) '(nil nil nil))

(defparameter *dot-font*
	     #+symbolics		'(nil nil nil)
	     #+ti			'fonts:cptfont
             #+x-windows                '(nil nil nil)
             #+:ccl                     '(9 "Helvetica")
             #-(or symbolics ti x-windows :ccl) '(nil nil nil))

;;; Screen output stream (also set on initialization) in QPLOT-NEW-BEHAVIOR)

(defparameter *qplot-output*          *standard-output*)


(defparameter *axis-font-height*
	      #+symbolics (zl:font-char-height	               ; For Symbolics
			    (scl:with-character-style
			      (axis-font)
			      (send *qplot-output* :current-font)))
	      #+ti (tv:font-char-height (eval axis-font))      ; For TI Explorer
	      #-(or symbolics ti)  10)



;;; The next two funtions map the Symbolics fonts into Postscript fonts.

;;; Given a string, determine to what PostScript typeface it corresponds.  Do this by
;;; looking up the family and face in a large, nested CASE statement.  Then determine the
;;; size in another CASE statement.  If this is a new font, we will have to execute
;;; PostScript FINDFONT and SCALEFONT commands, (which is expensive, so we only want to do
;;; it once.)  Keep track of what fonts we have already seen as an Alist on *used-fonts*.
;;; Associate each new font with a GENTEMP atom in the Alist.  If the font has been seen
;;; before (if we find it when we look it up in *used-fonts*), check to see if it is the
;;; *current-font*.  If so, do nothing.  If not, tell PostScript to SETFONT to this font.

;;; The string may have font information on it, and it may be being merged against a
;;; character style.  Merge, then extract the style.  GET-FONT-FOR-STRING tolerates
;;; nonstrings for its string arg.


;;; MACL version of get-font-for-string simply uses Helvetica 10
;;; That solution is too weak for words and will have to be dealt with



#+:ccl
(defun get-font-for-string (string typeface)
  (declare (ignore string))
  (let* ((*print-case*     :upcase)
	 (font             (translate-typeface typeface))
	 (size             (size-translation typeface))
	 (pair             (list font size))
	 (familiar-font    (assoc pair *used-fonts* :test #'equal))	; ((:|Times-Bold| 18.) TIMES-BOLD-7)
	 (gatom            (if familiar-font		
		               (second familiar-font)
		               (gentemp (format nil "~:@(~a-~)" font)))))
;;;    (format t "font : ~a     size : ~d     pair : ~a     gatom :  ~a~%" font size pair gatom)
    (enforce-string font familiar-font size gatom pair)
    font))



#-:ccl
(defun get-font-for-string (string givfont)
  #-(or symbolics ti) (declare (ignore string))
  (let* ((typeface         #+(or symbolics ti) (si:char-style (char (merge-font-info givfont string) 0))
                           #-(or symbolics ti) givfont)
	 (*print-case*     :upcase)
	 (font             (translate-typeface typeface))
	 (size             #+(or symbolics ti) (size-translation (si:cs-size typeface))
                           #-(or symbolics ti) (size-translation (caddr typeface)))
	 (pair             (list font size))
	 (familiar-font    (assoc pair *used-fonts* :test #'equal))	; ((:|Times-Bold| 18.) TIMES-BOLD-7)
	 (gatom            (if familiar-font		
		               (second familiar-font)
		               (gentemp (format nil "~:@(~a-~)" font)))))
;;;    (format t "font : ~a     size : ~d     pair : ~a     gatom :  ~a~%" font size pair gatom)
    (enforce-string font familiar-font size gatom pair)
    font))



#-:ccl
(defun translate-typeface (typeface)
  (case #+(or symbolics ti) (si:cs-family typeface)
        #-(or symbolics ti) (car typeface)
    (:swiss    (case #+(or symbolics ti) (si:cs-face typeface)
                     #-(or symbolics ti) (cadr typeface)
	                  (:italic       :|Helvetica-Oblique|)
	                  (:bold         :|Helvetica-Bold|)
	                  (:bold-italic  :|Helvetica-BoldOblique|)
	                  (t             :|Helvetica|)))
    (:fix      (case #+(or symbolics ti) (si:cs-face typeface)
                     #-(or symbolics ti) (cadr typeface)
	                  (:italic       :|Courier-Oblique|)
	                  (:bold         :|Courier-Bold|)
	                  (:bold-italic  :|Courier-BoldOblique|)
	                  (t             :|Courier|)))
    (t         (case #+(or symbolics ti) (si:cs-face typeface)
                     #-(or symbolics ti) (cadr typeface)
	                  (:italic       :|Times-Italic|)
	                  (:bold         :|Times-Bold|)
	                  (:bold-italic  :|Times-BoldItalic|)
	                  (t             :|Times-Roman|)))))


#+:ccl
(defun translate-typeface (typeface)
       (cond ((member "Helvetica" typeface :test #'equalp)
              (cond ((and (member :bold typeface) 
                          (member :italic typeface))  :|Helvetica-BoldOblique|)
                    ((member :italic typeface)        :|Helvetica-Oblique|)
                    ((member :bold   typeface)        :|Helvetica-Bold|)
                    (t                                :|Helvetica|)))
             ((member "Courier" typeface :test #'equalp)
              (cond ((and (member :bold typeface)
                          (member :italic typeface))  :|Courier-BoldOblique|)
                    ((member :italic typeface)        :|Courier-Oblique|)
                    ((member :bold   typeface)        :|Courier-Bold|)
                    (t                                :|Courier|)))
             (t (cond ((and (member :bold typeface)
                            (member :italic typeface))  :|Times-BoldItalic|)
                      ((member :italic typeface)        :|Times-Italic|)
                      ((member :bold   typeface)        :|Times-Bold|)
                      (t                                :|Times-Roman|))) )) 

  



;;; SIZE-TRANSLATION is the function which, when given a Symbolics font
;;; size, maps it into a PostScript point size.  It uses the alist
;;; *SIZE-TRANSLATIONS* so that the mapping can be changed just by
;;; changing *SIZE-TRANSLATIONS*'s binding.

#|
#+:ccl
(defun size-translation (cs-size)
  (case cs-size
    (:tiny             5)
    (:very-small       7)
    ((:smaller :small) 10)
    ((nil :normal)     14)
    ((:large larger)   18)
    (:very-large       24)
    (t                 12)))
|#

#+:ccl
(defun size-translation (typeface)
       (cond ((null typeface)            12)
             ((numberp (car typeface))   (car typeface))
             (t                          (size-translation (cdr typeface)))))

#-:ccl
(defparameter *size-translations*
	      '((:tiny          7)
		(:very-small    9)
		(:smaller       10)
		(:small         10)
		(nil            12)
		(:normal        14)
		(:large         18)
		(:larger        18)
		(:very-large    24)))

#-:ccl
(defun size-translation (cs-size)
       (or (cadr (assoc cs-size  *size-translations*)) 12))



;;; For architectures that support different fonts, merge them into the string.

#-:ccl
(defun merge-font-info (font-info char)
  #-symbolics (declare (ignore font-info))
  #+symbolics  (format nil "~v~a~" font-info char)
  #-symbolics  (typecase char
		 (string         char)
		 (character      (string char))
		 (t              (format nil "~a" char))))



;;;  For the purposes of migration to a non-Symbolics platform, you just
;;; want TYPEFACE in GET-FONT-FOR-STRING to be the same as GIVFONT.  (By way
;;; of explanation:  Symbolics LISP has this strange characteristic, that
;;; each character in a string can have font information stored in it (so
;;; you can have a string with mixed boldface and normal and italic
;;; characters, for instance).  These fonts can be merged against another
;;; font style, (so that a mixture of bold and italic fonts could be merged
;;; against a font specifier and come out as LARGE mixed bold and italic.)
;;; That is what MERGE-FONT-INFO is doing.)

;;;   *PRINT-CASE* being :upcase assures that the font specifier, written in
;;; the .ps file, will be written in the correct case.  That is, you want
;;; the type specifier in the .ps file to be "Times-Roman", not
;;; "times-roman".  (*Print-Case* is CommonLisp, tho obscure.)   You should
;;; basically be able to ignore this.

;;;   Any font on the screen must be translated to some postscript font,
;;; in some particular point size.  In Symbolics, a typeface is a list
;;; of three elements; the first naming the font family, the second
;;; naming the face (bold and or italic) and the third the size.  The
;;; function TRANSLATE-TYPEFACE maps the family and face into a single
;;; postscript font.  The function SIZE-TRANSLATION maps the Symbolics
;;; size into a Postscript pointsize.  You will have to reimplement
;;; GET-FONT-FOR-STRING so that it takes a font specification from your
;;; LISP dialect (whatever that looks like) and translates that into a
;;; postscript font and pointsize, corresponding to the variables FONT
;;; and SIZE in GET-FONT-FOR-STRING.

;;; Once you have found the font and size translation for a particular
;;; string, (call this the current-font) several other things must be
;;; checked.  If the last string written in the .ps file was also written in
;;; current-font, then nothing about fonts has to be written to the .ps
;;; file.  If current-font has been used in the .ps file previously, but
;;; some other font was the last font used, directions must be written that
;;; switch the laser printer back to using current-font.  And if
;;; current-font has not yet been used in the .ps document, the font must be
;;; loaded and named, and the laser printer must be told to start using it.
;;; All of this work is performed by ENFORCE-STRING, using the record of
;;; what fonts have been loaded (and what they've been named in PostScript)
;;; stored in *USED-FONTS*.

;;;   You should not need to change anything in ENFORCE-STRING; however,
;;; whatever code you write for GET-FONT-FOR-STRING should still call it.



(defun strip-font-info (string)
       #+symbolics (si:change-string-character-style	; Strip off the character info.
	            string '(nil nil nil))
       #-symbolics string)



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;  SYMBOLICS SPECIFIC CODE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;  The way that a screen should be cleared at the beginning of an image is device
;;;  dependent.

#+(or symbolics ti)
(defmethod (:new-behavior dw::dynamic-lisp-listener)
	   ()
           (send self :clear-history))


#+(or symbolics ti)
(defmethod (:new-behavior tv:lisp-listener)
	   ()
           (send self :clear-window))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;  TI SPECIFIC CODE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; See the file ti-machine-params.lisp for this code.

