;;; -*- Mode:Common-Lisp; Package:User; Base:10 -*-
;;;     Copyright 1987, Benjamin Kuipers
;;;   $Id: ti-nq-system.lisp,v 1.20 92/07/20 12:18:26 bert Exp $

;;;     Adapted from Southern-Select:>nq>nq-system.lisp for use with TI Explorer
;;;	by Rich Mallory (RM) 20 Oct 89.  Differences between TI and Symbolics 
;;;	defsystem functions are sufficient to require separate files.
;;;	Symbolics functions or options unavailable on TI have been commented out.

;;; 27 Sep 90.  Added module exports, and file qsim-exports. - Adam Farquhar.

(in-package 'User)

;; Pos cannot be included below in defsystem.  See note below.
;; Load the POS system definition (including the def of the POS package)
;; if not yet loaded.

(unless (si:find-system 'pos)  ; Menu if more than one system name containing "POS"
  (load "sys:site;xpos.translations")
  (load "sys:site;xpos.system")
  (make-system 'xpos :nowarn :compile :no-increment-patch))



;; Set up logical device NQ with logical directories for code and examples.
;; Repeats nq:nq;nq.translations here in case sys:site; is broken.

; (unless (fs:get-pathname-host "NQ" t) ...	; Always do, in case changed.
(fs:set-logical-pathname-host "NQ"
  :physical-host "ai"
; :no-search-for-shadowed-physical t	; no host named "NQ"
  :translations '(("nq"		 "/v/ai/v5/qr/nq/source/main/")
		  ("patch"	 "/v/ai/v5/qr/nq/source/patch/")
		  ("examples"	 "/v/ai/v5/qr/nq/source/examples/")
		  ("catalogs"	 "/v/ai/v5/qr/nq/source/catalogs/")
		  ("text"	 "/v/ai/v5/qr/nq/source/text/")
		  ("experiments" "/v/ai/v5/qr/nq/source/experiments/")
		  ("interface"   "/v/ai/v5/qr/nq/source/interface/")
		  ("cc"		 "/v/ai/v5/qr/nq/source/cc/") 
		  ("ps"		 "/v/ai/v5/qr/nq/source/postscript/")
		  ("nq-bin"      "/v/ai/v5/qr/nq/bins/exp-bin/")))

; Q is written in Common Lisp, with device-dependencies limited to a few files.
; The code is in the QSIM package.

(defpackage QSIM
  (:use cl)				; Inherit from pure CommonLisp
  (:import send	self defmethod		; Use scl:send & scl:self in device-dependent code
           q))				; Make (q) visible to cl-user


;;; Import plotting functions from POS.

(if (si:find-system 'pos)
    (import pos:*exports* 'qsim))

						
;;; Import some menu functions to QSIM.

(import '(tv:choose-variable-values w:menu-choose)
        'qsim)


;;; Notes to the user.

(format t "~%If you use the :defaulted-batch option, compiler warnings for~@
	     system NQ will be written to the file nq:nq;cwarns.lisp.")


;;; There are a few order-dependencies in compiling and loading.

(defsystem NQ
  (:name "NQ: The New QSIM")
  (:short-name "NQ")
  (:pathname-default "NQ:nq;")
  (:default-output-directory "NQ:nq-bin;")
  (:patchable nil)
; (:patchable "NQ:q-patch;" patch)	; RM
  (:nicknames ("QSIM"))
  (:package qsim)
  (:initial-status :experimental)
  (:output-version :higher)
  (:serial t)
  ;; (make-system ... :defaulted-batch) puts compiler warnings database
  ;; here, in file cwarns.lisp:
  (:warnings-pathname-default "NQ:nq;")
  
  ;; Component system POS for plotting on screen, Postscript.
  ;; The ":component-systems" clause does not work as expected,
  ;; so the "make-system" form is included above.
; (:module pos (pos) (:type :system))

  ;; The modules that make-up QSIM require compiling and loading in
  ;; the order shown:

  ;; Compile and load these first (serially):
  (:module QDEFS	("qdefs"
			 "interface;plotting-constants"))	; Definitions
  (:module QUTILS	 "qutils")		; Utilities
  (:module DYNAMIC-SLOTS "dynamic-slots")	; Modify structures
  (:module STRUCTURES	 "structures")		; QDE and STATE
  (:module DEFOTHERS	 "defothers")		; Dynamic slots for structures
; (:module PROLOG-PKG    "prolog-package")	; Moved to package Qsim
  (:module PROLOG        "prolog")

  (:module CORE
    ("define-qde"			; Convert QDE input to internal form
     "cfilter"				; Basic QSIM filtering algorithm
     "constraints"			; Definition of QSIM constraints
     "qspace-hierarchy"			; Shared qspaces and the = constraint
     "propagation"			; Propagating partial to complete state
     "states"				; Simulating successor states
     "global-filters"			; Filter predicted states
     "transitions"
     ))

  (:module QGRAPH     ; BKay 25Sep91
   ("interface;qsim-to-qgraph"))        ; Extract qsim structs for qgraph

  (:module QPLOT
    ("interface;qplot"			; Top level calls and some user query
     "interface;allocations"		; Allocating space within the plots
     "interface;time-plot"		; Standard qsim plotting routine
     "interface;numeric-plot"           ; Plot numeric data using qgraph
     "interface;examine"		; Debugging examination and display tools
     "interface;special-displays"	; Macros for producing .ps plots for latex
     "interface;versiplot"		;  more, better of same
     "interface;tables"))		; Tabular, rather than graphical, printing
  
  (:module FRONT-END
    ("front-end"			; Menus of examples (device dependent)
     "syntax"))				; Gives warnings of malformed DEFINED-QDEs
  (:module HQ-PLOT   "hq-plot")		; Plot hierarchical behaviors
  (:module VIEWERS
     ("interface;viewers-clisp-2"	; View one variable across behaviors
      "interface;viewers-misc"		; Plot phase diagrams across behaviors
      "interface;viewers-clisp"))	; Extras
    

  ;; Added BKay 1Oct91
  ;; The order of file compiling and loading on the explorer is not supposed
  ;; to be depended upon (although it looks like reverse order) so
  ;; these are files that need to be loaded before the rest.
  (:module EXTENSIONS-MACROS
    ("equations"			; Q2 equation generation
     "rk45s"                            ; Nsim 4th order Runge-Kutta simulator
     ))

  (:module EXTENSIONS
    ("time-scale"			; Time-scale abstraction
     "hod-derivation"			; Curvature constraint
     "ncurvature"			;  "
     "qmatch"				;  "
     "hod-system-property"
     ;; Intervals.lisp replaced by arithmetic, equations, and q2.
     "arithmetic"			; Interval arithmetic routines
     "q2"				; Q2 interval propagator
     "nic"				; Non-intersection constraint
     "energy-gf"			; Energy-based global filter
     "interface;comparison"
     "occ-branch-elimination"           ; Code to eliminate occurrence branching
     "focusing-techniques.lisp"		; Focusing Techniques for envisionment graphs
     "numeric-eqn-gen"
     "nsim-interval"                    ; Nsim simulator
     "nsim-init"                        ; Nsim extremal equation generator
     "xedge"                            ; Cross edge envisionment code  DJC
     "envision-guide-filter"            ; Filter to perform envisionment guided
			                ; simulation.
     ))

  (:module EXAMPLES			; Read but not compiled
   ("catalogs;examples"			; (device dependent)
    "catalogs;tsa"
    "catalogs;extras"
    "catalogs;chatter4"
    "catalogs;chatter3"
    "catalogs;chatter2"
    "catalogs;chatter1"
    "catalogs;q-features"
    "cc;cc-catalog"))

  (:module COVER ("cover-page.text"))
  (:module CC1 ("cc;definitions"))
  (:module CC2 ("cc;functions"))
  (:module CC-DEFS ("cc;hydraulic"
		    "cc;electrical")) 

  (:module EXPORTS
	  ("qsim-exports"))
  (:module USER-INTERFACE
	   ("ti-user-interface"))

#|
  (:serial
;   pos				; Loaded above
    qdefs qutils dynamic-slots structures defothers
    core qplot front-end hq-plot viewers
    interface
    extensions
;   experiments
    examples			; Load examples last
    cc1 cc2
    )
|#


;;; Modules must be loaded in the following order with stated dependencies satisfied.

; (:readfile PROLOG-PKG)
  (:compile-load QDEFS)
  (:compile-load-init QUTILS	    (qdefs))
  ;; Not used yet, and current file has a reference to an SCL: function
  (:compile-load-init DYNAMIC-SLOTS (qdefs qutils))
  ;; Structures use dynamic-slots ###BK
  (:compile-load-init STRUCTURES    (qdefs qutils dynamic-slots))
  (:compile-load-init DEFOTHERS	    (qdefs qutils dynamic-slots structures))
  (:compile-load-init PROLOG        (qdefs qutils))
  (:compile-load-init CORE	    (qdefs qutils structures defothers))
  ;; BKay 25Sep91
  (:compile-load-init QGRAPH        (qdefs qutils structures defothers))
  (:compile-load-init QPLOT	    (qdefs qutils structures defothers qgraph))
  (:compile-load-init FRONT-END	    (qplot))
  (:compile-load-init HQ-PLOT	    (qdefs qutils structures defothers))
  (:compile-load-init VIEWERS	    (qplot))
  (:compile-load-init EXTENSIONS-MACROS (qdefs qutils structures defothers core))
  (:compile-load-init EXTENSIONS    (qdefs qutils structures defothers core
				     extensions-macros))
; (:compile-load-init EXPERIMENTS   (qdefs qutils structures defothers core))
  (:readfile EXAMPLES)
  (:compile-load-init CC1	    (qdefs qutils structures defothers core))
  (:compile-load-init CC2	    (qdefs qutils structures defothers core cc1))
;  (:compile-load-init CC3	    (qdefs qutils structures defothers core cc1 cc2))
  (:compile-load-init EXPORTS       (qdefs qutils structures defothers core))
  (:readfile CC-DEFS)
  (:readfile USER-INTERFACE)
  )

; Keep track of version

(defparameter qsim::*system* "NQ")
(defparameter qsim::*cover-page-file* "NQ:nq;cover-page.text")
(defparameter qsim::*package-for-examples* 'qsim)	; Load into this package.

(pkg-goto 'qsim)


; To Migrate NQ to Q: 
;   - delete the experiments :module
;	     any references to files in the experiments directory
;	     the reference to the experiments module from the :serial clause
;   - Replace String "nq" "q"
;   - Replace String "Pos" "Pos"
;   - set :physical-host to Schepps
;   - set :initial-status to :released
;   - write to sys:site;q.system
; Remember also to migrate POS to POS.  See "POS:POS;System.lisp"
;
; IMPORTANT:  Send me (Kuipers @ CS.UTexas.edu) your net address and US Mail
;             address if you acquire QSIM by FTP, so I can keep track of who
;             has what version of QSIM.  

