;;; -*- Mode:Common-Lisp; Package:User; Syntax:Common-Lisp; Base:10 -*-
;       Copyright 1987, Benjamin Kuipers

(in-package 'User)

; Set up logical device NQ with logical directories for code and
; examples.  Any changes to these pathname translations should also be
; made in sys:site;nq.translations.

(unless (fs:get-logical-pathname-host "NQ" t)
  (fs:set-logical-pathname-host "NQ"
     :physical-host "Select"
     :no-search-for-shadowed-physical t		; no host named "NQ"
     :translations '(("nq;"          "/v/ai/v5/qr/nq/source/main/")
		     ("nq; patch;"   "shiner:>scratch>")
		     ("examples;"    "/v/ai/v5/qr/nq/source/examples/")
		     ("catalogs;"    "/v/ai/v5/qr/nq/source/catalogs/")
		     ("text;"	     "/v/ai/v5/qr/nq/source/text/")
		     ("experiments;" "/v/ai/v5/qr/nq/source/experiments/")
		     ("interface;"   "/v/ai/v5/qr/nq/source/interface/")
		     ("cc;"          "/v/ai/v5/qr/nq/source/cc/")
		     ("c-code;"	     "/v/ai/v5/qr/nq/source/c-code/")
		     ("ps;"          "/v/ai/v5/qr/nq/source/postscript/"))))

; Q is written in CommonLisp, with device-dependencies limited to a few files.
; The code is in the QSIM package.

;; Load the XPOS system definition (including the def of the XPOS package)
;; if not yet loaded.

(unless (pkg-find-package 'pos :find)
  (load "sys:site;xpos.system")
  (load "xpos:xpos;xpos-system.lisp"))

(defpackage :qsim
  (:use cl)					; inherit from pure Common Lisp
  (:import send	self defmethod)			; use scl:send & scl:self
						; in device-dependent code
  )
						
;; Make the plotting functions available without the POS: prefix.
(import pos:*exports* ':qsim)

;;; Import some menu functions to the QSIM package.

#+lispm
(import #+symbolics
        '(tv:choose-variable-values tv:menu-choose)
        #+ti   '(tv:choose-variable-values w:menu-choose)
        :qsim)

; There are a few order-dependencies in compiling and loading.

(defsystem NQ
    (:pretty-name "NQ: The new QSIM"
     :short-name "NQ"
     :default-pathname "NQ:nq;"
     :default-package :qsim
     :before-patches-initializations
     (if (or (equal (pkg-find-package ':qsim) *package*)
	     (y-or-n-p "Set Package QSIM?  "))
	 (zl:pkg-goto ':qsim))
     :initial-status :experimental)

  ;; Component system XPOS for plotting on screen, Postscript.
  (:module xpos (xpos)(:type :system))

  (:module-group defs				; Compile and load these first.
   (:serial
     "qdefs"					; Definitions
     "qutils"					; Utility functions & macros
     "dynamic-slots"				; Dynamic slots code
     "structures"				; Defines QDE and STATE
     "defothers"				; Dynamic slots for structures
     ))

  (:module-group prolog
   (:serial
;     "prolog-package"				; Definition of package prolog
         ; moved to package QSIM
     "prolog"))					; Prolog interpreter
   
  (:module-group core
   (:parallel
     "define-qde"				; Convert QDE input to internal form
     "cfilter"					; Basic QSIM filtering algorithm
     "constraints"				; Definition of QSIM constraints
     "qspace-hierarchy"				; Shared qspaces and the = constraint
     "propagation"				; Propagating partial to complete state
     "states"					; Simulating successor states
     "global-filters"				; Filter predicted states
     "transitions"
     ))

  (:module-group interface
   (:serial
     "interface;plotting-constants"		; All of the Defparameters
     "interface;qplot"				; Top level calls and some user query
     "interface;allocations"			; Allocating space within plots
     "interface;time-plot"			; Standard qsim plotting routine
     "interface;qsim-to-qgraph"                 ; Extract qsim structs for use by qgraph
     "interface;numeric-plot"                   ; Plot numeric data using qgraph
     "interface;examine"			; Debugging examination and display tools
     "interface;special-displays"		; Macros for producing .ps plots for latex
     "interface;versiplot"			;  more, better of same
     "interface;tables"				; Tabular, rather than graphical, printing
     "front-end"				; Menus of examples (device dependent)
     "hq-plot"					; Plot hierarchical behaviors
     "interface;viewers-clisp-2"		; View one variable across behaviors
     "interface;viewers-misc"			; Plot phase diagrams across behaviors
     "interface;viewers-clisp"			; Extras
     "syntax"					; Warn of malformed Define-QDEs
     ))

;  (:module extra-code
;	  ("interface;diminished-qplot-primitives"	; Code that does not use
;							; POS, the PostScript system.
;	   "TI-XQ-System")			; Variant system definition for TI Explorer
;	  (:type :lisp-example))

  (:module-group extensions
   (:serial
     "time-scale"				; Time-scale abstraction
     "Hod-derivation"				; Curvature constraint
     "ncurvature"				;  "
     "qmatch"					;  "
     "hod-system-property"
     ; INTERVALS.lisp replaced by:  arithmetic, equations, q2.
     "arithmetic"				; Interval arithmetic routines
     "equations"				; Q2 equation generation
     "q2"					; Q2 interval propagator
     "nic"					; Non-intersection constraint
     "energy-gf"				; Energy-based global filter
     "interface;comparison"			; Compare examples' behaviors after changing code
     "occ-branch-elimination"                   ; Elimination of occurrence branching
     "focusing-techniques"                      ; Focuses on behaviors of interest
     "rk45s"                                    ; 4th order Runge-Kutta simulator
     "numeric-eqn-gen"
     "numsim"                                   ; simulate an ODE instance of a QDE
     "nsim-interval"                            ; Nsim simulator
     "nsim-init"                                ; Nsim extremal equation generator
     ))
;
;  (:module-group experiments
;   (:parallel
;     "experiments;dkb-states"			; +0- semantics
;     "experiments;envisionment"		; Total envisionment
;     "experiments;state-completions"		; Display [.]* state descriptions
;     ))

  (:module examples
   ("catalogs;examples"				; (device dependent)
    "catalogs;tsa"
    "catalogs;extras"
    "catalogs;chatter4"
    "catalogs;chatter3"
    "catalogs;chatter2"
    "catalogs;chatter1"
    "catalogs;q-features")
   (:type :lisp-read-only))			; Read but not compiled

  (:module-group cc
   (:serial
     "cc;definitions"
     "cc;functions"
     "cc;cc-examples"
     ))
  (:module cc-defs
   ("cc;component-definitions")
   (:type :lisp-read-only))

  (:module cover ("cover-page.text")
	   (:type :text))

  (:serial xpos defs prolog core
	   qgraph
	   interface
	   extensions
	;  experiments
	   examples				; Load examples last
	   cc
	   cc-defs
	   "qsim-exports"
	   )
  )

; Keep track of version

(defparameter qsim::*system* "NQ")
(defparameter qsim::*cover-page-file* "NQ:nq;cover-page.text")
(defparameter qsim::*package-for-examples* :qsim)	; Load into this package

;;; The files matched by these pathnames are compared to the defsystem
;;; form in order to spot trash.

(defparameter qsim::*paths-for-NQ-system-files*
	      '("nq:nq;*.lisp.newest"		; The LISP files that run NQ.
		"nq:nq;*.text.newest"		; The herald notice, with copyright info etc.
		"nq:catalogs;*.lisp.newest"	; The catalogs pointing to the examples.
		"nq:interface;*.lisp.newest"))	; Interface files, mainly displays.


(defparameter qsim::*paths-for-dumping-NQ*
	      `(,@qsim::*paths-for-NQ-system-files*
		"sys:site;nq.system.newest"		; The definition of the NQ system.
		"sys:site;nq.translations.newest"	; Definition of the logical host NQ.
		"nq:examples;*.lisp.newest"		; The Examples.lisp file (which puts the
							;  examples and their initializations
							;  into catlogs) plus the examples themselves.
		"nq:c-code;*.*.newest"			; The C version of QSIM.
		"nq:cc;*.lisp.newest"			; Component Connection files

		"sys:site;xpos.system.newest"	; The Postscript subsystem.
		"sys:site;xpos.translations.newest"
		"xpos:xpos;*.lisp.newest"))

; To Migrate NQ to Q: 
;   - make sure that the TI version of NQ (in ti-nq-system.lisp) is up to date.
;   - run a complete compilation (compile everything) on a freshly booted 
;     machine.  Fix any errors whatsoever.  Repeat on an Explorer.
; Make the following changes in both the Symbolics and TI system files:
;   - delete the experiments :module
;	     any references to files in the experiments directory
;	     the reference to the experiments module from the :serial clause
;   - if any new subdirectories have been added, and if these new subdirectories  
;     are used by the system definition), update logical pathnames definitions:
;     > in this file
;     > in ti-nq-system.lisp
;     > in sys:site;nq.translations and sys:site;q.translations (in 
;       lonestar:>sys>site>)
;     > in the TI sys:site; nq.translations and sys:site;q.translations
;        (in Genevieve:site;)
;     > and update *paths-for-dumping-NQ* in this file.
;   - Replace String "nq" "q"
;   - Replace String "Xpos" "Pos"
;   - set :physical-host to Schepps
;   - set :initial-status to :released
;   - write changes to q:q;q-system.lisp and q:q;ti-q-system.lisp
;   - Update revision date in Cover-Page.Text
; Remember also to migrate XPOS to POS.  See "XPOS:XPOS;System.lisp"
;
; IMPORTANT:  Send me (Kuipers @ CS.UTexas.edu) your net address and US Mail
;             address if you acquire QSIM by FTP, so I can keep track of who
;             has what version of QSIM.  

