;;; -*- Mode:Common-Lisp; Package:qsim; Base:10 -*-
;;;  $Id: qmatch.lisp,v 1.3 91/09/05 12:23:24 clancy Exp $

(in-package :qsim) ;changed DJC

; This file is a subset of >all>amatch.lisp, to support algebra.lisp.

; Recursive MATCH, based on the Abelson & Sussman matcher, with
; prolog-like variables matching a single subexpression.
; It returns an alist of variable bindings.
;  - explicit FAILED returned on failure; NIL means success with no bindings.

(defun MATCH (pat dat &optional alist)
  (cond ((eql alist 'failed) 'failed)
	((variable? pat) (check+update-binding pat dat alist))
	((atom pat) (cond ((eql pat dat) alist)
			  (t 'failed)))
	((atom dat) 'failed)
	(t (match (cdr pat)
		  (cdr dat)
		  (match (car pat) (car dat) alist)))))

; Variables are atoms with first character "_" or "?".

(defun variable? (pat)
  (and (symbolp pat)
       (or (string= pat "_" :end1 1)
	   (string= pat "?" :end1 1))))

; Add a binding (<variable> <value>) to an alist.
;  If <variable> already has a binding, it must be the same.

(defun check+update-binding (pat dat alist)
  (let ((binding (assoc pat alist)))
    (cond ((null binding) (cons (list pat dat)
				alist))
	  (t (match dat (cadr binding) alist)))))

; Use the bindings in <alist> to substitute values for variables in <exp>.

(defun substitute-bindings (exp alist)
  (cond ((variable? exp) (let ((binding (assoc exp alist)))
			   (cond ((null binding) exp)
				 (t (substitute-bindings (cadr binding) alist)))))
	((listp exp) (mapcar #'(lambda (term)
				 (substitute-bindings term alist))
			     exp))
	(t exp))
  )

; Since an alist may have chains of variables bound to other variables,
; keep looking until we get a value that's not a variable.
;  =>  obsolete?

(defun lookup* (key alist)
  (let ((value (cadr (assoc key alist))))
    (cond ((null value) key)
	  ((variable? value) (lookup* value alist))
	  (t value))))
