;;; -*- Mode:Common-Lisp; Package:QSIM; Base:10 -*-
;;;  $Id: qdefs.lisp,v 1.20 92/07/06 12:23:11 clancy Exp $

;;; Copyright (c) 1986 by Benjamin Kuipers.

(in-package 'QSIM)

;;;-----------------------------------------------------------------------------
;;;  QDEFS
;;;
;;;  Global storage of useful values.
;;;-----------------------------------------------------------------------------

(defparameter *current-sim* nil			"Current SIM structure")
(defparameter *initial-state* nil		"Initial state of the current simulation")
(defparameter *reference-states* nil		"Reference states for qsim-display")
(defparameter *initial-state-stack* nil         "A stack of the initial states from models run")
(defparameter *short-lmark-abbrev* t)


;;; Control values

;;; From states.lisp

(defparameter *pause-before-simulating* nil	"Pause on each loop of Qsim")
(defparameter *print-timing* t			"Print time trace")
(defparameter *propagate-first* t		"When creating an initial state")
(defparameter *automatic-completion*            "Controls whether make-new-states performs completion")
(defparameter *ask-about-multiple-completions* nil	"Ask about multiple completions")
(defparameter *check-for-unreachable-values* t)
(defparameter *state-limit* 20.			"Max number of states to generate")
(defparameter *time-limit* nil			"Max time point (eg 't5); Nil = no time limit")
(defparameter *current-time-limit* nil		"Time  limit used by q-continue")
(defparameter *current-state-limit* nil		"State limit used by q-continue")
(defparameter *show-inconsistent-successors* nil  
  "Show inconsistent successors when accessing state.successors")     ;  28 Feb DJC
(defparameter *fire-transitions* :all		"Fire :all, :first, :unique, or :none")
; Made into a local var BKay 29May92
;(defparameter *current-qde* nil
;  "QDE of current state; currently used by EQUAL constraint.")
(defparameter *known-qdes* nil			"List of names of qdes loaded")

(defparameter *simulation-type* :breadth-first  "The type of simulation to be performed")
(defparameter *envisionment* nil		"Perform envisionment")
(defparameter *states* nil			"List of all states")
(defparameter *check-level* nil
  "If T, checks whether a state belongs to *abstraction-level* in GET-SUCCESSORS and GET-PREDECESSORS")
(defparameter *develop-graph* nil
  "Controls whether the graph is developed.  Used only in envisionment")


;;;  For Cross-edge envisionment

(defparameter *xedge-state-table* nil
  "Hash table for states when using the Cross edge code")
(defparameter *cross-edge-envisionment* nil
  "Perform Cross edge envisionment")
(defparameter *traverse-xedges* nil 
  "Causes successor-states to traverse the
   cross edge links when finding the successors
   of a state.")


(defparameter *display-abstractions* nil	"If T, most abstract states are used")
(defparameter *abstraction-level* 0		"Level of abstraction")
(defparameter *current-display-block* nil        "Display Block for the current simulation")

;;; From global-filters.lisp

(defparameter *check-for-inconsistent-IGN* t		"Apply global filter")
(defparameter *check-for-cycles* :strong
  "Check for cycle: nil, :weak, :normal, or :strong ")
(defparameter *prune-uncompletable-transitions* t)
(defparameter *analytic-functions-only* nil		"Constant over interval --> constant everywhere")
(defparameter *compute-stability-label* nil)	; simulate to classify quiescent state.
(defparameter *trace-stability-test* nil)
(defparameter *stability-state-limit* 2)        ; how far to simulate to test stability.

;;; Landmark creation

(defparameter *enable-landmark-creation* t)		; To allow global enable/disable
(defparameter *new-landmarks-on-transition* t)		; Create landmark values
(defparameter *new-landmarks-at-initial-state* t)	; Create landmark values
(defparameter *new-landmarks-across-M-constraints* nil)
;(defparameter *new-landmarks-from-critical-values* t)	; Not used
(defparameter *create-landmarks-at-critical-values* t)		; Used by make-new-landmarks
(defparameter *always-create-landmarks-at-critical-values* nil)	; Used by make-new-landmarks
(defparameter *always-create-landmarks* nil		"New landmarks at all time-points")

(defparameter *enable-intervals-in-cvalues* nil		"Allow intervals in CV tuples")

; Setting this to T seems to result in pruning quiescent states, at least for 
; the bathtub. DB 8/13/90
(defparameter *quiescent-ok-for-agenda* nil) 


;;; Trace switches

(defparameter *trace-count* nil)
(defparameter *trace-tuples* nil)
(defparameter *trace-constraint-filter* nil)
(defparameter *trace-mult-constraint* nil)
(defparameter *trace-main-agenda* nil)
(defparameter trace-propagation nil)
(defparameter trace-propagation-result nil)
(defparameter *trace-deletion-of-infinite-values* nil)
(defparameter *trace-simulation-stop* t)

;;; This trace switch controls messages related to compilation
;;; of envelope functions in define-qde, and ODE systems in
;;; nsim and numsim.  BKay 27May92
(defparameter *trace-compilation-of-functions* t)


;;; Trace global filters

;(defparameter *trace-global-filters* nil)		; No longer needed 
(defparameter *trace-time-label* nil)
(defparameter *trace-new-landmarks* nil)
(defparameter *trace-transitions* nil)
(defparameter *trace-corresponding-values* nil)
(defparameter *trace-no-change* nil)
(defparameter *trace-pruning* nil)
(defparameter *trace-quiescence* nil)
(defparameter *trace-analytic-functions* nil)
(defparameter *trace-cycle-detection* nil)
(defparameter *trace-ignore-qdir* nil)
(defparameter *trace-unreachable-values-filter* nil)

(defparameter *ask-before-each-tsa-step* t)	; ask between steps
(defparameter *show-behaviors-during-tsa* nil)	; show progress during tsa simulation
(defparameter *trace-landmark-translation* nil)	; show landmark translation attempts

;;;  Curvature-constraint Control parameters

(defparameter *perform-acc-analysis* nil	"Perform automatic curvature constraint analysis")
(defparameter *auto-sd3-evaluation* t)
(defparameter *trace-auto-sd3-evaluation* nil	"Automatic 3rd-order derivative evaluation")
(defparameter *trace-acc* nil			"Trace intermediate steps in eval-cast")
(defparameter *trace-acc-filter-application* nil)	; RM 13 Feb 90

;;; Q2 Control

(defparameter *check-quantitative-ranges* nil	"Enable Q2 range reasoning")

;;; Time Scale Abstraction Control

(defparameter *check-abstracted-constraints* t)

;;; Similarity Control

(defparameter *check-for-similarity* nil)

;;; From constraints.lisp

(defparameter *quasi-equilibrium-reasoning* nil	"T=quasi-equilibrium, Nil=normal")


;;; For reports and tracing

(defparameter *QSIM-Report* t)
(defparameter *QSIM-Trace* t)
(defparameter *detailed-printing* nil		"T for detailed printing of structures")
(defparameter *short-qval-printing* nil
  "Print qvals in short format -- qmag,qdir -- where qdir is =, *, ?, up-arrow, or
  down-arrow.  Only done when *detailed-printing* is nil.")
(defparameter *record-all-transitions* nil
  "Non-nil to record all transitions in a list (transitions ...) in (state-status state)")

(defparameter *Time-stem* "T")


;;; Hook for extra initializations of *initial-state*

(defparameter *new-state-initializations* ()
  "List of functions which are FUNCALLed on initial-state")


;;; For NIC filtering

(defparameter *nic-notifications-p* t		"Display warning messages")
(defparameter *intersection-count* '((repeated-phase-point 0))
  "Counting Intersections for the NIC filtering")
(defparameter *apply-nic-p* nil			"Apply NIC constraint")
(defparameter *check-nic* t			"If Nil, disable NIC even when a phase plane clause is present")
(defparameter *prune-intersections-p* t		"NIC: Prune behaviors with intersections")
(defparameter *nic-trace-mode* nil		"NIC trace mode")
(defparameter *nic-trace-display* 'text-only	"NIC display mode")
(defparameter *intersection-count-p* nil	"Count intersections by phase planes")
(defparameter *confirm-when-present-p* nil	"Confirm when Phase-Planes clause is present")
(defparameter *dashp* t				"In genname, generate new symbols with dashes")


;;; For the energy constraint

(defparameter *perform-energy-analysis* nil)
(defparameter *trace-decomposition* t)
(defparameter *check-energy-constraint* t)
(defparameter *trace-energy-filter* nil)
(defparameter *trace-energy* nil)
(defparameter *trace-energy-detailed* nil)
(defparameter *traced-predicates* ())


;;; For aggregation algorithms

(defparameter *trace-aggregation* t
              "Turn on/off tracing of the aggregation algorithms")


;;;-----------------------------------------------------------------------------
;;; Note that 'Current-State' is sometimes bound to
;;; >> a freshly-minted "incomplete" state (it's status isn't marked and
;;;   it may or may not have all its values filled in); in which case the
;;;   tuples represent completions of that state, OR
;;; >> to a state which has been popped off the agenda and whose
;;;   successors are being generated.  Its status still isn't filled in.
;;;   The tuples represent values for possible successors of the state.
;;; *FILTERING-CONDITION*  allows us to differentiate these conditions.
;;;-----------------------------------------------------------------------------

(proclaim '(special current-state *known-constraint-types*))

(defparameter *filtering-condition* nil
  "Bound by callers of CFILTER so that constraints can understand
   the environment in which they are called.")

(defparameter *query-user* t	"Nil disables user queries for testing")


;;; *Define-Qde-Clauses* and *Other-Alist* are used in syntax checking 
;;; and in processing the DEFINE-QDE form.

(defparameter *define-qde-clauses*
	      '(quantity-spaces constraints independent history transitions
		print-names text layout other discrete-variables
		energy-constraint))

(defparameter *other-alist*
	      '(ignore-qdirs no-new-landmarks
		unreachable-values physical phase-planes
		normal-state abstracted-from faster 
		;; deleted initial-ranges from the list 'cuz its a defother
		;; slot now.  BKay 8Feb91
		                                    
		slower abstracted-to))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;   Special variables used in Occurrence Branch Elimination
;;;
;;;

(defparameter *detail-print-eq-node* nil)
(defparameter *detail-print-agg* nil)

(defparameter equiv-set-pt-list nil)                  ;; Use to determine if there is a complete
(defparameter *cur-equiv-set-pt* nil)                 ;; set of equivalence nodes.
(defparameter *aggregate-intervals* nil)              ;; Maintains a record of all of the aggregate intervals
(defparameter *match-histories* t)                    ;; Determines if the histories must be equal when combining them
(defparameter *filter-occ-branching* nil)             ;; Causes aggregate behaviors to be displayed
(defparameter *return-aggregates-as-successors* nil)  ;; Used to control the detection of aggregates 
                                                     ;; in the successor funtion   
(defparameter *agg-stack* nil)                        ;;  A stack of the aggregates which have been
                                                     ;;  expanded in this session.
(defparameter *deb-qual-equiv* nil)                  ;; Debug variables
(defparameter *deb-equiv-node* nil)


