;;; -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-
;;;  $Id: hod-system-property.lisp,v 1.1 91/03/26 21:37:57 clancy Exp $

(in-package 'QSIM)
;
; Author: Charles Chiu.
; This file is included at the revision of November 1988.
; See curvature.lisp for details.
;
; Modified curvature constraints: inclusion of system property specifications.  
; If the third element in "clist"  is non-nil, clist is not modified. 
(defun cast-clause-of-coupled-qdes(signs cast-clause qde)
    (setq cast-clause
	  (cond((null signs) cast-clause)
	       (t(mapcar #'(lambda(sign clist)
			     (cond((caddr clist) clist)
				  ((null sign) (insert-minus clist))
				  ((eql 0 sign)  (list (car clist) 0))
				  (t clist)))
			 (sign-list signs (length cast-clause)) cast-clause))))
    (setf (qde-curvature-at-steady qde)
	  (sublis (qde-var-alist qde) cast-clause))	;replace varnames with vars
    cast-clause)

(defun insert-minus(clist)
  (list (car clist)(cons 'minus (cdr clist))))

(defun sign-list(signs length-clause)
  (let((ls (length signs)))
    (cond((eql ls length-clause) signs)
	 (t (append signs (t-list (- length-clause ls)))))))

(defun t-list(n)
  (cond((not(plusp n)) nil)
       (t (cons 't (t-list (- n 1))))))

; Theorem: For coupled first order QDEs of two independent variables, 
; in the smoothness approximation, at the hod steady point, 
; the corresponding third derivative vanishes, i.e.  at (sd2 hod)=0, (sd3 hod)=0.
; This is implemented by setting the third slot of the element of sd3-clause to t. 

(defun sd3-clause-of-coupled-qdes(signs cast-clause qde)
  (let((sd3-clause (cond((null signs) nil)
			(t (mapcan #'(lambda(sign clist)
				       (if(eql 0 sign)(list (list (car clist) 0 t))))
				   signs cast-clause)))))
    (setf (qde-sd3-constraint qde)
	  (sublis (qde-var-alist qde) sd3-clause))	; replace varnames with vars
    sd3-clause))
